/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class GeneralAuthParameters<T extends GeneralAuthParameters>
extends GeneralParametersWithIV<T>
implements AuthenticationParametersWithIV<T> {
    protected final int macLenInBits;

    protected GeneralAuthParameters(GeneralAlgorithm generalAlgorithm, int n, byte[] byArray, int n2) {
        super(generalAlgorithm, n, byArray);
        this.macLenInBits = n2;
    }

    @Override
    public int getMACSizeInBits() {
        return this.macLenInBits;
    }

    @Override
    public T withIV(SecureRandom secureRandom, int n) {
        return (T)this.create((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createIvIfNecessary(n, secureRandom));
    }

    @Override
    public T withMACSize(int n) {
        return this.create((GeneralAlgorithm)this.getAlgorithm(), this.getIV(), n);
    }

    @Override
    protected T create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
        return this.create(generalAlgorithm, byArray, this.getMACSizeInBits());
    }

    abstract T create(GeneralAlgorithm var1, byte[] var2, int var3);
}

