/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;

@Processor(value=MLProcessorType.JSONPATH_FILTER)
public class MLJsonPathFilterProcessor
extends AbstractMLProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLJsonPathFilterProcessor.class);
    private final String path;
    private final Object defaultValue;

    public MLJsonPathFilterProcessor(Map<String, Object> config) {
        super(config);
        this.path = (String)config.get("path");
        this.defaultValue = config.get("default");
    }

    @Override
    protected void validateConfig() {
        if (!this.config.containsKey("path")) {
            throw new IllegalArgumentException("'path' is required for jsonpath_filter processor");
        }
        String pathValue = (String)this.config.get("path");
        if (pathValue == null || pathValue.trim().isEmpty()) {
            throw new IllegalArgumentException("'path' cannot be empty for jsonpath_filter processor");
        }
    }

    @Override
    public Object process(Object input) {
        try {
            String jsonStr = StringUtils.toJson((Object)input);
            return JsonPath.read((String)jsonStr, (String)this.path, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            log.debug("JsonPath '{}' not found in input", (Object)this.path);
            return this.defaultValue != null ? this.defaultValue : input;
        }
        catch (Exception e) {
            log.warn("Failed to apply JsonPath '{}': {}", (Object)this.path, (Object)e.getMessage());
            return this.defaultValue != null ? this.defaultValue : input;
        }
    }
}

