/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.function_calling;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.ml.engine.function_calling.BedrockConverseDeepseekR1FunctionCalling;
import org.opensearch.ml.engine.function_calling.BedrockConverseFunctionCalling;
import org.opensearch.ml.engine.function_calling.FunctionCalling;
import org.opensearch.ml.engine.function_calling.OpenaiV1ChatCompletionsFunctionCalling;

public class FunctionCallingFactory {
    public static FunctionCalling create(String llmInterface) {
        if (StringUtils.isBlank((CharSequence)llmInterface)) {
            return null;
        }
        switch (llmInterface.trim().toLowerCase(Locale.ROOT)) {
            case "bedrock/converse/claude": {
                return new BedrockConverseFunctionCalling();
            }
            case "openai/v1/chat/completions": {
                return new OpenaiV1ChatCompletionsFunctionCalling();
            }
            case "bedrock/converse/deepseek_r1": {
                return new BedrockConverseDeepseekR1FunctionCalling();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid _llm_interface: %s", llmInterface));
    }
}

