/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.anomalylocalization;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.output.execute.anomalylocalization.Counter;
import org.opensearch.ml.engine.algorithms.anomalylocalization.CountMinSketch;
import org.opensearch.ml.engine.algorithms.anomalylocalization.CountSketch;
import org.opensearch.ml.engine.algorithms.anomalylocalization.HashMapCounter;

public class HybridCounter
implements Counter {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridCounter.class);
    protected static int SKETCH_THRESHOLD = 10000;
    private Counter counter = new HashMapCounter();
    private int count = 0;

    public void increment(List<String> key, double value) {
        this.counter.increment(key, value);
        this.updateCount();
    }

    public double estimate(List<String> key) {
        return this.counter.estimate(key);
    }

    private void updateCount() {
        ++this.count;
        if (this.count == SKETCH_THRESHOLD) {
            Map<List<String>, Double> hashmap = ((HashMapCounter)this.counter).getKeyValues();
            boolean hasNegative = hashmap.values().stream().anyMatch(v -> v < 0.0);
            Object newCounter = hasNegative ? new CountSketch() : new CountMinSketch();
            hashmap.forEach((arg_0, arg_1) -> HybridCounter.lambda$updateCount$1((Counter)newCounter, arg_0, arg_1));
            this.counter = newCounter;
        }
    }

    private static /* synthetic */ void lambda$updateCount$1(Counter newCounter, List k, Double v) {
        newCounter.increment(k, v.doubleValue());
    }
}

