/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

public enum PayloadType {
    CONVERSATIONAL("conversational"),
    DATA("data");

    private final String value;

    private PayloadType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PayloadType fromString(String value) {
        if (value == null) {
            return null;
        }
        for (PayloadType type : PayloadType.values()) {
            if (!type.value.equalsIgnoreCase(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid working memory type: " + value + ". Must be one of: CONVERSATIONAL, DATA");
    }

    public String toString() {
        return this.value;
    }
}

