/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.grok.Grok;
import org.opensearch.grok.MatcherWatchdog;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public final class GrokProcessor
extends AbstractProcessor {
    public static final String TYPE = "grok";
    private static final String PATTERN_MATCH_KEY = "_ingest._grok_match_index";
    private static final Logger logger = LogManager.getLogger(GrokProcessor.class);
    private final String matchField;
    private final List<String> matchPatterns;
    private final Grok grok;
    private final boolean traceMatch;
    private final boolean ignoreMissing;
    private final boolean captureAllMatches;

    GrokProcessor(String tag, String description, Map<String, String> patternBank, List<String> matchPatterns, String matchField, boolean traceMatch, boolean ignoreMissing, boolean captureAllMatches, MatcherWatchdog matcherWatchdog) {
        super(tag, description);
        this.matchField = matchField;
        this.matchPatterns = matchPatterns;
        this.grok = new Grok(patternBank, GrokProcessor.combinePatterns(matchPatterns, traceMatch), matcherWatchdog, arg_0 -> ((Logger)logger).debug(arg_0), captureAllMatches);
        this.traceMatch = traceMatch;
        this.ignoreMissing = ignoreMissing;
        this.captureAllMatches = captureAllMatches;
        new Grok(patternBank, GrokProcessor.combinePatterns(matchPatterns, traceMatch), matcherWatchdog, arg_0 -> ((Logger)logger).warn(arg_0)).match("___nomatch___");
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        String fieldValue = (String)ingestDocument.getFieldValue(this.matchField, String.class, this.ignoreMissing);
        if (fieldValue == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (fieldValue == null) {
            throw new IllegalArgumentException("field [" + this.matchField + "] is null, cannot process it.");
        }
        Map matches = this.grok.captures(fieldValue);
        if (matches == null) {
            throw new IllegalArgumentException("Provided Grok expressions do not match field value: [" + fieldValue + "]");
        }
        matches.forEach((arg_0, arg_1) -> ((IngestDocument)ingestDocument).setFieldValue(arg_0, arg_1));
        if (this.traceMatch) {
            if (this.matchPatterns.size() > 1) {
                HashMap matchMap = (HashMap)ingestDocument.getFieldValue(PATTERN_MATCH_KEY, Object.class);
                matchMap.keySet().stream().findFirst().ifPresent(index -> ingestDocument.setFieldValue(PATTERN_MATCH_KEY, index));
            } else {
                ingestDocument.setFieldValue(PATTERN_MATCH_KEY, (Object)"0");
            }
        }
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    Grok getGrok() {
        return this.grok;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    String getMatchField() {
        return this.matchField;
    }

    List<String> getMatchPatterns() {
        return this.matchPatterns;
    }

    boolean isCaptureAllMatches() {
        return this.captureAllMatches;
    }

    static String combinePatterns(List<String> patterns, boolean traceMatch) {
        Object combinedPattern;
        if (patterns.size() > 1) {
            combinedPattern = "";
            for (int i = 0; i < patterns.size(); ++i) {
                String pattern = patterns.get(i);
                String valueWrap = traceMatch ? "(?<_ingest._grok_match_index." + i + ">" + pattern + ")" : "(?:" + patterns.get(i) + ")";
                combinedPattern = ((String)combinedPattern).equals("") ? valueWrap : (String)combinedPattern + "|" + valueWrap;
            }
        } else {
            combinedPattern = patterns.get(0);
        }
        return combinedPattern;
    }

    public static final class Factory
    implements Processor.Factory {
        private final Map<String, String> builtinPatterns;
        private final MatcherWatchdog matcherWatchdog;

        public Factory(Map<String, String> builtinPatterns, MatcherWatchdog matcherWatchdog) {
            this.builtinPatterns = builtinPatterns;
            this.matcherWatchdog = matcherWatchdog;
        }

        public GrokProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String matchField = ConfigurationUtils.readStringProperty((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"field");
            List matchPatterns = ConfigurationUtils.readList((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"patterns");
            boolean traceMatch = ConfigurationUtils.readBooleanProperty((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"trace_match", (boolean)false);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            boolean captureAllMatches = ConfigurationUtils.readBooleanProperty((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"capture_all_matches", (boolean)false);
            if (matchPatterns.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException((String)GrokProcessor.TYPE, (String)processorTag, (String)"patterns", (String)"List of patterns must not be empty");
            }
            Map customPatternBank = ConfigurationUtils.readOptionalMap((String)GrokProcessor.TYPE, (String)processorTag, config, (String)"pattern_definitions");
            HashMap<String, String> patternBank = new HashMap<String, String>(this.builtinPatterns);
            if (customPatternBank != null) {
                patternBank.putAll(customPatternBank);
            }
            try {
                return new GrokProcessor(processorTag, description, patternBank, matchPatterns, matchField, traceMatch, ignoreMissing, captureAllMatches, this.matcherWatchdog);
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException((String)GrokProcessor.TYPE, (String)processorTag, (String)"patterns", (String)("Invalid regex pattern found in: " + String.valueOf(matchPatterns) + ". " + e.getMessage()));
            }
        }
    }
}

