/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.DeleteMonitorRequest;
import org.opensearch.commons.alerting.action.DeleteMonitorResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

public class MonitorService {
    private static final Logger log = LogManager.getLogger(MonitorService.class);
    private Client client;

    public MonitorService() {
    }

    public MonitorService(Client client) {
        this.client = client;
    }

    public void deleteAlertingMonitors(List<String> monitorIds, WriteRequest.RefreshPolicy refreshPolicy, final ActionListener<List<DeleteMonitorResponse>> listener) {
        if (monitorIds == null || monitorIds.isEmpty()) {
            listener.onResponse(new ArrayList());
            return;
        }
        GroupedActionListener deletesListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<DeleteMonitorResponse>>(this){

            public void onResponse(Collection<DeleteMonitorResponse> responses) {
                SetOnce errorStatusSupplier = new SetOnce();
                if (responses.stream().filter(response -> {
                    if (response.getStatus() != RestStatus.OK) {
                        log.error("Monitor [{}] could not be deleted. Status [{}]", (Object)response.getId(), (Object)response.getStatus());
                        errorStatusSupplier.trySet((Object)response.getStatus());
                        return true;
                    }
                    return false;
                }).count() > 0L) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Monitor associated with detected could not be deleted", (RestStatus)errorStatusSupplier.get(), new Object[0]));
                }
                listener.onResponse(responses.stream().collect(Collectors.toList()));
            }

            public void onFailure(Exception e) {
                log.error("Error deleting monitors", (Object[])e.getSuppressed());
                listener.onFailure(e);
            }
        }, monitorIds.size());
        for (String monitorId : monitorIds) {
            this.deleteAlertingMonitor(monitorId, refreshPolicy, (ActionListener<DeleteMonitorResponse>)deletesListener);
        }
    }

    private void deleteAlertingMonitor(String monitorId, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DeleteMonitorResponse> listener) {
        DeleteMonitorRequest request = new DeleteMonitorRequest(monitorId, refreshPolicy);
        AlertingPluginInterface.INSTANCE.deleteMonitor((NodeClient)this.client, request, listener);
    }
}

