/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.DeleteCustomLogTypeRequest;
import org.opensearch.securityanalytics.action.DeleteCustomLogTypeResponse;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.CustomLogTypeIndices;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.RuleIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportDeleteCustomLogTypeAction
extends HandledTransportAction<DeleteCustomLogTypeRequest, DeleteCustomLogTypeResponse>
implements SecureTransportAction {
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final DetectorIndices detectorIndices;
    private final RuleIndices ruleIndices;
    private final CustomLogTypeIndices customLogTypeIndices;
    private volatile Boolean filterByEnabled;
    private volatile TimeValue indexTimeout;

    @Inject
    public TransportDeleteCustomLogTypeAction(TransportService transportService, Client client, ActionFilters actionFilters, ClusterService clusterService, DetectorIndices detectorIndices, RuleIndices ruleIndices, CustomLogTypeIndices customLogTypeIndices, Settings settings, ThreadPool threadPool) {
        super("cluster:admin/opensearch/securityanalytics/logtype/delete", transportService, actionFilters, DeleteCustomLogTypeRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.settings = settings;
        this.detectorIndices = detectorIndices;
        this.ruleIndices = ruleIndices;
        this.customLogTypeIndices = customLogTypeIndices;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.indexTimeout = (TimeValue)SecurityAnalyticsSettings.INDEX_TIMEOUT.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.INDEX_TIMEOUT, this::setIndexTimeout);
    }

    protected void doExecute(Task task, DeleteCustomLogTypeRequest request, ActionListener<DeleteCustomLogTypeResponse> listener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(validateBackendRoleMessage, RestStatus.FORBIDDEN, new Object[0]))));
            return;
        }
        this.threadPool.getThreadContext().stashContext();
        AsyncDeleteCustomLogTypeAction deleteCustomLogTypeAction = new AsyncDeleteCustomLogTypeAction(task, request, listener);
        deleteCustomLogTypeAction.start();
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }

    private void setIndexTimeout(TimeValue indexTimeout) {
        this.indexTimeout = indexTimeout;
    }

    class AsyncDeleteCustomLogTypeAction {
        private final DeleteCustomLogTypeRequest request;
        private final ActionListener<DeleteCustomLogTypeResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private Task task;

        AsyncDeleteCustomLogTypeAction(Task task, DeleteCustomLogTypeRequest request, ActionListener<DeleteCustomLogTypeResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
        }

        void start() {
            if (!TransportDeleteCustomLogTypeAction.this.customLogTypeIndices.customLogTypeIndexExists()) {
                this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s is not found", this.request.getLogTypeId()), RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            final String logTypeId = this.request.getLogTypeId();
            GetRequest getRequest = new GetRequest(".opensearch-sap-log-types-config", logTypeId);
            TransportDeleteCustomLogTypeAction.this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this){
                final /* synthetic */ AsyncDeleteCustomLogTypeAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void onResponse(GetResponse response) {
                    if (!response.isExists()) {
                        this.this$1.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s is not found", logTypeId), RestStatus.NOT_FOUND, new Object[0]));
                        return;
                    }
                    Map sourceMap = response.getSourceAsMap();
                    CustomLogType logType = new CustomLogType(sourceMap);
                    logType.setId(response.getId());
                    logType.setVersion(response.getVersion());
                    this.this$1.onGetResponse(logType);
                }

                public void onFailure(Exception e) {
                    this.this$1.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s is not found", logTypeId), RestStatus.NOT_FOUND, new Object[0]));
                }
            });
        }

        private void onGetResponse(final CustomLogType logType) {
            if (logType.getSource().equals("Sigma")) {
                this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s cannot be deleted because source is sigma", logType.getId()), RestStatus.BAD_REQUEST, new Object[0]));
            }
            if (TransportDeleteCustomLogTypeAction.this.detectorIndices.detectorIndexExists()) {
                this.searchDetectors(logType.getName(), new ActionListener<SearchResponse>(this){
                    final /* synthetic */ AsyncDeleteCustomLogTypeAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void onResponse(SearchResponse response) {
                        if (response.isTimedOut()) {
                            this.this$1.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Search request timed out. Log Type with id %s cannot be deleted", logType.getId()), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                            return;
                        }
                        if (response.getHits().getTotalHits().value() > 0L) {
                            this.this$1.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s cannot be deleted because active detectors exist", logType.getId()), RestStatus.BAD_REQUEST, new Object[0]));
                            return;
                        }
                        this.this$1.checkRuleIndexAndDeleteLogType(logType);
                    }

                    public void onFailure(Exception e) {
                        this.this$1.onFailures(e);
                    }
                });
            } else {
                this.checkRuleIndexAndDeleteLogType(logType);
            }
        }

        void checkRuleIndexAndDeleteLogType(final CustomLogType logType) {
            if (TransportDeleteCustomLogTypeAction.this.ruleIndices.ruleIndexExists(false)) {
                TransportDeleteCustomLogTypeAction.this.ruleIndices.searchRules(logType.getName(), new ActionListener<SearchResponse>(this){
                    final /* synthetic */ AsyncDeleteCustomLogTypeAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void onResponse(SearchResponse response) {
                        if (response.isTimedOut()) {
                            this.this$1.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Search request timed out. Log Type with id %s cannot be deleted", logType.getId()), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                            return;
                        }
                        if (response.getHits().getTotalHits().value() > 0L) {
                            this.this$1.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s cannot be deleted because active rules exist", logType.getId()), RestStatus.BAD_REQUEST, new Object[0]));
                            return;
                        }
                        this.this$1.deleteLogType(logType);
                    }

                    public void onFailure(Exception e) {
                        if (e instanceof IndexNotFoundException) {
                            this.this$1.deleteLogType(logType);
                        } else {
                            this.this$1.onFailures(e);
                        }
                    }
                });
            } else {
                SecureTransportAction.log.warn("Custom rule index missing, allowing deletion of custom log type {} to go through", (Object)logType.getId());
                this.deleteLogType(logType);
            }
        }

        private void deleteLogType(final CustomLogType logType) {
            DeleteRequest deleteRequest = (DeleteRequest)((DeleteRequest)new DeleteRequest(".opensearch-sap-log-types-config", logType.getId()).setRefreshPolicy(this.request.getRefreshPolicy())).timeout(TransportDeleteCustomLogTypeAction.this.indexTimeout);
            TransportDeleteCustomLogTypeAction.this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(this){
                final /* synthetic */ AsyncDeleteCustomLogTypeAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void onResponse(DeleteResponse response) {
                    if (response.status() != RestStatus.OK) {
                        this.this$1.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s cannot be deleted", logType.getId()), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    }
                    this.this$1.onOperation(response);
                }

                public void onFailure(Exception e) {
                    this.this$1.onFailures(e);
                }
            });
        }

        private void searchDetectors(String logTypeName, ActionListener<SearchResponse> listener) {
            NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"detector", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"detector.detector_type", (Object)logTypeName)), (ScoreMode)ScoreMode.Avg);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-detectors-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(0));
            TransportDeleteCustomLogTypeAction.this.client.search(searchRequest, listener);
        }

        private void onOperation(DeleteResponse response) {
            this.response.set(response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(response.getId(), null);
            }
        }

        private void onFailures(Exception t) {
            SecureTransportAction.log.error(String.format(Locale.ROOT, "Failed to delete log type", new Object[0]), (Throwable)t);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(String logTypeId, Exception t) {
            TransportDeleteCustomLogTypeAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    SecureTransportAction.log.error(String.format(Locale.ROOT, "Failed to delete log type %s", logTypeId), (Throwable)t);
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return new DeleteCustomLogTypeResponse(logTypeId, Detector.NO_VERSION, RestStatus.NO_CONTENT);
            }));
        }
    }
}

