/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.services;

import com.amazonaws.services.s3.AmazonS3;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.securityanalytics.commons.connector.Connector;
import org.opensearch.securityanalytics.commons.connector.S3Connector;
import org.opensearch.securityanalytics.commons.connector.codec.InputCodec;
import org.opensearch.securityanalytics.commons.connector.factory.InputCodecFactory;
import org.opensearch.securityanalytics.commons.connector.factory.S3ClientFactory;
import org.opensearch.securityanalytics.commons.connector.model.S3ConnectorConfig;
import org.opensearch.securityanalytics.commons.factory.UnaryParameterCachingFactory;
import org.opensearch.securityanalytics.commons.model.FeedConfiguration;
import org.opensearch.securityanalytics.commons.model.FeedLocation;
import org.opensearch.securityanalytics.commons.model.STIX2;
import org.opensearch.securityanalytics.services.JsonPathAwareInputCodec;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import software.amazon.awssdk.services.s3.S3Client;

public class STIX2IOCConnectorFactory
extends UnaryParameterCachingFactory<FeedConfiguration, Connector<STIX2>> {
    private static final Logger logger = LogManager.getLogger(STIX2IOCConnectorFactory.class);
    private final InputCodecFactory inputCodecFactory;
    private final S3ClientFactory s3ClientFactory;

    public STIX2IOCConnectorFactory(InputCodecFactory inputCodecFactory, S3ClientFactory s3ClientFactory) {
        this.inputCodecFactory = inputCodecFactory;
        this.s3ClientFactory = s3ClientFactory;
    }

    protected Connector<STIX2> doCreate(FeedConfiguration feedConfiguration) {
        FeedLocation feedLocation = FeedLocation.fromFeedConfiguration((FeedConfiguration)feedConfiguration);
        logger.debug("FeedLocation: {}", (Object)feedLocation);
        switch (feedLocation) {
            case S3: {
                return this.createS3Connector(feedConfiguration, null);
            }
        }
        throw new IllegalArgumentException("Unsupported feedLocation: " + String.valueOf(feedLocation));
    }

    protected Connector<STIX2> doCreate(FeedConfiguration feedConfiguration, SATIFSourceConfig satifSourceConfig) {
        FeedLocation feedLocation = FeedLocation.fromFeedConfiguration((FeedConfiguration)feedConfiguration);
        logger.debug("FeedLocation: {}", (Object)feedLocation);
        switch (feedLocation) {
            case S3: {
                return this.createS3Connector(feedConfiguration, satifSourceConfig);
            }
        }
        throw new IllegalArgumentException("Unsupported feedLocation: " + String.valueOf(feedLocation));
    }

    private S3Connector<STIX2> createS3Connector(FeedConfiguration feedConfiguration, SATIFSourceConfig satifSourceConfig) {
        InputCodec inputCodec = this.getInputCodec(feedConfiguration, satifSourceConfig);
        S3ConnectorConfig s3ConnectorConfig = feedConfiguration.getS3ConnectorConfig();
        S3Client s3Client = (S3Client)this.s3ClientFactory.create((Object)s3ConnectorConfig.getRoleArn(), (Object)s3ConnectorConfig.getRegion());
        return new S3Connector(s3ConnectorConfig, s3Client, inputCodec);
    }

    private InputCodec getInputCodec(FeedConfiguration feedConfiguration, SATIFSourceConfig satifSourceConfig) {
        InputCodec inputCodec;
        if (satifSourceConfig != null && satifSourceConfig.getIocSchema() != null) {
            logger.info("Parsing custom schema JSON from S3 for threat intel source [{}]", (Object)satifSourceConfig.getName());
            inputCodec = new JsonPathAwareInputCodec(satifSourceConfig);
        } else {
            inputCodec = (InputCodec)this.inputCodecFactory.create((Object)feedConfiguration.getIocSchema().getModelClass(), (Object)feedConfiguration.getInputCodecSchema());
        }
        return inputCodec;
    }

    public S3Connector<STIX2> createAmazonS3Connector(FeedConfiguration feedConfiguration, List<String> clusterTuple, SATIFSourceConfig satifSourceConfig) {
        InputCodec inputCodec = this.getInputCodec(feedConfiguration, satifSourceConfig);
        S3ConnectorConfig s3ConnectorConfig = feedConfiguration.getS3ConnectorConfig();
        AmazonS3 s3Client = this.s3ClientFactory.createAmazonS3(s3ConnectorConfig.getRoleArn(), s3ConnectorConfig.getRegion(), clusterTuple);
        return new S3Connector(s3ConnectorConfig, s3Client, inputCodec);
    }
}

