/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;
import org.opensearch.securityanalytics.model.CustomLogType;

public class IndexCustomLogTypeRequest
extends ActionRequest {
    private String logTypeId;
    private WriteRequest.RefreshPolicy refreshPolicy;
    private RestRequest.Method method;
    private CustomLogType customLogType;
    private static final Pattern IS_VALID_CUSTOM_LOG_NAME = Pattern.compile("[a-z0-9_-]{2,50}");

    public IndexCustomLogTypeRequest(String logTypeId, WriteRequest.RefreshPolicy refreshPolicy, RestRequest.Method method, CustomLogType customLogType) {
        this.logTypeId = logTypeId;
        this.refreshPolicy = refreshPolicy;
        this.method = method;
        this.customLogType = customLogType;
    }

    public IndexCustomLogTypeRequest(StreamInput sin) throws IOException {
        this(sin.readString(), WriteRequest.RefreshPolicy.readFrom((StreamInput)sin), (RestRequest.Method)sin.readEnum(RestRequest.Method.class), CustomLogType.readFrom(sin));
    }

    public ActionRequestValidationException validate() {
        Matcher matcher = IS_VALID_CUSTOM_LOG_NAME.matcher(this.customLogType.getName());
        boolean find = matcher.matches();
        if (!find) {
            throw new ActionRequestValidationException();
        }
        String category = this.customLogType.getCategory();
        if (!CustomLogType.VALID_LOG_CATEGORIES.contains(category)) {
            throw new ActionRequestValidationException();
        }
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.logTypeId);
        this.refreshPolicy.writeTo(out);
        out.writeEnum((Enum)this.method);
        this.customLogType.writeTo(out);
    }

    public String getLogTypeId() {
        return this.logTypeId;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public RestRequest.Method getMethod() {
        return this.method;
    }

    public CustomLogType getCustomLogType() {
        return this.customLogType;
    }
}

