/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.keystore.model.KMSConfiguration;

public class GetKeyStoreInfoOutput {
    private final String keyStoreId;
    private final String keyStoreName;
    private final String logicalKeyStoreName;
    private final List<String> grantTokens;
    private final KMSConfiguration kmsConfiguration;

    protected GetKeyStoreInfoOutput(BuilderImpl builder) {
        this.keyStoreId = builder.keyStoreId();
        this.keyStoreName = builder.keyStoreName();
        this.logicalKeyStoreName = builder.logicalKeyStoreName();
        this.grantTokens = builder.grantTokens();
        this.kmsConfiguration = builder.kmsConfiguration();
    }

    public String keyStoreId() {
        return this.keyStoreId;
    }

    public String keyStoreName() {
        return this.keyStoreName;
    }

    public String logicalKeyStoreName() {
        return this.logicalKeyStoreName;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public KMSConfiguration kmsConfiguration() {
        return this.kmsConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String keyStoreId;
        protected String keyStoreName;
        protected String logicalKeyStoreName;
        protected List<String> grantTokens;
        protected KMSConfiguration kmsConfiguration;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetKeyStoreInfoOutput model) {
            this.keyStoreId = model.keyStoreId();
            this.keyStoreName = model.keyStoreName();
            this.logicalKeyStoreName = model.logicalKeyStoreName();
            this.grantTokens = model.grantTokens();
            this.kmsConfiguration = model.kmsConfiguration();
        }

        @Override
        public Builder keyStoreId(String keyStoreId) {
            this.keyStoreId = keyStoreId;
            return this;
        }

        @Override
        public String keyStoreId() {
            return this.keyStoreId;
        }

        @Override
        public Builder keyStoreName(String keyStoreName) {
            this.keyStoreName = keyStoreName;
            return this;
        }

        @Override
        public String keyStoreName() {
            return this.keyStoreName;
        }

        @Override
        public Builder logicalKeyStoreName(String logicalKeyStoreName) {
            this.logicalKeyStoreName = logicalKeyStoreName;
            return this;
        }

        @Override
        public String logicalKeyStoreName() {
            return this.logicalKeyStoreName;
        }

        @Override
        public Builder grantTokens(List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        @Override
        public List<String> grantTokens() {
            return this.grantTokens;
        }

        @Override
        public Builder kmsConfiguration(KMSConfiguration kmsConfiguration) {
            this.kmsConfiguration = kmsConfiguration;
            return this;
        }

        @Override
        public KMSConfiguration kmsConfiguration() {
            return this.kmsConfiguration;
        }

        @Override
        public GetKeyStoreInfoOutput build() {
            if (Objects.isNull(this.keyStoreId())) {
                throw new IllegalArgumentException("Missing value for required field `keyStoreId`");
            }
            if (Objects.isNull(this.keyStoreName())) {
                throw new IllegalArgumentException("Missing value for required field `keyStoreName`");
            }
            if (Objects.nonNull(this.keyStoreName()) && this.keyStoreName().length() < 3) {
                throw new IllegalArgumentException("The size of `keyStoreName` must be greater than or equal to 3");
            }
            if (Objects.nonNull(this.keyStoreName()) && this.keyStoreName().length() > 255) {
                throw new IllegalArgumentException("The size of `keyStoreName` must be less than or equal to 255");
            }
            if (Objects.isNull(this.logicalKeyStoreName())) {
                throw new IllegalArgumentException("Missing value for required field `logicalKeyStoreName`");
            }
            if (Objects.isNull(this.grantTokens())) {
                throw new IllegalArgumentException("Missing value for required field `grantTokens`");
            }
            if (Objects.isNull(this.kmsConfiguration())) {
                throw new IllegalArgumentException("Missing value for required field `kmsConfiguration`");
            }
            return new GetKeyStoreInfoOutput(this);
        }
    }

    public static interface Builder {
        public Builder keyStoreId(String var1);

        public String keyStoreId();

        public Builder keyStoreName(String var1);

        public String keyStoreName();

        public Builder logicalKeyStoreName(String var1);

        public String logicalKeyStoreName();

        public Builder grantTokens(List<String> var1);

        public List<String> grantTokens();

        public Builder kmsConfiguration(KMSConfiguration var1);

        public KMSConfiguration kmsConfiguration();

        public GetKeyStoreInfoOutput build();
    }
}

