/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.action.SearchEmailGroupAction;
import org.opensearch.alerting.model.destination.email.EmailGroup;
import org.opensearch.alerting.util.RestHandlerUtilsKt;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/alerting/resthandler/RestSearchEmailGroupAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "searchEmailGroupResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/action/search/SearchResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "opensearch-alerting"})
public final class RestSearchEmailGroupAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "search_email_group_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.POST, AlertingPlugin.EMAIL_GROUP_BASE_URI + "/_search", RestRequest.Method.POST, AlertingPlugin.LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI + "/_search"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, AlertingPlugin.EMAIL_GROUP_BASE_URI + "/_search", RestRequest.Method.GET, AlertingPlugin.LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI + "/_search")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestHandlerUtilsKt.context(request));
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter((QueryBuilder)QueryBuilders.existsQuery((String)"email_group"))).seqNoAndPrimaryTerm(Boolean.valueOf(true));
        String[] stringArray = new String[]{".opendistro-alerting-config"};
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(stringArray);
        return arg_0 -> RestSearchEmailGroupAction.prepareRequest$lambda$0(client, searchRequest, this, arg_0);
    }

    private final RestResponseListener<SearchResponse> searchEmailGroupResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<SearchResponse>(channel){
            final /* synthetic */ RestChannel $channel;
            {
                this.$channel = $channel;
                super($channel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RestResponse buildResponse(SearchResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (response2.isTimedOut()) {
                    return (RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response2.toString());
                }
                Iterator iterator = response2.getHits().iterator();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    SearchHit hit = (SearchHit)iterator2.next();
                    Closeable closeable = (Closeable)XContentType.JSON.xContent().createParser(this.$channel.request().getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                    Throwable throwable = null;
                    try {
                        XContentParser hitsParser = (XContentParser)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)hitsParser);
                        String string = hit.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        EmailGroup emailGroup = EmailGroup.Companion.parseWithType(hitsParser, string, hit.getVersion());
                        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
                        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                        XContentBuilder xcb = emailGroup.toXContent(xContentBuilder, params);
                        SearchHit searchHit = hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                return (RestResponse)new BytesRestResponse(RestStatus.OK, response2.toXContent(this.$channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, SearchRequest $searchRequest, RestSearchEmailGroupAction this$0, RestChannel channel) {
        ActionType actionType = SearchEmailGroupAction.Companion.getINSTANCE();
        ActionRequest actionRequest = (ActionRequest)$searchRequest;
        Intrinsics.checkNotNull((Object)channel);
        $client.execute(actionType, actionRequest, (ActionListener)this$0.searchEmailGroupResponse(channel));
    }
}

