/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.modelv2;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.modelv2.TriggerV2;
import org.opensearch.common.UUIDs;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 W2\u00020\u0001:\u0004TUVWB{\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018B\u0011\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0004\b\u0017\u0010\u001bJ\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u001a\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002092\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0014\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010?0>J\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\t\u0010A\u001a\u00020\u0003H\u00c6\u0003J\t\u0010B\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010C\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\"J\t\u0010D\u001a\u00020\bH\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\t\u0010G\u001a\u00020\u0010H\u00c6\u0003J\t\u0010H\u001a\u00020\u0012H\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\u0010\u0010J\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\"J\u000b\u0010K\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0096\u0001\u0010L\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010MJ\u0013\u0010N\u001a\u00020O2\b\u0010P\u001a\u0004\u0018\u00010?H\u00d6\u0003J\t\u0010Q\u001a\u00020RH\u00d6\u0001J\t\u0010S\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b!\u0010\"R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0015\u0010\u0015\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b2\u0010\"R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001d\u00a8\u0006X"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLTrigger;", "Lorg/opensearch/alerting/modelv2/TriggerV2;", "id", "", "name", "severity", "Lorg/opensearch/alerting/modelv2/TriggerV2$Severity;", "throttleDuration", "", "expireDuration", "lastTriggeredTime", "Ljava/time/Instant;", "actions", "", "Lorg/opensearch/commons/alerting/model/action/Action;", "mode", "Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$TriggerMode;", "conditionType", "Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$ConditionType;", "numResultsCondition", "Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$NumResultsCondition;", "numResultsValue", "customCondition", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/alerting/modelv2/TriggerV2$Severity;Ljava/lang/Long;JLjava/time/Instant;Ljava/util/List;Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$TriggerMode;Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$ConditionType;Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$NumResultsCondition;Ljava/lang/Long;Ljava/lang/String;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getId", "()Ljava/lang/String;", "getName", "getSeverity", "()Lorg/opensearch/alerting/modelv2/TriggerV2$Severity;", "getThrottleDuration", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getExpireDuration", "()J", "getLastTriggeredTime", "()Ljava/time/Instant;", "setLastTriggeredTime", "(Ljava/time/Instant;)V", "getActions", "()Ljava/util/List;", "getMode", "()Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$TriggerMode;", "getConditionType", "()Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$ConditionType;", "getNumResultsCondition", "()Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$NumResultsCondition;", "getNumResultsValue", "getCustomCondition", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "asTemplateArg", "", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "copy", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/alerting/modelv2/TriggerV2$Severity;Ljava/lang/Long;JLjava/time/Instant;Ljava/util/List;Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$TriggerMode;Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$ConditionType;Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$NumResultsCondition;Ljava/lang/Long;Ljava/lang/String;)Lorg/opensearch/alerting/modelv2/PPLSQLTrigger;", "equals", "", "other", "hashCode", "", "toString", "TriggerMode", "ConditionType", "NumResultsCondition", "Companion", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nPPLSQLTrigger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,414:1\n1#2:415\n1869#3,2:416\n1563#3:422\n1634#3,3:423\n37#4:418\n36#4,3:419\n*S KotlinDebug\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger\n*L\n110#1:416,2\n221#1:422\n221#1:423,3\n204#1:418\n204#1:419,3\n*E\n"})
public final class PPLSQLTrigger
implements TriggerV2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final TriggerV2.Severity severity;
    @Nullable
    private final Long throttleDuration;
    private final long expireDuration;
    @Nullable
    private Instant lastTriggeredTime;
    @NotNull
    private final List<Action> actions;
    @NotNull
    private final TriggerMode mode;
    @NotNull
    private final ConditionType conditionType;
    @Nullable
    private final NumResultsCondition numResultsCondition;
    @Nullable
    private final Long numResultsValue;
    @Nullable
    private final String customCondition;
    @NotNull
    public static final String PPL_SQL_TRIGGER_FIELD = "ppl_trigger";
    @NotNull
    public static final String MODE_FIELD = "mode";
    @NotNull
    public static final String CONDITION_TYPE_FIELD = "type";
    @NotNull
    public static final String NUM_RESULTS_CONDITION_FIELD = "num_results_condition";
    @NotNull
    public static final String NUM_RESULTS_VALUE_FIELD = "num_results_value";
    @NotNull
    public static final String CUSTOM_CONDITION_FIELD = "custom_condition";
    @NotNull
    private static final Regex validCharsRegex = new Regex("^[a-zA-Z0-9_-]+$");
    @NotNull
    private static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(TriggerV2.class, new ParseField("ppl_trigger", new String[0]), PPLSQLTrigger::XCONTENT_REGISTRY$lambda$27);

    public PPLSQLTrigger(@NotNull String id, @NotNull String name, @NotNull TriggerV2.Severity severity, @Nullable Long throttleDuration, long expireDuration, @Nullable Instant lastTriggeredTime, @NotNull List<Action> actions, @NotNull TriggerMode mode, @NotNull ConditionType conditionType, @Nullable NumResultsCondition numResultsCondition, @Nullable Long numResultsValue, @Nullable String customCondition) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)MODE_FIELD);
        Intrinsics.checkNotNullParameter((Object)((Object)conditionType), (String)"conditionType");
        this.id = id;
        this.name = name;
        this.severity = severity;
        this.throttleDuration = throttleDuration;
        this.expireDuration = expireDuration;
        this.lastTriggeredTime = lastTriggeredTime;
        this.actions = actions;
        this.mode = mode;
        this.conditionType = conditionType;
        this.numResultsCondition = numResultsCondition;
        this.numResultsValue = numResultsValue;
        this.customCondition = customCondition;
        if (this.getName() == null) {
            boolean $i$a$-requireNotNull-PPLSQLTrigger$52 = false;
            String $i$a$-requireNotNull-PPLSQLTrigger$52 = "Trigger name must be included.";
            throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$52.toString());
        }
        if (this.getSeverity() == null) {
            boolean $i$a$-requireNotNull-PPLSQLTrigger$62 = false;
            String $i$a$-requireNotNull-PPLSQLTrigger$62 = "Trigger severity must be included.";
            throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$62.toString());
        }
        if (this.mode == null) {
            boolean $i$a$-requireNotNull-PPLSQLTrigger$72 = false;
            String $i$a$-requireNotNull-PPLSQLTrigger$72 = "Trigger mode must be included.";
            throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$72.toString());
        }
        if (this.conditionType == null) {
            boolean $i$a$-requireNotNull-PPLSQLTrigger$82 = false;
            String $i$a$-requireNotNull-PPLSQLTrigger$82 = "Trigger condition type must be included.";
            throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$82.toString());
        }
        if (!(this.getId().length() <= 20)) {
            boolean $i$a$-require-PPLSQLTrigger$82 = false;
            String $i$a$-require-PPLSQLTrigger$82 = "Trigger ID too long, length must be less than 20.";
            throw new IllegalArgumentException($i$a$-require-PPLSQLTrigger$82.toString());
        }
        if (!(this.getName().length() <= 30)) {
            boolean $i$a$-require-PPLSQLTrigger$92 = false;
            String $i$a$-require-PPLSQLTrigger$92 = "Trigger name too long, length must be less than 30.";
            throw new IllegalArgumentException($i$a$-require-PPLSQLTrigger$92.toString());
        }
        if (!(this.getExpireDuration() >= 1L)) {
            boolean $i$a$-require-PPLSQLTrigger$102 = false;
            String $i$a$-require-PPLSQLTrigger$102 = "expire duration cannot be less than 1, was " + this.getExpireDuration() + ".";
            throw new IllegalArgumentException($i$a$-require-PPLSQLTrigger$102.toString());
        }
        Long l = this.getThrottleDuration();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            if (!(it >= 1L)) {
                boolean $i$a$-require-PPLSQLTrigger$8$22 = false;
                String $i$a$-require-PPLSQLTrigger$8$22 = "Throttle duration cannot be less than 1, was " + this.getThrottleDuration() + ".";
                throw new IllegalArgumentException($i$a$-require-PPLSQLTrigger$8$22.toString());
            }
        }
        Iterable $this$forEach$iv = this.getActions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Action it = (Action)element$iv;
            boolean bl = false;
            if (!(it.getName().length() <= 30)) {
                boolean $i$a$-require-PPLSQLTrigger$9$52 = false;
                String $i$a$-require-PPLSQLTrigger$9$52 = "Name of action with ID " + it.getId() + " too long, length must be less than 30.";
                throw new IllegalArgumentException($i$a$-require-PPLSQLTrigger$9$52.toString());
            }
            if (!(it.getDestinationId().length() <= 512)) {
                boolean $i$a$-require-PPLSQLTrigger$9$62 = false;
                String $i$a$-require-PPLSQLTrigger$9$62 = "Channel ID of action with ID " + it.getId() + " too long, length must be less than 512.";
                throw new IllegalArgumentException($i$a$-require-PPLSQLTrigger$9$62.toString());
            }
            if (!(((CharSequence)it.getDestinationId()).length() > 0)) {
                boolean $i$a$-require-PPLSQLTrigger$9$72 = false;
                String $i$a$-require-PPLSQLTrigger$9$72 = "Channel ID should not be empty.";
                throw new IllegalArgumentException($i$a$-require-PPLSQLTrigger$9$72.toString());
            }
            if (validCharsRegex.matches((CharSequence)it.getDestinationId())) continue;
            boolean bl2 = false;
            String string = "Channel ID should only have alphanumeric characters, dashes, and underscores.";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.conditionType.ordinal()]) {
            case 1: {
                if (this.numResultsCondition == null) {
                    boolean $i$a$-requireNotNull-PPLSQLTrigger$122 = false;
                    String $i$a$-requireNotNull-PPLSQLTrigger$122 = "if trigger condition is of type " + ConditionType.NUMBER_OF_RESULTS.getValue() + ", num_results_condition must be included.";
                    throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$122.toString());
                }
                if (this.numResultsValue == null) {
                    boolean $i$a$-requireNotNull-PPLSQLTrigger$142 = false;
                    String $i$a$-requireNotNull-PPLSQLTrigger$142 = "if trigger condition is of type " + ConditionType.NUMBER_OF_RESULTS.getValue() + ", num_results_value must be included.";
                    throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$142.toString());
                }
                if (this.customCondition == null) break;
                boolean $i$a$-require-PPLSQLTrigger$132 = false;
                String $i$a$-require-PPLSQLTrigger$132 = "if trigger condition is of type " + ConditionType.NUMBER_OF_RESULTS.getValue() + ", custom_condition must not be included.";
                throw new IllegalArgumentException($i$a$-require-PPLSQLTrigger$132.toString());
            }
            case 2: {
                if (this.customCondition == null) {
                    boolean $i$a$-requireNotNull-PPLSQLTrigger$152 = false;
                    String $i$a$-requireNotNull-PPLSQLTrigger$152 = "if trigger condition is of type " + ConditionType.CUSTOM.getValue() + ", custom_condition must be included.";
                    throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$152.toString());
                }
                if (!(this.numResultsCondition == null)) {
                    boolean $i$a$-require-PPLSQLTrigger$172 = false;
                    String $i$a$-require-PPLSQLTrigger$172 = "if trigger condition is of type " + ConditionType.CUSTOM.getValue() + ", num_results_condition must not be included.";
                    throw new IllegalArgumentException($i$a$-require-PPLSQLTrigger$172.toString());
                }
                if (this.numResultsValue == null) break;
                boolean bl = false;
                String string = "if trigger condition is of type " + ConditionType.CUSTOM.getValue() + ", num_results_value must not be included.";
                throw new IllegalArgumentException(string.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (this.conditionType == ConditionType.NUMBER_OF_RESULTS) {
            Long l2 = this.numResultsValue;
            Intrinsics.checkNotNull((Object)l2);
            if (!(l2 >= 0L)) {
                boolean bl = false;
                String string = "Number of results to check for cannot be negative.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ PPLSQLTrigger(String string, String string2, TriggerV2.Severity severity, Long l, long l2, Instant instant, List list, TriggerMode triggerMode, ConditionType conditionType, NumResultsCondition numResultsCondition, Long l3, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string4 = UUIDs.base64UUID();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"base64UUID(...)");
            string = string4;
        }
        if ((n & 0x10) != 0) {
            l2 = 10080L;
        }
        this(string, string2, severity, l, l2, instant, list, triggerMode, conditionType, numResultsCondition, l3, string3);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public TriggerV2.Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public Long getThrottleDuration() {
        return this.throttleDuration;
    }

    @Override
    public long getExpireDuration() {
        return this.expireDuration;
    }

    @Override
    @Nullable
    public Instant getLastTriggeredTime() {
        return this.lastTriggeredTime;
    }

    @Override
    public void setLastTriggeredTime(@Nullable Instant instant) {
        this.lastTriggeredTime = instant;
    }

    @Override
    @NotNull
    public List<Action> getActions() {
        return this.actions;
    }

    @NotNull
    public final TriggerMode getMode() {
        return this.mode;
    }

    @NotNull
    public final ConditionType getConditionType() {
        return this.conditionType;
    }

    @Nullable
    public final NumResultsCondition getNumResultsCondition() {
        return this.numResultsCondition;
    }

    @Nullable
    public final Long getNumResultsValue() {
        return this.numResultsValue;
    }

    @Nullable
    public final String getCustomCondition() {
        return this.customCondition;
    }

    public PPLSQLTrigger(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        Enum enum_ = sin.readEnum(TriggerV2.Severity.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        TriggerV2.Severity severity = (TriggerV2.Severity)enum_;
        Long l = sin.readOptionalLong();
        long l2 = sin.readLong();
        Instant instant = sin.readOptionalInstant();
        List list = sin.readList(Action::new);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        Enum enum_2 = sin.readEnum(TriggerMode.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_2, (String)"readEnum(...)");
        TriggerMode triggerMode = (TriggerMode)enum_2;
        Enum enum_3 = sin.readEnum(ConditionType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_3, (String)"readEnum(...)");
        this(string, string2, severity, l, l2, instant, list, triggerMode, (ConditionType)enum_3, sin.readBoolean() ? (NumResultsCondition)sin.readEnum(NumResultsCondition.class) : null, sin.readOptionalLong(), sin.readOptionalString());
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.getId());
        out.writeString(this.getName());
        out.writeEnum((Enum)this.getSeverity());
        out.writeOptionalLong(this.getThrottleDuration());
        out.writeLong(this.getExpireDuration());
        out.writeOptionalInstant(this.getLastTriggeredTime());
        out.writeCollection((Collection)this.getActions());
        out.writeEnum((Enum)this.mode);
        out.writeEnum((Enum)this.conditionType);
        out.writeBoolean(this.numResultsCondition != null);
        NumResultsCondition numResultsCondition = this.numResultsCondition;
        if (numResultsCondition != null) {
            NumResultsCondition it = numResultsCondition;
            boolean bl = false;
            out.writeEnum((Enum)this.numResultsCondition);
        }
        out.writeOptionalLong(this.numResultsValue);
        out.writeOptionalString(this.customCondition);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.startObject();
        builder.field("id", this.getId());
        builder.field("name", this.getName());
        builder.field("severity", this.getSeverity().getValue());
        Long l = this.getThrottleDuration();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            builder.field("throttle_minutes", this.getThrottleDuration().longValue());
        }
        builder.field("expires_minutes", this.getExpireDuration());
        IndexUtilsKt.optionalTimeField((XContentBuilder)builder, (String)"last_triggered_time", (Instant)this.getLastTriggeredTime());
        Collection $this$toTypedArray$iv = this.getActions();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        builder.field("actions", (Object)thisCollection$iv.toArray(new Action[0]));
        builder.field(MODE_FIELD, this.mode.getValue());
        builder.field(CONDITION_TYPE_FIELD, this.conditionType.getValue());
        NumResultsCondition numResultsCondition = this.numResultsCondition;
        if (numResultsCondition != null) {
            NumResultsCondition it = numResultsCondition;
            boolean bl = false;
            builder.field(NUM_RESULTS_CONDITION_FIELD, this.numResultsCondition.getValue());
        }
        Long l2 = this.numResultsValue;
        if (l2 != null) {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            builder.field(NUM_RESULTS_VALUE_FIELD, this.numResultsValue.longValue());
        }
        String string = this.customCondition;
        if (string != null) {
            String it = string;
            boolean bl = false;
            builder.field(CUSTOM_CONDITION_FIELD, this.customCondition);
        }
        builder.endObject();
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> asTemplateArg() {
        Collection<Map> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[11];
        pairArray[0] = TuplesKt.to((Object)"id", (Object)this.getId());
        pairArray[1] = TuplesKt.to((Object)"name", (Object)this.getName());
        pairArray[2] = TuplesKt.to((Object)"severity", (Object)this.getSeverity().getValue());
        pairArray[3] = TuplesKt.to((Object)"throttle_minutes", (Object)this.getThrottleDuration());
        pairArray[4] = TuplesKt.to((Object)"expires_minutes", (Object)this.getExpireDuration());
        Iterable iterable = this.getActions();
        String string = "actions";
        int n = 5;
        Pair[] pairArray2 = pairArray;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Action action = (Action)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asTemplateArg());
        }
        collection = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)collection);
        pairArray[6] = TuplesKt.to((Object)MODE_FIELD, (Object)this.mode.getValue());
        pairArray[7] = TuplesKt.to((Object)CONDITION_TYPE_FIELD, (Object)this.conditionType.getValue());
        NumResultsCondition numResultsCondition = this.numResultsCondition;
        pairArray[8] = TuplesKt.to((Object)NUM_RESULTS_CONDITION_FIELD, (Object)(numResultsCondition != null ? numResultsCondition.getValue() : null));
        pairArray[9] = TuplesKt.to((Object)NUM_RESULTS_VALUE_FIELD, (Object)this.numResultsValue);
        pairArray[10] = TuplesKt.to((Object)CUSTOM_CONDITION_FIELD, (Object)this.customCondition);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final TriggerV2.Severity component3() {
        return this.severity;
    }

    @Nullable
    public final Long component4() {
        return this.throttleDuration;
    }

    public final long component5() {
        return this.expireDuration;
    }

    @Nullable
    public final Instant component6() {
        return this.lastTriggeredTime;
    }

    @NotNull
    public final List<Action> component7() {
        return this.actions;
    }

    @NotNull
    public final TriggerMode component8() {
        return this.mode;
    }

    @NotNull
    public final ConditionType component9() {
        return this.conditionType;
    }

    @Nullable
    public final NumResultsCondition component10() {
        return this.numResultsCondition;
    }

    @Nullable
    public final Long component11() {
        return this.numResultsValue;
    }

    @Nullable
    public final String component12() {
        return this.customCondition;
    }

    @NotNull
    public final PPLSQLTrigger copy(@NotNull String id, @NotNull String name, @NotNull TriggerV2.Severity severity, @Nullable Long throttleDuration, long expireDuration, @Nullable Instant lastTriggeredTime, @NotNull List<Action> actions, @NotNull TriggerMode mode, @NotNull ConditionType conditionType, @Nullable NumResultsCondition numResultsCondition, @Nullable Long numResultsValue, @Nullable String customCondition) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)MODE_FIELD);
        Intrinsics.checkNotNullParameter((Object)((Object)conditionType), (String)"conditionType");
        return new PPLSQLTrigger(id, name, severity, throttleDuration, expireDuration, lastTriggeredTime, actions, mode, conditionType, numResultsCondition, numResultsValue, customCondition);
    }

    public static /* synthetic */ PPLSQLTrigger copy$default(PPLSQLTrigger pPLSQLTrigger, String string, String string2, TriggerV2.Severity severity, Long l, long l2, Instant instant, List list, TriggerMode triggerMode, ConditionType conditionType, NumResultsCondition numResultsCondition, Long l3, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = pPLSQLTrigger.id;
        }
        if ((n & 2) != 0) {
            string2 = pPLSQLTrigger.name;
        }
        if ((n & 4) != 0) {
            severity = pPLSQLTrigger.severity;
        }
        if ((n & 8) != 0) {
            l = pPLSQLTrigger.throttleDuration;
        }
        if ((n & 0x10) != 0) {
            l2 = pPLSQLTrigger.expireDuration;
        }
        if ((n & 0x20) != 0) {
            instant = pPLSQLTrigger.lastTriggeredTime;
        }
        if ((n & 0x40) != 0) {
            list = pPLSQLTrigger.actions;
        }
        if ((n & 0x80) != 0) {
            triggerMode = pPLSQLTrigger.mode;
        }
        if ((n & 0x100) != 0) {
            conditionType = pPLSQLTrigger.conditionType;
        }
        if ((n & 0x200) != 0) {
            numResultsCondition = pPLSQLTrigger.numResultsCondition;
        }
        if ((n & 0x400) != 0) {
            l3 = pPLSQLTrigger.numResultsValue;
        }
        if ((n & 0x800) != 0) {
            string3 = pPLSQLTrigger.customCondition;
        }
        return pPLSQLTrigger.copy(string, string2, severity, l, l2, instant, list, triggerMode, conditionType, numResultsCondition, l3, string3);
    }

    @NotNull
    public String toString() {
        return "PPLSQLTrigger(id=" + this.id + ", name=" + this.name + ", severity=" + this.severity + ", throttleDuration=" + this.throttleDuration + ", expireDuration=" + this.expireDuration + ", lastTriggeredTime=" + this.lastTriggeredTime + ", actions=" + this.actions + ", mode=" + this.mode + ", conditionType=" + this.conditionType + ", numResultsCondition=" + this.numResultsCondition + ", numResultsValue=" + this.numResultsValue + ", customCondition=" + this.customCondition + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.severity.hashCode();
        result = result * 31 + (this.throttleDuration == null ? 0 : ((Object)this.throttleDuration).hashCode());
        result = result * 31 + Long.hashCode(this.expireDuration);
        result = result * 31 + (this.lastTriggeredTime == null ? 0 : this.lastTriggeredTime.hashCode());
        result = result * 31 + ((Object)this.actions).hashCode();
        result = result * 31 + this.mode.hashCode();
        result = result * 31 + this.conditionType.hashCode();
        result = result * 31 + (this.numResultsCondition == null ? 0 : this.numResultsCondition.hashCode());
        result = result * 31 + (this.numResultsValue == null ? 0 : ((Object)this.numResultsValue).hashCode());
        result = result * 31 + (this.customCondition == null ? 0 : this.customCondition.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PPLSQLTrigger)) {
            return false;
        }
        PPLSQLTrigger pPLSQLTrigger = (PPLSQLTrigger)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)pPLSQLTrigger.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)pPLSQLTrigger.name)) {
            return false;
        }
        if (this.severity != pPLSQLTrigger.severity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.throttleDuration, (Object)pPLSQLTrigger.throttleDuration)) {
            return false;
        }
        if (this.expireDuration != pPLSQLTrigger.expireDuration) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastTriggeredTime, (Object)pPLSQLTrigger.lastTriggeredTime)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actions, pPLSQLTrigger.actions)) {
            return false;
        }
        if (this.mode != pPLSQLTrigger.mode) {
            return false;
        }
        if (this.conditionType != pPLSQLTrigger.conditionType) {
            return false;
        }
        if (this.numResultsCondition != pPLSQLTrigger.numResultsCondition) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.numResultsValue, (Object)pPLSQLTrigger.numResultsValue)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.customCondition, (Object)pPLSQLTrigger.customCondition);
    }

    private static final PPLSQLTrigger XCONTENT_REGISTRY$lambda$27(XContentParser it) {
        Intrinsics.checkNotNull((Object)it);
        return Companion.parseInner(it);
    }

    @JvmStatic
    @NotNull
    public static final PPLSQLTrigger parseInner(@NotNull XContentParser xcp) throws IOException {
        return Companion.parseInner(xcp);
    }

    @JvmStatic
    @NotNull
    public static final PPLSQLTrigger readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$Companion;", "", "<init>", "()V", "PPL_SQL_TRIGGER_FIELD", "", "MODE_FIELD", "CONDITION_TYPE_FIELD", "NUM_RESULTS_CONDITION_FIELD", "NUM_RESULTS_VALUE_FIELD", "CUSTOM_CONDITION_FIELD", "validCharsRegex", "Lkotlin/text/Regex;", "XCONTENT_REGISTRY", "Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "getXCONTENT_REGISTRY", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "parseInner", "Lorg/opensearch/alerting/modelv2/PPLSQLTrigger;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nPPLSQLTrigger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,414:1\n1563#2:415\n1634#2,3:416\n1563#2:419\n1634#2,3:420\n1563#2:423\n1634#2,3:424\n1563#2:427\n1634#2,3:428\n1#3:431\n*S KotlinDebug\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger$Companion\n*L\n316#1:415\n316#1:416,3\n325#1:419\n325#1:420,3\n334#1:423\n334#1:424,3\n344#1:427\n344#1:428,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NamedXContentRegistry.Entry getXCONTENT_REGISTRY() {
            return XCONTENT_REGISTRY;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final PPLSQLTrigger parseInner(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String id = UUIDs.base64UUID();
            String name = null;
            Enum severity = null;
            Long throttleDuration = null;
            long expireDuration = 10080L;
            Instant lastTriggeredTime = null;
            List actions = new ArrayList();
            Enum mode = null;
            Enum conditionType = null;
            Enum numResultsCondition = null;
            Long numResultsValue = null;
            String customCondition = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block28: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block54: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block54;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1478300413: {
                            if (string.equals("severity")) {
                                n = 1;
                            }
                            break;
                        }
                        case 0x3339A3: {
                            if (string.equals(PPLSQLTrigger.MODE_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case -1091917927: {
                            if (string.equals(PPLSQLTrigger.NUM_RESULTS_CONDITION_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case -1489323281: {
                            if (string.equals(PPLSQLTrigger.NUM_RESULTS_VALUE_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                        case 3373707: {
                            if (string.equals("name")) {
                                n = 5;
                            }
                            break;
                        }
                        case 83068106: {
                            if (string.equals("throttle_minutes")) {
                                n = 6;
                            }
                            break;
                        }
                        case -363923756: {
                            if (string.equals("expires_minutes")) {
                                n = 7;
                            }
                            break;
                        }
                        case 3355: {
                            if (string.equals("id")) {
                                n = 8;
                            }
                            break;
                        }
                        case 3575610: {
                            if (string.equals(PPLSQLTrigger.CONDITION_TYPE_FIELD)) {
                                n = 9;
                            }
                            break;
                        }
                        case -1161803523: {
                            if (string.equals("actions")) {
                                n = 10;
                            }
                            break;
                        }
                        case 100800973: {
                            if (string.equals(PPLSQLTrigger.CUSTOM_CONDITION_FIELD)) {
                                n = 11;
                            }
                            break;
                        }
                        case 1114763902: {
                            if (string.equals("last_triggered_time")) {
                                n = 12;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 8: {
                            id = xcp.text();
                            continue block28;
                        }
                        case 5: {
                            name = xcp.text();
                            continue block28;
                        }
                        case 1: {
                            Enum enumMatchResult;
                            String input = xcp.text();
                            Intrinsics.checkNotNull((Object)input);
                            if (TriggerV2.Severity.Companion.enumFromString(input) == null) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                Iterable iterable = (Iterable)TriggerV2.Severity.getEntries();
                                String string2 = input;
                                boolean $i$f$map = false;
                                void var21_38 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    TriggerV2.Severity severity2 = (TriggerV2.Severity)((Object)item$iv$iv);
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it.getValue());
                                }
                                String string3 = "Invalid value for severity: " + string2 + ". Supported values are " + (List)destination$iv$iv;
                                throw new IllegalArgumentException(string3);
                            }
                            severity = enumMatchResult;
                            continue block28;
                        }
                        case 2: {
                            Enum enumMatchResult;
                            String input = xcp.text();
                            Intrinsics.checkNotNull((Object)input);
                            if (TriggerMode.Companion.enumFromString(input) == null) {
                                Iterable $this$map$iv = (Iterable)TriggerMode.getEntries();
                                String string4 = input;
                                boolean $i$f$map = false;
                                Iterable $this$mapTo$iv$iv = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    TriggerMode it = (TriggerMode)((Object)item$iv$iv);
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it.getValue());
                                }
                                String string5 = "Invalid value for mode: " + string4 + ". Supported values are " + (List)destination$iv$iv;
                                throw new IllegalArgumentException(string5);
                            }
                            mode = enumMatchResult;
                            continue block28;
                        }
                        case 9: {
                            Enum enumMatchResult;
                            String input = xcp.text();
                            Intrinsics.checkNotNull((Object)input);
                            if (ConditionType.Companion.enumFromString(input) == null) {
                                Iterable $this$map$iv = (Iterable)ConditionType.getEntries();
                                String string6 = input;
                                boolean $i$f$map = false;
                                Iterable $this$mapTo$iv$iv = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    ConditionType it = (ConditionType)((Object)item$iv$iv);
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it.getValue());
                                }
                                String string7 = "Invalid value for type: " + string6 + ". Supported values are " + (List)destination$iv$iv;
                                throw new IllegalArgumentException(string7);
                            }
                            conditionType = enumMatchResult;
                            continue block28;
                        }
                        case 3: {
                            Enum enumMatchResult;
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block28;
                            String input = xcp.text();
                            Intrinsics.checkNotNull((Object)input);
                            if (NumResultsCondition.Companion.enumFromString(input) == null) {
                                Iterable $this$map$iv = (Iterable)NumResultsCondition.getEntries();
                                String string8 = input;
                                boolean $i$f$map = false;
                                Iterable $this$mapTo$iv$iv = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    NumResultsCondition it = (NumResultsCondition)((Object)item$iv$iv);
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it.getValue());
                                }
                                String string9 = "Invalid value for num_results_condition: " + string8 + ". Supported values are " + (List)destination$iv$iv;
                                throw new IllegalArgumentException(string9);
                            }
                            numResultsCondition = enumMatchResult;
                            continue block28;
                        }
                        case 4: {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block28;
                            numResultsValue = xcp.longValue();
                            continue block28;
                        }
                        case 11: {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block28;
                            customCondition = xcp.text();
                            continue block28;
                        }
                        case 6: {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block28;
                            throttleDuration = xcp.longValue();
                            continue block28;
                        }
                        case 7: {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block28;
                            expireDuration = xcp.longValue();
                            continue block28;
                        }
                        case 12: {
                            lastTriggeredTime = IndexUtilsKt.instant((XContentParser)xcp);
                            continue block28;
                        }
                        case 10: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                actions.add(Action.Companion.parse(xcp));
                            }
                            continue block28;
                        }
                    }
                }
                throw new IllegalArgumentException("Unexpected field when parsing PPL Trigger: " + fieldName);
            }
            if (name == null) {
                boolean $i$a$-requireNotNull-PPLSQLTrigger$Companion$parseInner$52 = false;
                String $i$a$-requireNotNull-PPLSQLTrigger$Companion$parseInner$52 = "Trigger name must be included";
                throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$Companion$parseInner$52.toString());
            }
            if (severity == null) {
                boolean $i$a$-requireNotNull-PPLSQLTrigger$Companion$parseInner$62 = false;
                String $i$a$-requireNotNull-PPLSQLTrigger$Companion$parseInner$62 = "Trigger severity must be included";
                throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$Companion$parseInner$62.toString());
            }
            if (mode == null) {
                boolean $i$a$-requireNotNull-PPLSQLTrigger$Companion$parseInner$72 = false;
                String $i$a$-requireNotNull-PPLSQLTrigger$Companion$parseInner$72 = "Trigger mode must be included";
                throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLTrigger$Companion$parseInner$72.toString());
            }
            if (conditionType == null) {
                boolean bl = false;
                String string = "Trigger condition type must be included";
                throw new IllegalArgumentException(string.toString());
            }
            String string = id;
            Intrinsics.checkNotNull((Object)string);
            return new PPLSQLTrigger(string, name, (TriggerV2.Severity)severity, throttleDuration, expireDuration, lastTriggeredTime, actions, (TriggerMode)mode, (ConditionType)conditionType, (NumResultsCondition)numResultsCondition, numResultsValue, customCondition);
        }

        @JvmStatic
        @NotNull
        public final PPLSQLTrigger readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new PPLSQLTrigger(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$ConditionType;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "NUMBER_OF_RESULTS", "CUSTOM", "Companion", "opensearch-alerting"})
    public static final class ConditionType
    extends Enum<ConditionType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String value;
        public static final /* enum */ ConditionType NUMBER_OF_RESULTS;
        public static final /* enum */ ConditionType CUSTOM;
        private static final /* synthetic */ ConditionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ConditionType(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static ConditionType[] values() {
            return (ConditionType[])$VALUES.clone();
        }

        public static ConditionType valueOf(String value) {
            return Enum.valueOf(ConditionType.class, value);
        }

        @NotNull
        public static EnumEntries<ConditionType> getEntries() {
            return $ENTRIES;
        }

        static {
            NUMBER_OF_RESULTS = new ConditionType("number_of_results");
            CUSTOM = new ConditionType("custom");
            $VALUES = conditionTypeArray = new ConditionType[]{ConditionType.NUMBER_OF_RESULTS, ConditionType.CUSTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$ConditionType$Companion;", "", "<init>", "()V", "enumFromString", "Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$ConditionType;", "value", "", "opensearch-alerting"})
        @SourceDebugExtension(value={"SMAP\nPPLSQLTrigger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger$ConditionType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,414:1\n295#2,2:415\n*S KotlinDebug\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger$ConditionType$Companion\n*L\n244#1:415,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ConditionType enumFromString(@NotNull String value) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Iterable $this$firstOrNull$iv = (Iterable)ConditionType.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ConditionType it = (ConditionType)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$NumResultsCondition;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "GREATER_THAN", "GREATER_THAN_EQUAL", "LESS_THAN", "LESS_THAN_EQUAL", "EQUAL", "NOT_EQUAL", "Companion", "opensearch-alerting"})
    public static final class NumResultsCondition
    extends Enum<NumResultsCondition> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String value;
        public static final /* enum */ NumResultsCondition GREATER_THAN;
        public static final /* enum */ NumResultsCondition GREATER_THAN_EQUAL;
        public static final /* enum */ NumResultsCondition LESS_THAN;
        public static final /* enum */ NumResultsCondition LESS_THAN_EQUAL;
        public static final /* enum */ NumResultsCondition EQUAL;
        public static final /* enum */ NumResultsCondition NOT_EQUAL;
        private static final /* synthetic */ NumResultsCondition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private NumResultsCondition(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static NumResultsCondition[] values() {
            return (NumResultsCondition[])$VALUES.clone();
        }

        public static NumResultsCondition valueOf(String value) {
            return Enum.valueOf(NumResultsCondition.class, value);
        }

        @NotNull
        public static EnumEntries<NumResultsCondition> getEntries() {
            return $ENTRIES;
        }

        static {
            GREATER_THAN = new NumResultsCondition(">");
            GREATER_THAN_EQUAL = new NumResultsCondition(">=");
            LESS_THAN = new NumResultsCondition("<");
            LESS_THAN_EQUAL = new NumResultsCondition("<=");
            EQUAL = new NumResultsCondition("==");
            NOT_EQUAL = new NumResultsCondition("!=");
            $VALUES = numResultsConditionArray = new NumResultsCondition[]{NumResultsCondition.GREATER_THAN, NumResultsCondition.GREATER_THAN_EQUAL, NumResultsCondition.LESS_THAN, NumResultsCondition.LESS_THAN_EQUAL, NumResultsCondition.EQUAL, NumResultsCondition.NOT_EQUAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$NumResultsCondition$Companion;", "", "<init>", "()V", "enumFromString", "Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$NumResultsCondition;", "value", "", "opensearch-alerting"})
        @SourceDebugExtension(value={"SMAP\nPPLSQLTrigger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger$NumResultsCondition$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,414:1\n295#2,2:415\n*S KotlinDebug\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger$NumResultsCondition$Companion\n*L\n257#1:415,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final NumResultsCondition enumFromString(@NotNull String value) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Iterable $this$firstOrNull$iv = (Iterable)NumResultsCondition.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        NumResultsCondition it = (NumResultsCondition)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$TriggerMode;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "RESULT_SET", "PER_RESULT", "Companion", "opensearch-alerting"})
    public static final class TriggerMode
    extends Enum<TriggerMode> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String value;
        public static final /* enum */ TriggerMode RESULT_SET;
        public static final /* enum */ TriggerMode PER_RESULT;
        private static final /* synthetic */ TriggerMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TriggerMode(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static TriggerMode[] values() {
            return (TriggerMode[])$VALUES.clone();
        }

        public static TriggerMode valueOf(String value) {
            return Enum.valueOf(TriggerMode.class, value);
        }

        @NotNull
        public static EnumEntries<TriggerMode> getEntries() {
            return $ENTRIES;
        }

        static {
            RESULT_SET = new TriggerMode("result_set");
            PER_RESULT = new TriggerMode("per_result");
            $VALUES = triggerModeArray = new TriggerMode[]{TriggerMode.RESULT_SET, TriggerMode.PER_RESULT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$TriggerMode$Companion;", "", "<init>", "()V", "enumFromString", "Lorg/opensearch/alerting/modelv2/PPLSQLTrigger$TriggerMode;", "value", "", "opensearch-alerting"})
        @SourceDebugExtension(value={"SMAP\nPPLSQLTrigger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger$TriggerMode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,414:1\n295#2,2:415\n*S KotlinDebug\n*F\n+ 1 PPLSQLTrigger.kt\norg/opensearch/alerting/modelv2/PPLSQLTrigger$TriggerMode$Companion\n*L\n235#1:415,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final TriggerMode enumFromString(@NotNull String value) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Iterable $this$firstOrNull$iv = (Iterable)TriggerMode.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        TriggerMode it = (TriggerMode)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConditionType.values().length];
            try {
                nArray[ConditionType.NUMBER_OF_RESULTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConditionType.CUSTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

