/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.rest;

import com.o19s.es.ltr.action.ClearCachesAction;
import com.o19s.es.ltr.action.FeatureStoreAction;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.query.ValidatingLtrQueryBuilder;
import com.o19s.es.ltr.rest.AutoDetectParser;
import com.o19s.es.ltr.rest.FeatureStoreBaseRestHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.get.GetResponse;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ltr.settings.LTRSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.OpenSearchClient;
import org.opensearch.transport.client.node.NodeClient;

public class RestFeatureManager
extends FeatureStoreBaseRestHandler {
    private final String type;

    public RestFeatureManager(String type) {
        this.type = type;
    }

    public String getName() {
        return "Add, update or delete a " + this.type;
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.PUT, "/_ltr/{store}/_" + this.type + "/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/_ltr/_" + this.type + "/{name}"), new RestHandler.Route(RestRequest.Method.POST, "/_ltr/{store}/_" + this.type + "/{name}"), new RestHandler.Route(RestRequest.Method.POST, "/_ltr/_" + this.type + "/{name}"), new RestHandler.Route(RestRequest.Method.DELETE, "/_ltr/{store}/_" + this.type + "/{name}"), new RestHandler.Route(RestRequest.Method.DELETE, "/_ltr/_" + this.type + "/{name}"), new RestHandler.Route(RestRequest.Method.GET, "/_ltr/{store}/_" + this.type + "/{name}"), new RestHandler.Route(RestRequest.Method.GET, "/_ltr/_" + this.type + "/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_ltr/{store}/_" + this.type + "/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_ltr/_" + this.type + "/{name}")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        String indexName = this.indexName(request);
        if (request.method() == RestRequest.Method.DELETE) {
            return this.delete(client, this.type, indexName, request);
        }
        if (request.method() == RestRequest.Method.HEAD || request.method() == RestRequest.Method.GET) {
            return this.get(client, this.type, indexName, request);
        }
        return this.addOrUpdate(client, this.type, indexName, request);
    }

    BaseRestHandler.RestChannelConsumer delete(NodeClient client, String type, String indexName, RestRequest request) {
        assert (ValidatingLtrQueryBuilder.SUPPORTED_TYPES.contains(type));
        String name = request.param("name");
        String id = StorableElement.generateId(type, name);
        String routing = request.param("routing");
        return channel -> {
            RestStatusToXContentListener restR = new RestStatusToXContentListener(channel, r -> r.getLocation(routing));
            ClearCachesAction.ClearCachesNodesRequest clearCache = new ClearCachesAction.ClearCachesNodesRequest();
            switch (type) {
                case "feature": {
                    clearCache.clearFeature(indexName, name);
                    break;
                }
                case "featureset": {
                    clearCache.clearFeatureSet(indexName, name);
                    break;
                }
                case "model": {
                    clearCache.clearModel(indexName, name);
                }
            }
            DeleteRequestBuilder deleteRequest = client.prepareDelete(indexName, id).setRouting(routing);
            client.execute((ActionType)ClearCachesAction.INSTANCE, (ActionRequest)clearCache, ActionListener.wrap(r -> {
                try (ThreadContext.StoredContext threadContext = client.threadPool().getThreadContext().stashContext();){
                    deleteRequest.execute(ActionListener.wrap(deleteResponse -> {
                        restR.onResponse(deleteResponse);
                        threadContext.restore();
                    }, e -> {
                        restR.onFailure(e);
                        threadContext.restore();
                    }));
                }
                catch (Exception e2) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e2.getMessage()));
                }
            }, arg_0 -> ((RestStatusToXContentListener)restR).onFailure(arg_0)));
        };
    }

    BaseRestHandler.RestChannelConsumer get(NodeClient client, String type, String indexName, RestRequest request) {
        assert (ValidatingLtrQueryBuilder.SUPPORTED_TYPES.contains(type));
        String name = request.param("name");
        String routing = request.param("routing");
        String id = StorableElement.generateId(type, name);
        return channel -> {
            try (ThreadContext.StoredContext threadContext = client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.runBefore((ActionListener)new RestToXContentListener<GetResponse>(this, channel){

                    protected RestStatus getStatus(GetResponse response) {
                        return response.isExists() ? RestStatus.OK : RestStatus.NOT_FOUND;
                    }
                }, () -> threadContext.restore());
                client.prepareGet(indexName, id).setRouting(routing).execute(wrappedListener);
            }
            catch (Exception e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
        };
    }

    BaseRestHandler.RestChannelConsumer addOrUpdate(NodeClient client, String type, String indexName, RestRequest request) throws IOException {
        assert (ValidatingLtrQueryBuilder.SUPPORTED_TYPES.contains(type));
        String routing = request.param("routing");
        if (!request.hasContentOrSourceParam()) {
            throw new IllegalArgumentException("Missing content or source param.");
        }
        String name = request.param("name");
        AutoDetectParser parserState = new AutoDetectParser(name);
        request.applyContentParser(parserState::parse);
        StorableElement elt = parserState.getElement();
        if (!type.equals(elt.type())) {
            throw new IllegalArgumentException("Excepted a [" + type + "] but encountered [" + elt.type() + "]");
        }
        if (!elt.name().equals(name)) {
            throw new IllegalArgumentException("Name mismatch, send request with [" + elt.name() + "] but [" + name + "] used in the URL");
        }
        if (request.method() == RestRequest.Method.POST && !elt.updatable()) {
            try {
                throw new IllegalArgumentException("Element of type [" + elt.type() + "] are not updatable, please create a new one instead.");
            }
            catch (IllegalArgumentException iae) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.METHOD_NOT_ALLOWED, (Exception)iae));
            }
        }
        FeatureStoreAction.FeatureStoreRequestBuilder builder = new FeatureStoreAction.FeatureStoreRequestBuilder((OpenSearchClient)client, FeatureStoreAction.INSTANCE);
        if (request.method() == RestRequest.Method.PUT) {
            ((FeatureStoreAction.FeatureStoreRequest)builder.request()).setAction(FeatureStoreAction.FeatureStoreRequest.Action.CREATE);
        } else {
            ((FeatureStoreAction.FeatureStoreRequest)builder.request()).setAction(FeatureStoreAction.FeatureStoreRequest.Action.UPDATE);
        }
        ((FeatureStoreAction.FeatureStoreRequest)builder.request()).setStorableElement(elt);
        ((FeatureStoreAction.FeatureStoreRequest)builder.request()).setRouting(routing);
        ((FeatureStoreAction.FeatureStoreRequest)builder.request()).setStore(indexName);
        ((FeatureStoreAction.FeatureStoreRequest)builder.request()).setValidation(parserState.getValidation());
        return channel -> {
            try (ThreadContext.StoredContext threadContext = client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.runBefore((ActionListener)new RestStatusToXContentListener(channel, r -> r.getResponse().getLocation(routing)), () -> threadContext.restore());
                builder.execute(wrappedListener);
            }
            catch (Exception e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
        };
    }
}

