/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.ranker.linear;

import com.o19s.es.ltr.ranker.DenseFeatureVector;
import com.o19s.es.ltr.ranker.DenseLtrRanker;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class LinearRanker
extends DenseLtrRanker
implements Accountable {
    private final float[] weights;

    public LinearRanker(float[] weights) {
        this.weights = Objects.requireNonNull(weights);
    }

    @Override
    public String name() {
        return "linear";
    }

    @Override
    protected float score(DenseFeatureVector point) {
        float[] scores = point.scores;
        float score = 0.0f;
        for (int i = 0; i < this.weights.length; ++i) {
            score += this.weights[i] * scores[i];
        }
        return score;
    }

    @Override
    protected int size() {
        return this.weights.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinearRanker ranker = (LinearRanker)o;
        return Arrays.equals(this.weights, ranker.weights);
    }

    public int hashCode() {
        return Arrays.hashCode(this.weights);
    }

    public long ramBytesUsed() {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.sizeOf((float[])this.weights);
    }
}

