/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.o19s.es.ltr.LtrQueryContext;
import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.StoredFeature;
import com.o19s.es.ltr.query.DerivedExpressionQuery;
import com.o19s.es.ltr.utils.Scripting;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class PrecompiledExpressionFeature
implements Feature,
Accountable {
    public static final String TEMPLATE_LANGUAGE = "derived_expression";
    private static final long BASE_RAM_USED = RamUsageEstimator.shallowSizeOfInstance(PrecompiledExpressionFeature.class);
    private final String name;
    private final Expression expression;
    private final Set<String> expressionVariables;
    private final Collection<String> queryParams;

    private PrecompiledExpressionFeature(String name, Expression expression, Collection<String> queryParams) {
        this.name = name;
        this.expression = expression;
        this.queryParams = queryParams;
        this.expressionVariables = new HashSet<String>(Arrays.asList(this.expression.variables));
    }

    public static PrecompiledExpressionFeature compile(StoredFeature feature) {
        assert (TEMPLATE_LANGUAGE.equals(feature.templateLanguage()));
        Expression expr = (Expression)Scripting.compile(feature.template());
        return new PrecompiledExpressionFeature(feature.name(), expr, feature.queryParams());
    }

    public long ramBytesUsed() {
        return BASE_RAM_USED + (long)(2 * this.name.length()) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)((2 * this.expression.sourceText.length() + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) * 2);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Query doToQuery(LtrQueryContext context, FeatureSet set, Map<String, Object> params) {
        List missingParams = this.queryParams.stream().filter(x -> params == null || !params.containsKey(x)).collect(Collectors.toList());
        if (!missingParams.isEmpty()) {
            String names = missingParams.stream().collect(Collectors.joining(","));
            throw new IllegalArgumentException("Missing required param(s): [" + names + "]");
        }
        Map<String, Double> queryParamValues = this.getQueryParamValues(params);
        return new DerivedExpressionQuery(set, this.expression, queryParamValues);
    }

    private Map<String, Double> getQueryParamValues() {
        return this.getQueryParamValues();
    }

    private Map<String, Double> getQueryParamValues(Map<String, Object> params) {
        HashMap<String, Double> queryParamValues = new HashMap<String, Double>();
        for (String param : this.queryParams) {
            if (!this.expressionVariables.contains(param)) continue;
            try {
                Number number = (Number)params.get(param);
                queryParamValues.put(param, number.doubleValue());
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("parameter: " + param + " expected to be of type Double");
            }
        }
        return queryParamValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrecompiledExpressionFeature that = (PrecompiledExpressionFeature)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression) && Objects.equals(this.queryParams, that.queryParams) && Objects.equals(this.expressionVariables, that.expressionVariables);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression, this.queryParams, this.expressionVariables);
    }

    @Override
    public void validate(FeatureSet set) {
        for (String var : this.expression.variables) {
            if (!set.hasFeature(var) && !this.queryParams.contains(var)) {
                throw new IllegalArgumentException("Derived feature [" + this.name + "] refers to unknown feature or parameter: [" + var + "]");
            }
            if (!set.hasFeature(var) || !this.queryParams.contains(var)) continue;
            throw new IllegalArgumentException("Duplicate name " + var + " . Cannot be used as both feature name and query parameter name");
        }
    }
}

