/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.None;
import software.amazon.cryptography.primitives.model.DigestAlgorithm;

public class SymmetricSignatureAlgorithm {
    private final DigestAlgorithm HMAC;
    private final None None;

    protected SymmetricSignatureAlgorithm(BuilderImpl builder) {
        this.HMAC = builder.HMAC();
        this.None = builder.None();
    }

    public DigestAlgorithm HMAC() {
        return this.HMAC;
    }

    public None None() {
        return this.None;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DigestAlgorithm HMAC;
        protected None None;

        protected BuilderImpl() {
        }

        protected BuilderImpl(SymmetricSignatureAlgorithm model) {
            this.HMAC = model.HMAC();
            this.None = model.None();
        }

        @Override
        public Builder HMAC(DigestAlgorithm HMAC) {
            this.HMAC = HMAC;
            return this;
        }

        @Override
        public DigestAlgorithm HMAC() {
            return this.HMAC;
        }

        @Override
        public Builder None(None None2) {
            this.None = None2;
            return this;
        }

        @Override
        public None None() {
            return this.None;
        }

        @Override
        public SymmetricSignatureAlgorithm build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`SymmetricSignatureAlgorithm` is a Union. A Union MUST have one and only one value set.");
            }
            return new SymmetricSignatureAlgorithm(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.HMAC, this.None};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder HMAC(DigestAlgorithm var1);

        public DigestAlgorithm HMAC();

        public Builder None(None var1);

        public None None();

        public SymmetricSignatureAlgorithm build();
    }
}

