/*
 * Decompiled with CFR 0.152.
 */
package Utf16EncodingForm_Compile;

import Unicode_Compile.ScalarValue;
import Utf16EncodingForm_Compile.MinimalWellFormedCodeUnitSeq;
import Utf16EncodingForm_Compile.WellFormedCodeUnitSeq;
import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;

public class __default {
    public static boolean IsMinimalWellFormedCodeUnitSubsequence(DafnySequence<? extends Short> s) {
        if (Objects.equals(BigInteger.valueOf(s.length()), BigInteger.ONE)) {
            return __default.IsWellFormedSingleCodeUnitSequence(s);
        }
        if (Objects.equals(BigInteger.valueOf(s.length()), BigInteger.valueOf(2L))) {
            boolean _0_b = __default.IsWellFormedDoubleCodeUnitSequence(s);
            return _0_b;
        }
        return false;
    }

    public static boolean IsWellFormedSingleCodeUnitSequence(DafnySequence<? extends Short> s) {
        short _0_firstWord = (Short)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        return (_0_firstWord == 0 ? 0 : 1) != -1 && Integer.compareUnsigned(_0_firstWord, -10241) <= 0 || Integer.compareUnsigned(-8192, _0_firstWord) <= 0 && Integer.compareUnsigned(_0_firstWord, -1) <= 0;
    }

    public static boolean IsWellFormedDoubleCodeUnitSequence(DafnySequence<? extends Short> s) {
        short _0_firstWord = (Short)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        short _1_secondWord = (Short)s.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        return Integer.compareUnsigned(-10240, _0_firstWord) <= 0 && Integer.compareUnsigned(_0_firstWord, -9217) <= 0 && Integer.compareUnsigned(-9216, _1_secondWord) <= 0 && Integer.compareUnsigned(_1_secondWord, -8193) <= 0;
    }

    public static Option<DafnySequence<? extends Short>> SplitPrefixMinimalWellFormedCodeUnitSubsequence(DafnySequence<? extends Short> s) {
        if (BigInteger.valueOf(s.length()).compareTo(BigInteger.ONE) >= 0 && __default.IsWellFormedSingleCodeUnitSequence((DafnySequence<? extends Short>)s.take(BigInteger.ONE))) {
            return Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.SHORT), s.take(BigInteger.ONE));
        }
        if (BigInteger.valueOf(s.length()).compareTo(BigInteger.valueOf(2L)) >= 0 && __default.IsWellFormedDoubleCodeUnitSequence((DafnySequence<? extends Short>)s.take(BigInteger.valueOf(2L)))) {
            return Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.SHORT), s.take(BigInteger.valueOf(2L)));
        }
        return Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.SHORT));
    }

    public static DafnySequence<? extends Short> EncodeScalarValue(int v) {
        if ((v == 0 ? 0 : 1) != -1 && Integer.compareUnsigned(v, 55295) <= 0 || Integer.compareUnsigned(57344, v) <= 0 && Integer.compareUnsigned(v, 65535) <= 0) {
            return __default.EncodeScalarValueSingleWord(v);
        }
        return __default.EncodeScalarValueDoubleWord(v);
    }

    public static DafnySequence<? extends Short> EncodeScalarValueSingleWord(int v) {
        short _0_firstWord = (short)v;
        return DafnySequence.of((short[])new short[]{_0_firstWord});
    }

    public static DafnySequence<? extends Short> EncodeScalarValueDoubleWord(int v) {
        short _0_x2 = (short)(v & 0x3FF);
        byte _1_x1 = (byte)((v & 0xFC00) >>> 10);
        byte _2_u = (byte)((v & 0x1F0000) >>> 16);
        byte _3_w = (byte)((byte)(_2_u - 1) & 0x1F);
        short _4_firstWord = (short)((short)(0xFFFFD800 | (short)((short)Byte.toUnsignedInt(_3_w) << 6)) | (short)Byte.toUnsignedInt(_1_x1));
        short _5_secondWord = (short)(0xFFFFDC00 | _0_x2);
        return DafnySequence.of((short[])new short[]{_4_firstWord, _5_secondWord});
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequence(DafnySequence<? extends Short> m) {
        if (Objects.equals(BigInteger.valueOf(m.length()), BigInteger.ONE)) {
            return __default.DecodeMinimalWellFormedCodeUnitSubsequenceSingleWord(m);
        }
        return __default.DecodeMinimalWellFormedCodeUnitSubsequenceDoubleWord(m);
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequenceSingleWord(DafnySequence<? extends Short> m) {
        short _0_firstWord;
        short _1_x = _0_firstWord = ((Short)m.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).shortValue();
        return Short.toUnsignedInt(_1_x);
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequenceDoubleWord(DafnySequence<? extends Short> m) {
        short _0_firstWord = (Short)m.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        short _1_secondWord = (Short)m.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        int _2_x2 = Short.toUnsignedInt((short)(_1_secondWord & 0x3FF));
        int _3_x1 = Short.toUnsignedInt((short)(_0_firstWord & 0x3F));
        int _4_w = Short.toUnsignedInt((short)Helpers.bv16ShiftRight((short)((short)(_0_firstWord & 0x3C0)), (byte)6));
        int _5_u = _4_w + 1 & 0xFFFFFF;
        int _6_v = _5_u << 16 & 0xFFFFFF | _3_x1 << 10 & 0xFFFFFF | _2_x2;
        return _6_v;
    }

    public static Option<DafnySequence<? extends DafnySequence<? extends Short>>> PartitionCodeUnitSequenceChecked(DafnySequence<? extends Short> s) {
        Option<DafnySequence<? extends DafnySequence<? extends Short>>> maybeParts = Option.Default(DafnySequence._typeDescriptor(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
        if (s.equals((Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.SHORT))) {
            maybeParts = Option.create_Some(DafnySequence._typeDescriptor(MinimalWellFormedCodeUnitSeq._typeDescriptor()), DafnySequence.empty(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
            return maybeParts;
        }
        DafnySequence _0_result = DafnySequence.empty(MinimalWellFormedCodeUnitSeq._typeDescriptor());
        DafnySequence _1_rest = s;
        while (BigInteger.valueOf(_1_rest.length()).signum() == 1) {
            Option<DafnySequence<? extends Short>> _2_valueOrError0 = Option.Default(MinimalWellFormedCodeUnitSeq._typeDescriptor());
            _2_valueOrError0 = __default.SplitPrefixMinimalWellFormedCodeUnitSubsequence(_1_rest);
            if (_2_valueOrError0.IsFailure(MinimalWellFormedCodeUnitSeq._typeDescriptor())) {
                maybeParts = _2_valueOrError0.PropagateFailure(MinimalWellFormedCodeUnitSeq._typeDescriptor(), DafnySequence._typeDescriptor(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
                return maybeParts;
            }
            DafnySequence<? extends Short> _3_prefix = _2_valueOrError0.Extract(MinimalWellFormedCodeUnitSeq._typeDescriptor());
            _0_result = DafnySequence.concatenate((DafnySequence)_0_result, (DafnySequence)DafnySequence.of(MinimalWellFormedCodeUnitSeq._typeDescriptor(), (Object[])new DafnySequence[]{_3_prefix}));
            _1_rest = _1_rest.drop(BigInteger.valueOf(_3_prefix.length()));
        }
        maybeParts = Option.create_Some(DafnySequence._typeDescriptor(MinimalWellFormedCodeUnitSeq._typeDescriptor()), _0_result);
        return maybeParts;
    }

    public static DafnySequence<? extends DafnySequence<? extends Short>> PartitionCodeUnitSequence(DafnySequence<? extends Short> s) {
        return __default.PartitionCodeUnitSequenceChecked(s).Extract((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Short>>>)DafnySequence._typeDescriptor(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
    }

    public static boolean IsWellFormedCodeUnitSequence(DafnySequence<? extends Short> s) {
        return __default.PartitionCodeUnitSequenceChecked(s).is_Some();
    }

    public static DafnySequence<? extends Short> EncodeScalarSequence(DafnySequence<? extends Integer> vs) {
        DafnySequence s = WellFormedCodeUnitSeq.defaultValue();
        s = DafnySequence.empty((TypeDescriptor)TypeDescriptor.SHORT);
        BigInteger _lo0 = BigInteger.ZERO;
        BigInteger _0_i = BigInteger.valueOf(vs.length());
        while (_lo0.compareTo(_0_i) < 0) {
            _0_i = _0_i.subtract(BigInteger.ONE);
            DafnySequence<? extends Short> _1_next = __default.EncodeScalarValue((Integer)vs.select(Helpers.toInt((BigInteger)_0_i)));
            s = DafnySequence.concatenate(_1_next, (DafnySequence)s);
        }
        return s;
    }

    public static DafnySequence<? extends Integer> DecodeCodeUnitSequence(DafnySequence<? extends Short> s) {
        DafnySequence<? extends DafnySequence<? extends Short>> _0_parts = __default.PartitionCodeUnitSequence(s);
        DafnySequence<Integer> _1_vs = Seq_Compile.__default.Map(MinimalWellFormedCodeUnitSeq._typeDescriptor(), ScalarValue._typeDescriptor(), __default::DecodeMinimalWellFormedCodeUnitSubsequence, _0_parts);
        return _1_vs;
    }

    public static Option<DafnySequence<? extends Integer>> DecodeCodeUnitSequenceChecked(DafnySequence<? extends Short> s) {
        Option<DafnySequence<? extends Integer>> maybeVs = Option.Default(DafnySequence._typeDescriptor(ScalarValue._typeDescriptor()));
        Option<DafnySequence<? extends DafnySequence<? extends Short>>> _0_maybeParts = __default.PartitionCodeUnitSequenceChecked(s);
        if (_0_maybeParts.is_None()) {
            maybeVs = Option.create_None(DafnySequence._typeDescriptor(ScalarValue._typeDescriptor()));
            return maybeVs;
        }
        DafnySequence<? extends DafnySequence<? extends Short>> _1_parts = _0_maybeParts.dtor_value();
        DafnySequence<Integer> _2_vs = Seq_Compile.__default.Map(MinimalWellFormedCodeUnitSeq._typeDescriptor(), ScalarValue._typeDescriptor(), __default::DecodeMinimalWellFormedCodeUnitSubsequence, _1_parts);
        maybeVs = Option.create_Some(DafnySequence._typeDescriptor(ScalarValue._typeDescriptor()), _2_vs);
        return maybeVs;
    }

    public String toString() {
        return "Utf16EncodingForm._default";
    }
}

