/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class ParsePublicKeyInput {
    private final ByteBuffer publicKey;

    protected ParsePublicKeyInput(BuilderImpl builder) {
        this.publicKey = builder.publicKey();
    }

    public ByteBuffer publicKey() {
        return this.publicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer publicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ParsePublicKeyInput model) {
            this.publicKey = model.publicKey();
        }

        @Override
        public Builder publicKey(ByteBuffer publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public ByteBuffer publicKey() {
            return this.publicKey;
        }

        @Override
        public ParsePublicKeyInput build() {
            if (Objects.isNull(this.publicKey())) {
                throw new IllegalArgumentException("Missing value for required field `publicKey`");
            }
            return new ParsePublicKeyInput(this);
        }
    }

    public static interface Builder {
        public Builder publicKey(ByteBuffer var1);

        public ByteBuffer publicKey();

        public ParsePublicKeyInput build();
    }
}

