/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.internaldafny;

import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import AwsCryptographyKeyStoreOperations_Compile.Config;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.KeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.__default;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types.RegionType;

public abstract class _ExternBase___default {
    public static KeyStoreConfig DefaultKeyStoreConfig() {
        return KeyStoreConfig.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), KMSConfiguration.create_kmsKeyArn((DafnySequence<? extends Character>)DafnySequence.asString((String)"arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab")), (DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))), Option.create_None(TypeDescriptor.reference(IDynamoDBClient.class)), Option.create_None(TypeDescriptor.reference(IKMSClient.class)));
    }

    public static Result<KeyStoreClient, Error> KeyStore(KeyStoreConfig config) {
        Result<KeyStoreClient, Error> res = null;
        IKMSClient _0_kmsClient = null;
        IDynamoDBClient _1_ddbClient = null;
        Option<Object> _2_inferredRegion = Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        if (KMSKeystoreOperations_Compile.__default.HasKeyId(config.dtor_kmsConfiguration())) {
            Result<AwsArn, Error> _3_valueOrError0 = null;
            _3_valueOrError0 = KmsArn_Compile.__default.IsValidKeyArn(KMSKeystoreOperations_Compile.__default.GetKeyId(config.dtor_kmsConfiguration()));
            if (_3_valueOrError0.IsFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor())) {
                res = _3_valueOrError0.PropagateFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor(), TypeDescriptor.reference(KeyStoreClient.class));
                return res;
            }
            AwsArn _4_parsedArn = _3_valueOrError0.Extract(AwsKmsArn._typeDescriptor(), Error._typeDescriptor());
            _2_inferredRegion = Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _4_parsedArn.dtor_region());
        } else if (config.dtor_kmsConfiguration().is_mrDiscovery()) {
            _2_inferredRegion = Option.create_Some(RegionType._typeDescriptor(), config.dtor_kmsConfiguration().dtor_mrDiscovery().dtor_region());
        }
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _5_grantTokens = AwsKmsUtils_Compile.__default.GetValidGrantTokens(config.dtor_grantTokens());
        Outcome<Error> _6_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _6_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _5_grantTokens.is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Grant Tokens passed to Key Store configuration are invalid.")));
        if (_6_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _6_valueOrError1.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.reference(KeyStoreClient.class));
            return res;
        }
        DafnySequence _7_keyStoreId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        if (config.dtor_id().is_Some()) {
            _7_keyStoreId = config.dtor_id().dtor_value();
        } else {
            DafnySequence _11_uuid;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _out0;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _8_maybeUuid = _out0 = UUID.__default.GenerateUUID();
            Result<DafnySequence, Error> _9_valueOrError2 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _9_valueOrError2 = _8_maybeUuid.MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _10_e_boxed0 -> {
                DafnySequence _10_e = _10_e_boxed0;
                return Error.create_KeyStoreException((DafnySequence<? extends Character>)_10_e);
            });
            if (_9_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _9_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), TypeDescriptor.reference(KeyStoreClient.class));
                return res;
            }
            _7_keyStoreId = _11_uuid = _9_valueOrError2.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        }
        if (config.dtor_kmsClient().is_Some()) {
            _0_kmsClient = config.dtor_kmsClient().dtor_value();
        } else if (config.dtor_kmsClient().is_None() && _2_inferredRegion.is_Some()) {
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out1;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _12_maybeKmsClient = _out1 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClientForRegion((DafnySequence<? extends Character>)((DafnySequence)_2_inferredRegion.dtor_value()));
            Result<IKMSClient, Error> _13_valueOrError3 = null;
            _13_valueOrError3 = _12_maybeKmsClient.MapFailure((TypeDescriptor<IKMSClient>)TypeDescriptor.reference(IKMSClient.class), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _14_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _14_e = _14_e_boxed0;
                return Error.create_ComAmazonawsKms(_14_e);
            });
            if (_13_valueOrError3.IsFailure((TypeDescriptor<IKMSClient>)TypeDescriptor.reference(IKMSClient.class), Error._typeDescriptor())) {
                res = _13_valueOrError3.PropagateFailure((TypeDescriptor<IKMSClient>)TypeDescriptor.reference(IKMSClient.class), Error._typeDescriptor(), TypeDescriptor.reference(KeyStoreClient.class));
                return res;
            }
            _0_kmsClient = _13_valueOrError3.Extract((TypeDescriptor<IKMSClient>)TypeDescriptor.reference(IKMSClient.class), Error._typeDescriptor());
        } else {
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out2;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _15_maybeKmsClient = _out2 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClient();
            Result<IKMSClient, Error> _16_valueOrError4 = null;
            _16_valueOrError4 = _15_maybeKmsClient.MapFailure((TypeDescriptor<IKMSClient>)TypeDescriptor.reference(IKMSClient.class), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _17_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _17_e = _17_e_boxed0;
                return Error.create_ComAmazonawsKms(_17_e);
            });
            if (_16_valueOrError4.IsFailure((TypeDescriptor<IKMSClient>)TypeDescriptor.reference(IKMSClient.class), Error._typeDescriptor())) {
                res = _16_valueOrError4.PropagateFailure((TypeDescriptor<IKMSClient>)TypeDescriptor.reference(IKMSClient.class), Error._typeDescriptor(), TypeDescriptor.reference(KeyStoreClient.class));
                return res;
            }
            _0_kmsClient = _16_valueOrError4.Extract((TypeDescriptor<IKMSClient>)TypeDescriptor.reference(IKMSClient.class), Error._typeDescriptor());
        }
        if (config.dtor_ddbClient().is_Some()) {
            _1_ddbClient = config.dtor_ddbClient().dtor_value();
        } else if (config.dtor_ddbClient().is_None() && _2_inferredRegion.is_Some()) {
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out3;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _18_maybeDdbClient = _out3 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DDBClientForRegion((DafnySequence<? extends Character>)((DafnySequence)_2_inferredRegion.dtor_value()));
            Result<IDynamoDBClient, Error> _19_valueOrError5 = null;
            _19_valueOrError5 = _18_maybeDdbClient.MapFailure((TypeDescriptor<IDynamoDBClient>)TypeDescriptor.reference(IDynamoDBClient.class), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _20_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _20_e = _20_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_20_e);
            });
            if (_19_valueOrError5.IsFailure((TypeDescriptor<IDynamoDBClient>)TypeDescriptor.reference(IDynamoDBClient.class), Error._typeDescriptor())) {
                res = _19_valueOrError5.PropagateFailure((TypeDescriptor<IDynamoDBClient>)TypeDescriptor.reference(IDynamoDBClient.class), Error._typeDescriptor(), TypeDescriptor.reference(KeyStoreClient.class));
                return res;
            }
            _1_ddbClient = _19_valueOrError5.Extract((TypeDescriptor<IDynamoDBClient>)TypeDescriptor.reference(IDynamoDBClient.class), Error._typeDescriptor());
        } else {
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out4;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _21_maybeDdbClient = _out4 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DynamoDBClient();
            Result<IDynamoDBClient, Error> _22_valueOrError6 = null;
            _22_valueOrError6 = _21_maybeDdbClient.MapFailure((TypeDescriptor<IDynamoDBClient>)TypeDescriptor.reference(IDynamoDBClient.class), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _23_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _23_e = _23_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_23_e);
            });
            if (_22_valueOrError6.IsFailure((TypeDescriptor<IDynamoDBClient>)TypeDescriptor.reference(IDynamoDBClient.class), Error._typeDescriptor())) {
                res = _22_valueOrError6.PropagateFailure((TypeDescriptor<IDynamoDBClient>)TypeDescriptor.reference(IDynamoDBClient.class), Error._typeDescriptor(), TypeDescriptor.reference(KeyStoreClient.class));
                return res;
            }
            _1_ddbClient = _22_valueOrError6.Extract((TypeDescriptor<IDynamoDBClient>)TypeDescriptor.reference(IDynamoDBClient.class), Error._typeDescriptor());
        }
        Outcome<Error> _24_valueOrError7 = Outcome.Default(Error._typeDescriptor());
        _24_valueOrError7 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.IsValid__TableName(config.dtor_ddbTableName()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Amazon DynamoDB Table Name")));
        if (_24_valueOrError7.IsFailure(Error._typeDescriptor())) {
            res = _24_valueOrError7.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.reference(KeyStoreClient.class));
            return res;
        }
        KeyStoreClient _nw0 = new KeyStoreClient();
        _nw0.__ctor(Config.create((DafnySequence<? extends Character>)_7_keyStoreId, config.dtor_ddbTableName(), config.dtor_logicalKeyStoreName(), config.dtor_kmsConfiguration(), _5_grantTokens.dtor_value(), _0_kmsClient, _1_ddbClient));
        KeyStoreClient _25_client = _nw0;
        res = Result.create_Success(TypeDescriptor.reference(KeyStoreClient.class), Error._typeDescriptor(), _25_client);
        return res;
    }

    public static Result<IKeyStoreClient, Error> CreateSuccessOfClient(IKeyStoreClient client) {
        return Result.create_Success(TypeDescriptor.reference(IKeyStoreClient.class), Error._typeDescriptor(), client);
    }

    public static Result<IKeyStoreClient, Error> CreateFailureOfError(Error error) {
        return Result.create_Failure(TypeDescriptor.reference(IKeyStoreClient.class), Error._typeDescriptor(), error);
    }

    public String toString() {
        return "KeyStore._default";
    }
}

