/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.knn;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch.knn.NodeStats;
import org.opensearch.client.opensearch.nodes.NodesResponseBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KnnStatsResponse
extends NodesResponseBase
implements ToCopyableBuilder<Builder, KnnStatsResponse> {
    @Nullable
    private final Boolean circuitBreakerTriggered;
    @Nullable
    private final String clusterName;
    @Nullable
    private final HealthStatus modelIndexStatus;
    @Nonnull
    private final Map<String, NodeStats> nodes;
    public static final JsonpDeserializer<KnnStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnStatsResponse::setupKnnStatsResponseDeserializer);

    private KnnStatsResponse(Builder builder) {
        super(builder);
        this.circuitBreakerTriggered = builder.circuitBreakerTriggered;
        this.clusterName = builder.clusterName;
        this.modelIndexStatus = builder.modelIndexStatus;
        this.nodes = ApiTypeHelper.unmodifiable(builder.nodes);
    }

    public static KnnStatsResponse of(Function<Builder, ObjectBuilder<KnnStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean circuitBreakerTriggered() {
        return this.circuitBreakerTriggered;
    }

    @Nullable
    public final String clusterName() {
        return this.clusterName;
    }

    @Nullable
    public final HealthStatus modelIndexStatus() {
        return this.modelIndexStatus;
    }

    @Nonnull
    public final Map<String, NodeStats> nodes() {
        return this.nodes;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.circuitBreakerTriggered != null) {
            generator.writeKey("circuit_breaker_triggered");
            generator.write(this.circuitBreakerTriggered.booleanValue());
        }
        if (this.clusterName != null) {
            generator.writeKey("cluster_name");
            generator.write(this.clusterName);
        }
        if (this.modelIndexStatus != null) {
            generator.writeKey("model_index_status");
            this.modelIndexStatus.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry<String, NodeStats> item0 : this.nodes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKnnStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        KnnStatsResponse.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::circuitBreakerTriggered, JsonpDeserializer.booleanDeserializer(), "circuit_breaker_triggered");
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::modelIndexStatus, HealthStatus._DESERIALIZER, "model_index_status");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeStats._DESERIALIZER), "nodes");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.circuitBreakerTriggered);
        result = 31 * result + Objects.hashCode(this.clusterName);
        result = 31 * result + Objects.hashCode(this.modelIndexStatus);
        result = 31 * result + Objects.hashCode(this.nodes);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnnStatsResponse other = (KnnStatsResponse)o;
        return Objects.equals(this.circuitBreakerTriggered, other.circuitBreakerTriggered) && Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.modelIndexStatus, other.modelIndexStatus) && Objects.equals(this.nodes, other.nodes);
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KnnStatsResponse> {
        @Nullable
        private Boolean circuitBreakerTriggered;
        @Nullable
        private String clusterName;
        @Nullable
        private HealthStatus modelIndexStatus;
        @Nullable
        private Map<String, NodeStats> nodes;

        public Builder() {
        }

        private Builder(KnnStatsResponse o) {
            super(o);
            this.circuitBreakerTriggered = o.circuitBreakerTriggered;
            this.clusterName = o.clusterName;
            this.modelIndexStatus = o.modelIndexStatus;
            this.nodes = Builder._mapCopy(o.nodes);
        }

        private Builder(Builder o) {
            super(o);
            this.circuitBreakerTriggered = o.circuitBreakerTriggered;
            this.clusterName = o.clusterName;
            this.modelIndexStatus = o.modelIndexStatus;
            this.nodes = Builder._mapCopy(o.nodes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder circuitBreakerTriggered(@Nullable Boolean value) {
            this.circuitBreakerTriggered = value;
            return this;
        }

        @Nonnull
        public final Builder clusterName(@Nullable String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder modelIndexStatus(@Nullable HealthStatus value) {
            this.modelIndexStatus = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(Map<String, NodeStats> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, NodeStats value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Function<NodeStats.Builder, ObjectBuilder<NodeStats>> fn) {
            return this.nodes(key, fn.apply(new NodeStats.Builder()).build());
        }

        @Override
        @Nonnull
        public KnnStatsResponse build() {
            this._checkSingleUse();
            return new KnnStatsResponse(this);
        }
    }
}

