/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ingest.Pipeline;
import org.opensearch.client.opensearch.ingest.SimulateResponse;
import org.opensearch.client.opensearch.ingest.simulate.Document;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class SimulateRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SimulateRequest> {
    @Nonnull
    private final List<Document> docs;
    @Nullable
    private final String id;
    @Nullable
    private final Pipeline pipeline;
    @Nullable
    private final Boolean verbose;
    public static final JsonpDeserializer<SimulateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulateRequest::setupSimulateRequestDeserializer);
    public static final Endpoint<SimulateRequest, SimulateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SimulateRequest, SimulateResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_ingest/pipeline/_simulate";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest/pipeline/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_simulate");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, SimulateResponse._DESERIALIZER);

    private SimulateRequest(Builder builder) {
        super(builder);
        this.docs = ApiTypeHelper.unmodifiable(builder.docs);
        this.id = builder.id;
        this.pipeline = builder.pipeline;
        this.verbose = builder.verbose;
    }

    public static SimulateRequest of(Function<Builder, ObjectBuilder<SimulateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<Document> docs() {
        return this.docs;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Pipeline pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final Boolean verbose() {
        return this.verbose;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (Document item0 : this.docs) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            this.pipeline.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSimulateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(Document._DESERIALIZER), "docs");
        op.add(Builder::pipeline, Pipeline._DESERIALIZER, "pipeline");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.verbose != null) {
            params.put("verbose", String.valueOf(this.verbose));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.docs);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.pipeline);
        result = 31 * result + Objects.hashCode(this.verbose);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulateRequest other = (SimulateRequest)o;
        return Objects.equals(this.docs, other.docs) && Objects.equals(this.id, other.id) && Objects.equals(this.pipeline, other.pipeline) && Objects.equals(this.verbose, other.verbose);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SimulateRequest> {
        @Nullable
        private List<Document> docs;
        @Nullable
        private String id;
        @Nullable
        private Pipeline pipeline;
        @Nullable
        private Boolean verbose;

        public Builder() {
        }

        private Builder(SimulateRequest o) {
            super(o);
            this.docs = Builder._listCopy(o.docs);
            this.id = o.id;
            this.pipeline = o.pipeline;
            this.verbose = o.verbose;
        }

        private Builder(Builder o) {
            super(o);
            this.docs = Builder._listCopy(o.docs);
            this.id = o.id;
            this.pipeline = o.pipeline;
            this.verbose = o.verbose;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder docs(List<Document> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        @Nonnull
        public final Builder docs(Document value, Document ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        @Nonnull
        public final Builder docs(Function<Document.Builder, ObjectBuilder<Document>> fn) {
            return this.docs(fn.apply(new Document.Builder()).build(), new Document[0]);
        }

        @Nonnull
        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder pipeline(@Nullable Pipeline value) {
            this.pipeline = value;
            return this;
        }

        @Nonnull
        public final Builder pipeline(Function<Pipeline.Builder, ObjectBuilder<Pipeline>> fn) {
            return this.pipeline(fn.apply(new Pipeline.Builder()).build());
        }

        @Nonnull
        public final Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        @Override
        @Nonnull
        public SimulateRequest build() {
            this._checkSingleUse();
            return new SimulateRequest(this);
        }
    }
}

