/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NoriPartOfSpeechTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, NoriPartOfSpeechTokenFilter> {
    @Nonnull
    private final List<String> stoptags;
    public static final JsonpDeserializer<NoriPartOfSpeechTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NoriPartOfSpeechTokenFilter::setupNoriPartOfSpeechTokenFilterDeserializer);

    private NoriPartOfSpeechTokenFilter(Builder builder) {
        super(builder);
        this.stoptags = ApiTypeHelper.unmodifiable(builder.stoptags);
    }

    public static NoriPartOfSpeechTokenFilter of(Function<Builder, ObjectBuilder<NoriPartOfSpeechTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.NoriPartOfSpeech;
    }

    @Nonnull
    public final List<String> stoptags() {
        return this.stoptags;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nori_part_of_speech");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.stoptags)) {
            generator.writeKey("stoptags");
            generator.writeStartArray();
            for (String item0 : this.stoptags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNoriPartOfSpeechTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        NoriPartOfSpeechTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::stoptags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stoptags");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.stoptags);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoriPartOfSpeechTokenFilter other = (NoriPartOfSpeechTokenFilter)o;
        return Objects.equals(this.stoptags, other.stoptags);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NoriPartOfSpeechTokenFilter> {
        @Nullable
        private List<String> stoptags;

        public Builder() {
        }

        private Builder(NoriPartOfSpeechTokenFilter o) {
            super(o);
            this.stoptags = Builder._listCopy(o.stoptags);
        }

        private Builder(Builder o) {
            super(o);
            this.stoptags = Builder._listCopy(o.stoptags);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder stoptags(List<String> list) {
            this.stoptags = Builder._listAddAll(this.stoptags, list);
            return this;
        }

        @Nonnull
        public final Builder stoptags(String value, String ... values) {
            this.stoptags = Builder._listAdd(this.stoptags, value, values);
            return this;
        }

        @Override
        @Nonnull
        public NoriPartOfSpeechTokenFilter build() {
            this._checkSingleUse();
            return new NoriPartOfSpeechTokenFilter(this);
        }
    }
}

