/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb;

import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.DynamoDbEncryption;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.DynamoDbKeyBranchKeyIdSupplier;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.IDynamoDbKeyBranchKeyIdSupplier;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.LegacyDynamoDbEncryptor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconStyle;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconVersion;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.CompoundBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.CreateDynamoDbEncryptionBranchKeyIdSupplierInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.DynamoDbEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.DynamoDbTableEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.DynamoDbTablesEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.EncryptedPart;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error_DynamoDbEncryptionException;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetBranchKeyIdFromDdbKeyInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetBranchKeyIdFromDdbKeyOutput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetEncryptedDataKeyDescriptionInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetEncryptedDataKeyDescriptionUnion;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetPrefix;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetSegments;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetSubstring;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetSuffix;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.IDynamoDbEncryptionClient;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ILegacyDynamoDbEncryptor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyOverride;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.MultiKeyStore;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.PartOnly;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.PlaintextOverride;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.SearchConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Shared;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.SharedSet;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.SignedPart;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.StandardBeacon;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualPart;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.AsSet;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.BeaconKeySource;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.CollectionOfErrors;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Constructor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.ConstructorPart;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.CreateDynamoDbEncryptionBranchKeyIdSupplierOutput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbEncryptionException;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.EncryptedDataKeyDescription;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetEncryptedDataKeyDescriptionOutput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetSegment;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Insert;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.LegacyPolicy;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Lower;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.OpaqueError;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.OpaqueWithTextError;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.SingleKeyStore;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Upper;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.VirtualField;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.VirtualTransform;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.keystore.KeyStore;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.IBranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.CacheType;
import software.amazon.cryptography.materialproviders.model.DBEAlgorithmSuiteId;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue;
import software.amazon.smithy.dafny.conversion.ToDafny;

public class ToDafny {
    public static Error Error(RuntimeException nativeValue) {
        if (nativeValue instanceof DynamoDbEncryptionException) {
            return ToDafny.Error((DynamoDbEncryptionException)nativeValue);
        }
        if (nativeValue instanceof OpaqueError) {
            return ToDafny.Error((OpaqueError)nativeValue);
        }
        if (nativeValue instanceof OpaqueWithTextError) {
            return ToDafny.Error((OpaqueWithTextError)nativeValue);
        }
        if (nativeValue instanceof CollectionOfErrors) {
            return ToDafny.Error((CollectionOfErrors)nativeValue);
        }
        return Error.create_Opaque(nativeValue);
    }

    public static Error Error(OpaqueError nativeValue) {
        return Error.create_Opaque(nativeValue.obj());
    }

    public static Error Error(OpaqueWithTextError nativeValue) {
        return Error.create_OpaqueWithText(nativeValue.obj(), (DafnySequence<? extends Character>)DafnySequence.asString((String)nativeValue.objMessage()));
    }

    public static Error Error(CollectionOfErrors nativeValue) {
        DafnySequence list = ToDafny.Aggregate.GenericToSequence(nativeValue.list(), ToDafny::Error, Error._typeDescriptor());
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.getMessage());
        return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)list, (DafnySequence<? extends Character>)message);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.AsSet AsSet(AsSet nativeValue) {
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.AsSet();
    }

    public static BeaconVersion BeaconVersion(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.BeaconVersion nativeValue) {
        Integer version = nativeValue.version();
        IKeyStoreClient keyStore = software.amazon.cryptography.keystore.ToDafny.KeyStore((KeyStore)nativeValue.keyStore());
        software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconKeySource keySource = ToDafny.BeaconKeySource(nativeValue.keySource());
        DafnySequence<? extends StandardBeacon> standardBeacons = ToDafny.StandardBeaconList(nativeValue.standardBeacons());
        Option compoundBeacons = Objects.nonNull(nativeValue.compoundBeacons()) && nativeValue.compoundBeacons().size() > 0 ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor(CompoundBeacon._typeDescriptor()), ToDafny.CompoundBeaconList(nativeValue.compoundBeacons())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor(CompoundBeacon._typeDescriptor()));
        Option virtualFields = Objects.nonNull(nativeValue.virtualFields()) && nativeValue.virtualFields().size() > 0 ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField._typeDescriptor()), ToDafny.VirtualFieldList(nativeValue.virtualFields())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField._typeDescriptor()));
        Option encryptedParts = Objects.nonNull(nativeValue.encryptedParts()) && nativeValue.encryptedParts().size() > 0 ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor(EncryptedPart._typeDescriptor()), ToDafny.EncryptedPartsList(nativeValue.encryptedParts())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor(EncryptedPart._typeDescriptor()));
        Option signedParts = Objects.nonNull(nativeValue.signedParts()) && nativeValue.signedParts().size() > 0 ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor(SignedPart._typeDescriptor()), ToDafny.SignedPartsList(nativeValue.signedParts())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor(SignedPart._typeDescriptor()));
        return new BeaconVersion(version, keyStore, keySource, standardBeacons, (Option<DafnySequence<? extends CompoundBeacon>>)compoundBeacons, (Option<DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField>>)virtualFields, (Option<DafnySequence<? extends EncryptedPart>>)encryptedParts, (Option<DafnySequence<? extends SignedPart>>)signedParts);
    }

    public static CompoundBeacon CompoundBeacon(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.CompoundBeacon nativeValue) {
        DafnySequence name = ToDafny.Simple.CharacterSequence((String)nativeValue.name());
        DafnySequence split = ToDafny.Simple.CharacterSequence((String)nativeValue.split());
        Option encrypted = Objects.nonNull(nativeValue.encrypted()) && nativeValue.encrypted().size() > 0 ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor(EncryptedPart._typeDescriptor()), ToDafny.EncryptedPartsList(nativeValue.encrypted())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor(EncryptedPart._typeDescriptor()));
        Option signed = Objects.nonNull(nativeValue.signed()) && nativeValue.signed().size() > 0 ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor(SignedPart._typeDescriptor()), ToDafny.SignedPartsList(nativeValue.signed())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor(SignedPart._typeDescriptor()));
        Option constructors = Objects.nonNull(nativeValue.constructors()) && nativeValue.constructors().size() > 0 ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor._typeDescriptor()), ToDafny.ConstructorList(nativeValue.constructors())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor._typeDescriptor()));
        return new CompoundBeacon((DafnySequence<? extends Character>)name, (DafnySequence<? extends Character>)split, (Option<DafnySequence<? extends EncryptedPart>>)encrypted, (Option<DafnySequence<? extends SignedPart>>)signed, (Option<DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor>>)constructors);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor Constructor(Constructor nativeValue) {
        DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart> parts = ToDafny.ConstructorPartList(nativeValue.parts());
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor(parts);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart ConstructorPart(ConstructorPart nativeValue) {
        DafnySequence name = ToDafny.Simple.CharacterSequence((String)nativeValue.name());
        Boolean required = nativeValue.required();
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart((DafnySequence<? extends Character>)name, required);
    }

    public static CreateDynamoDbEncryptionBranchKeyIdSupplierInput CreateDynamoDbEncryptionBranchKeyIdSupplierInput(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.CreateDynamoDbEncryptionBranchKeyIdSupplierInput nativeValue) {
        software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.IDynamoDbKeyBranchKeyIdSupplier ddbKeyBranchKeyIdSupplier = ToDafny.DynamoDbKeyBranchKeyIdSupplier(nativeValue.ddbKeyBranchKeyIdSupplier());
        return new CreateDynamoDbEncryptionBranchKeyIdSupplierInput(ddbKeyBranchKeyIdSupplier);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.CreateDynamoDbEncryptionBranchKeyIdSupplierOutput CreateDynamoDbEncryptionBranchKeyIdSupplierOutput(CreateDynamoDbEncryptionBranchKeyIdSupplierOutput nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier branchKeyIdSupplier = software.amazon.cryptography.materialproviders.ToDafny.BranchKeyIdSupplier((IBranchKeyIdSupplier)nativeValue.branchKeyIdSupplier());
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.CreateDynamoDbEncryptionBranchKeyIdSupplierOutput(branchKeyIdSupplier);
    }

    public static DynamoDbEncryptionConfig DynamoDbEncryptionConfig(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbEncryptionConfig nativeValue) {
        return new DynamoDbEncryptionConfig();
    }

    public static DynamoDbTableEncryptionConfig DynamoDbTableEncryptionConfig(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbTableEncryptionConfig nativeValue) {
        DafnySequence logicalTableName = ToDafny.Simple.CharacterSequence((String)nativeValue.logicalTableName());
        DafnySequence partitionKeyName = ToDafny.Simple.CharacterSequence((String)nativeValue.partitionKeyName());
        Option sortKeyName = Objects.nonNull(nativeValue.sortKeyName()) ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)ToDafny.Simple.CharacterSequence((String)nativeValue.sortKeyName())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option search = Objects.nonNull(nativeValue.search()) ? Option.create_Some(SearchConfig._typeDescriptor(), (Object)ToDafny.SearchConfig(nativeValue.search())) : Option.create_None(SearchConfig._typeDescriptor());
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> attributeActionsOnEncrypt = ToDafny.AttributeActions(nativeValue.attributeActionsOnEncrypt());
        Option allowedUnsignedAttributes = Objects.nonNull(nativeValue.allowedUnsignedAttributes()) && nativeValue.allowedUnsignedAttributes().size() > 0 ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), (Object)software.amazon.cryptography.services.dynamodb.internaldafny.ToDafny.AttributeNameList(nativeValue.allowedUnsignedAttributes())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        Option allowedUnsignedAttributePrefix = Objects.nonNull(nativeValue.allowedUnsignedAttributePrefix()) ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)ToDafny.Simple.CharacterSequence((String)nativeValue.allowedUnsignedAttributePrefix())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option algorithmSuiteId = Objects.nonNull(nativeValue.algorithmSuiteId()) ? Option.create_Some((TypeDescriptor)software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId._typeDescriptor(), (Object)software.amazon.cryptography.materialproviders.ToDafny.DBEAlgorithmSuiteId((DBEAlgorithmSuiteId)nativeValue.algorithmSuiteId())) : Option.create_None((TypeDescriptor)software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId._typeDescriptor());
        Option keyring = Objects.nonNull(nativeValue.keyring()) ? Option.create_Some((TypeDescriptor)TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring.class), (Object)software.amazon.cryptography.materialproviders.ToDafny.Keyring((IKeyring)nativeValue.keyring())) : Option.create_None((TypeDescriptor)TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring.class));
        Option cmm = Objects.nonNull(nativeValue.cmm()) ? Option.create_Some((TypeDescriptor)TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager.class), (Object)software.amazon.cryptography.materialproviders.ToDafny.CryptographicMaterialsManager((ICryptographicMaterialsManager)nativeValue.cmm())) : Option.create_None((TypeDescriptor)TypeDescriptor.reference(software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager.class));
        Option legacyOverride = Objects.nonNull(nativeValue.legacyOverride()) ? Option.create_Some(LegacyOverride._typeDescriptor(), (Object)ToDafny.LegacyOverride(nativeValue.legacyOverride())) : Option.create_None(LegacyOverride._typeDescriptor());
        Option plaintextOverride = Objects.nonNull((Object)nativeValue.plaintextOverride()) ? Option.create_Some(PlaintextOverride._typeDescriptor(), (Object)ToDafny.PlaintextOverride(nativeValue.plaintextOverride())) : Option.create_None(PlaintextOverride._typeDescriptor());
        return new DynamoDbTableEncryptionConfig((DafnySequence<? extends Character>)logicalTableName, (DafnySequence<? extends Character>)partitionKeyName, (Option<DafnySequence<? extends Character>>)sortKeyName, (Option<SearchConfig>)search, attributeActionsOnEncrypt, (Option<DafnySequence<? extends DafnySequence<? extends Character>>>)allowedUnsignedAttributes, (Option<DafnySequence<? extends Character>>)allowedUnsignedAttributePrefix, (Option<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId>)algorithmSuiteId, (Option<software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring>)keyring, (Option<software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager>)cmm, (Option<LegacyOverride>)legacyOverride, (Option<PlaintextOverride>)plaintextOverride);
    }

    public static DynamoDbTablesEncryptionConfig DynamoDbTablesEncryptionConfig(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbTablesEncryptionConfig nativeValue) {
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends DynamoDbTableEncryptionConfig> tableEncryptionConfigs = ToDafny.DynamoDbTableEncryptionConfigList(nativeValue.tableEncryptionConfigs());
        return new DynamoDbTablesEncryptionConfig(tableEncryptionConfigs);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.EncryptedDataKeyDescription EncryptedDataKeyDescription(EncryptedDataKeyDescription nativeValue) {
        DafnySequence keyProviderId = ToDafny.Simple.CharacterSequence((String)nativeValue.keyProviderId());
        Option keyProviderInfo = Objects.nonNull(nativeValue.keyProviderInfo()) ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)ToDafny.Simple.CharacterSequence((String)nativeValue.keyProviderInfo())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option branchKeyId = Objects.nonNull(nativeValue.branchKeyId()) ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyId())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option branchKeyVersion = Objects.nonNull(nativeValue.branchKeyVersion()) ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyVersion())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.EncryptedDataKeyDescription((DafnySequence<? extends Character>)keyProviderId, (Option<DafnySequence<? extends Character>>)keyProviderInfo, (Option<DafnySequence<? extends Character>>)branchKeyId, (Option<DafnySequence<? extends Character>>)branchKeyVersion);
    }

    public static EncryptedPart EncryptedPart(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.EncryptedPart nativeValue) {
        DafnySequence name = ToDafny.Simple.CharacterSequence((String)nativeValue.name());
        DafnySequence prefix = ToDafny.Simple.CharacterSequence((String)nativeValue.prefix());
        return new EncryptedPart((DafnySequence<? extends Character>)name, (DafnySequence<? extends Character>)prefix);
    }

    public static GetBranchKeyIdFromDdbKeyInput GetBranchKeyIdFromDdbKeyInput(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetBranchKeyIdFromDdbKeyInput nativeValue) {
        DafnyMap ddbKey = software.amazon.cryptography.services.dynamodb.internaldafny.ToDafny.Key(nativeValue.ddbKey());
        return new GetBranchKeyIdFromDdbKeyInput((DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue>)ddbKey);
    }

    public static GetBranchKeyIdFromDdbKeyOutput GetBranchKeyIdFromDdbKeyOutput(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetBranchKeyIdFromDdbKeyOutput nativeValue) {
        DafnySequence branchKeyId = ToDafny.Simple.CharacterSequence((String)nativeValue.branchKeyId());
        return new GetBranchKeyIdFromDdbKeyOutput((DafnySequence<? extends Character>)branchKeyId);
    }

    public static GetEncryptedDataKeyDescriptionInput GetEncryptedDataKeyDescriptionInput(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetEncryptedDataKeyDescriptionInput nativeValue) {
        GetEncryptedDataKeyDescriptionUnion input = ToDafny.GetEncryptedDataKeyDescriptionUnion(nativeValue.input());
        return new GetEncryptedDataKeyDescriptionInput(input);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetEncryptedDataKeyDescriptionOutput GetEncryptedDataKeyDescriptionOutput(GetEncryptedDataKeyDescriptionOutput nativeValue) {
        DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.EncryptedDataKeyDescription> encryptedDataKeyDescriptionOutput = ToDafny.EncryptedDataKeyDescriptionList(nativeValue.EncryptedDataKeyDescriptionOutput());
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetEncryptedDataKeyDescriptionOutput(encryptedDataKeyDescriptionOutput);
    }

    public static GetPrefix GetPrefix(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetPrefix nativeValue) {
        Integer length = nativeValue.length();
        return new GetPrefix(length);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetSegment GetSegment(GetSegment nativeValue) {
        DafnySequence split = ToDafny.Simple.CharacterSequence((String)nativeValue.split());
        Integer index = nativeValue.index();
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetSegment((DafnySequence<? extends Character>)split, index);
    }

    public static GetSegments GetSegments(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetSegments nativeValue) {
        DafnySequence split = ToDafny.Simple.CharacterSequence((String)nativeValue.split());
        Integer low = nativeValue.low();
        Integer high = nativeValue.high();
        return new GetSegments((DafnySequence<? extends Character>)split, low, high);
    }

    public static GetSubstring GetSubstring(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetSubstring nativeValue) {
        Integer low = nativeValue.low();
        Integer high = nativeValue.high();
        return new GetSubstring(low, high);
    }

    public static GetSuffix GetSuffix(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetSuffix nativeValue) {
        Integer length = nativeValue.length();
        return new GetSuffix(length);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Insert Insert(Insert nativeValue) {
        DafnySequence literal = ToDafny.Simple.CharacterSequence((String)nativeValue.literal());
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Insert((DafnySequence<? extends Character>)literal);
    }

    public static LegacyOverride LegacyOverride(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.LegacyOverride nativeValue) {
        software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyPolicy policy = ToDafny.LegacyPolicy(nativeValue.policy());
        ILegacyDynamoDbEncryptor encryptor = ToDafny.LegacyDynamoDbEncryptor(nativeValue.encryptor());
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> attributeActionsOnEncrypt = ToDafny.AttributeActions(nativeValue.attributeActionsOnEncrypt());
        Option defaultAttributeFlag = Objects.nonNull((Object)nativeValue.defaultAttributeFlag()) ? Option.create_Some(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction._typeDescriptor(), (Object)software.amazon.cryptography.dbencryptionsdk.structuredencryption.ToDafny.CryptoAction(nativeValue.defaultAttributeFlag())) : Option.create_None(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction._typeDescriptor());
        return new LegacyOverride(policy, encryptor, attributeActionsOnEncrypt, (Option<software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction>)defaultAttributeFlag);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Lower Lower(Lower nativeValue) {
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Lower();
    }

    public static MultiKeyStore MultiKeyStore(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.MultiKeyStore nativeValue) {
        DafnySequence keyFieldName = ToDafny.Simple.CharacterSequence((String)nativeValue.keyFieldName());
        Integer cacheTTL = nativeValue.cacheTTL();
        Option cache = Objects.nonNull(nativeValue.cache()) ? Option.create_Some((TypeDescriptor)CacheType._typeDescriptor(), (Object)software.amazon.cryptography.materialproviders.ToDafny.CacheType((software.amazon.cryptography.materialproviders.model.CacheType)nativeValue.cache())) : Option.create_None((TypeDescriptor)CacheType._typeDescriptor());
        Option partitionId = Objects.nonNull(nativeValue.partitionId()) ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)ToDafny.Simple.CharacterSequence((String)nativeValue.partitionId())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        return new MultiKeyStore((DafnySequence<? extends Character>)keyFieldName, cacheTTL, (Option<CacheType>)cache, (Option<DafnySequence<? extends Character>>)partitionId);
    }

    public static PartOnly PartOnly(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.PartOnly nativeValue) {
        return new PartOnly();
    }

    public static SearchConfig SearchConfig(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.SearchConfig nativeValue) {
        DafnySequence<? extends BeaconVersion> versions = ToDafny.BeaconVersionList(nativeValue.versions());
        Integer writeVersion = nativeValue.writeVersion();
        return new SearchConfig(versions, writeVersion);
    }

    public static Shared Shared(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Shared nativeValue) {
        DafnySequence other = ToDafny.Simple.CharacterSequence((String)nativeValue.other());
        return new Shared((DafnySequence<? extends Character>)other);
    }

    public static SharedSet SharedSet(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.SharedSet nativeValue) {
        DafnySequence other = ToDafny.Simple.CharacterSequence((String)nativeValue.other());
        return new SharedSet((DafnySequence<? extends Character>)other);
    }

    public static SignedPart SignedPart(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.SignedPart nativeValue) {
        DafnySequence name = ToDafny.Simple.CharacterSequence((String)nativeValue.name());
        DafnySequence prefix = ToDafny.Simple.CharacterSequence((String)nativeValue.prefix());
        Option loc = Objects.nonNull(nativeValue.loc()) ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)ToDafny.Simple.CharacterSequence((String)nativeValue.loc())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        return new SignedPart((DafnySequence<? extends Character>)name, (DafnySequence<? extends Character>)prefix, (Option<DafnySequence<? extends Character>>)loc);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.SingleKeyStore SingleKeyStore(SingleKeyStore nativeValue) {
        DafnySequence keyId = ToDafny.Simple.CharacterSequence((String)nativeValue.keyId());
        Integer cacheTTL = nativeValue.cacheTTL();
        Option cache = Objects.nonNull(nativeValue.cache()) ? Option.create_Some((TypeDescriptor)CacheType._typeDescriptor(), (Object)software.amazon.cryptography.materialproviders.ToDafny.CacheType((software.amazon.cryptography.materialproviders.model.CacheType)nativeValue.cache())) : Option.create_None((TypeDescriptor)CacheType._typeDescriptor());
        Option partitionId = Objects.nonNull(nativeValue.partitionId()) ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)ToDafny.Simple.CharacterSequence((String)nativeValue.partitionId())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.SingleKeyStore((DafnySequence<? extends Character>)keyId, cacheTTL, (Option<CacheType>)cache, (Option<DafnySequence<? extends Character>>)partitionId);
    }

    public static StandardBeacon StandardBeacon(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.StandardBeacon nativeValue) {
        DafnySequence name = ToDafny.Simple.CharacterSequence((String)nativeValue.name());
        Integer length = nativeValue.length();
        Option loc = Objects.nonNull(nativeValue.loc()) ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)ToDafny.Simple.CharacterSequence((String)nativeValue.loc())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Option style = Objects.nonNull(nativeValue.style()) ? Option.create_Some(BeaconStyle._typeDescriptor(), (Object)ToDafny.BeaconStyle(nativeValue.style())) : Option.create_None(BeaconStyle._typeDescriptor());
        return new StandardBeacon((DafnySequence<? extends Character>)name, length, (Option<DafnySequence<? extends Character>>)loc, (Option<BeaconStyle>)style);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Upper Upper(Upper nativeValue) {
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Upper();
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField VirtualField(VirtualField nativeValue) {
        DafnySequence name = ToDafny.Simple.CharacterSequence((String)nativeValue.name());
        DafnySequence<? extends VirtualPart> parts = ToDafny.VirtualPartList(nativeValue.parts());
        return new software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField((DafnySequence<? extends Character>)name, parts);
    }

    public static VirtualPart VirtualPart(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.VirtualPart nativeValue) {
        DafnySequence loc = ToDafny.Simple.CharacterSequence((String)nativeValue.loc());
        Option trans = Objects.nonNull(nativeValue.trans()) && nativeValue.trans().size() > 0 ? Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform._typeDescriptor()), ToDafny.VirtualTransformList(nativeValue.trans())) : Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform._typeDescriptor()));
        return new VirtualPart((DafnySequence<? extends Character>)loc, (Option<DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform>>)trans);
    }

    public static Error Error(DynamoDbEncryptionException nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_DynamoDbEncryptionException((DafnySequence<? extends Character>)message);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyPolicy LegacyPolicy(LegacyPolicy nativeValue) {
        switch (nativeValue) {
            case FORCE_LEGACY_ENCRYPT_ALLOW_LEGACY_DECRYPT: {
                return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyPolicy.create_FORCE__LEGACY__ENCRYPT__ALLOW__LEGACY__DECRYPT();
            }
            case FORBID_LEGACY_ENCRYPT_ALLOW_LEGACY_DECRYPT: {
                return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyPolicy.create_FORBID__LEGACY__ENCRYPT__ALLOW__LEGACY__DECRYPT();
            }
            case FORBID_LEGACY_ENCRYPT_FORBID_LEGACY_DECRYPT: {
                return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyPolicy.create_FORBID__LEGACY__ENCRYPT__FORBID__LEGACY__DECRYPT();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyPolicy.");
    }

    public static PlaintextOverride PlaintextOverride(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.PlaintextOverride nativeValue) {
        switch (nativeValue) {
            case FORCE_PLAINTEXT_WRITE_ALLOW_PLAINTEXT_READ: {
                return PlaintextOverride.create_FORCE__PLAINTEXT__WRITE__ALLOW__PLAINTEXT__READ();
            }
            case FORBID_PLAINTEXT_WRITE_ALLOW_PLAINTEXT_READ: {
                return PlaintextOverride.create_FORBID__PLAINTEXT__WRITE__ALLOW__PLAINTEXT__READ();
            }
            case FORBID_PLAINTEXT_WRITE_FORBID_PLAINTEXT_READ: {
                return PlaintextOverride.create_FORBID__PLAINTEXT__WRITE__FORBID__PLAINTEXT__READ();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.PlaintextOverride.");
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconKeySource BeaconKeySource(BeaconKeySource nativeValue) {
        if (Objects.nonNull(nativeValue.single())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconKeySource.create_single(ToDafny.SingleKeyStore(nativeValue.single()));
        }
        if (Objects.nonNull(nativeValue.multi())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconKeySource.create_multi(ToDafny.MultiKeyStore(nativeValue.multi()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconKeySource.");
    }

    public static BeaconStyle BeaconStyle(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.BeaconStyle nativeValue) {
        if (Objects.nonNull(nativeValue.partOnly())) {
            return BeaconStyle.create_partOnly(ToDafny.PartOnly(nativeValue.partOnly()));
        }
        if (Objects.nonNull(nativeValue.shared())) {
            return BeaconStyle.create_shared(ToDafny.Shared(nativeValue.shared()));
        }
        if (Objects.nonNull(nativeValue.asSet())) {
            return BeaconStyle.create_asSet(ToDafny.AsSet(nativeValue.asSet()));
        }
        if (Objects.nonNull(nativeValue.sharedSet())) {
            return BeaconStyle.create_sharedSet(ToDafny.SharedSet(nativeValue.sharedSet()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.BeaconStyle.");
    }

    public static GetEncryptedDataKeyDescriptionUnion GetEncryptedDataKeyDescriptionUnion(software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetEncryptedDataKeyDescriptionUnion nativeValue) {
        if (Objects.nonNull(nativeValue.header())) {
            return GetEncryptedDataKeyDescriptionUnion.create_header((DafnySequence<? extends Byte>)ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.header()));
        }
        if (Objects.nonNull(nativeValue.item())) {
            return GetEncryptedDataKeyDescriptionUnion.create_item((DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue>)software.amazon.cryptography.services.dynamodb.internaldafny.ToDafny.AttributeMap(nativeValue.item()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.GetEncryptedDataKeyDescriptionUnion.");
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform VirtualTransform(VirtualTransform nativeValue) {
        if (Objects.nonNull(nativeValue.upper())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform.create_upper(ToDafny.Upper(nativeValue.upper()));
        }
        if (Objects.nonNull(nativeValue.lower())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform.create_lower(ToDafny.Lower(nativeValue.lower()));
        }
        if (Objects.nonNull(nativeValue.insert())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform.create_insert(ToDafny.Insert(nativeValue.insert()));
        }
        if (Objects.nonNull(nativeValue.prefix())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform.create_prefix(ToDafny.GetPrefix(nativeValue.prefix()));
        }
        if (Objects.nonNull(nativeValue.suffix())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform.create_suffix(ToDafny.GetSuffix(nativeValue.suffix()));
        }
        if (Objects.nonNull(nativeValue.substring())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform.create_substring(ToDafny.GetSubstring(nativeValue.substring()));
        }
        if (Objects.nonNull(nativeValue.segment())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform.create_segment(ToDafny.GetSegment(nativeValue.segment()));
        }
        if (Objects.nonNull(nativeValue.segments())) {
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform.create_segments(ToDafny.GetSegments(nativeValue.segments()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform.");
    }

    public static DafnySequence<? extends BeaconVersion> BeaconVersionList(List<software.amazon.cryptography.dbencryptionsdk.dynamodb.model.BeaconVersion> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::BeaconVersion, BeaconVersion._typeDescriptor());
    }

    public static DafnySequence<? extends CompoundBeacon> CompoundBeaconList(List<software.amazon.cryptography.dbencryptionsdk.dynamodb.model.CompoundBeacon> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::CompoundBeacon, CompoundBeacon._typeDescriptor());
    }

    public static DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor> ConstructorList(List<Constructor> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::Constructor, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Constructor._typeDescriptor());
    }

    public static DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart> ConstructorPartList(List<ConstructorPart> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::ConstructorPart, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.ConstructorPart._typeDescriptor());
    }

    public static DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.EncryptedDataKeyDescription> EncryptedDataKeyDescriptionList(List<EncryptedDataKeyDescription> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::EncryptedDataKeyDescription, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.EncryptedDataKeyDescription._typeDescriptor());
    }

    public static DafnySequence<? extends EncryptedPart> EncryptedPartsList(List<software.amazon.cryptography.dbencryptionsdk.dynamodb.model.EncryptedPart> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::EncryptedPart, EncryptedPart._typeDescriptor());
    }

    public static DafnySequence<? extends SignedPart> SignedPartsList(List<software.amazon.cryptography.dbencryptionsdk.dynamodb.model.SignedPart> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::SignedPart, SignedPart._typeDescriptor());
    }

    public static DafnySequence<? extends StandardBeacon> StandardBeaconList(List<software.amazon.cryptography.dbencryptionsdk.dynamodb.model.StandardBeacon> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::StandardBeacon, StandardBeacon._typeDescriptor());
    }

    public static DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField> VirtualFieldList(List<VirtualField> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::VirtualField, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualField._typeDescriptor());
    }

    public static DafnySequence<? extends VirtualPart> VirtualPartList(List<software.amazon.cryptography.dbencryptionsdk.dynamodb.model.VirtualPart> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::VirtualPart, VirtualPart._typeDescriptor());
    }

    public static DafnySequence<? extends software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform> VirtualTransformList(List<VirtualTransform> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::VirtualTransform, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.VirtualTransform._typeDescriptor());
    }

    public static DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> AttributeActions(Map<String, CryptoAction> nativeValue) {
        return ToDafny.Aggregate.GenericToMap(nativeValue, ToDafny.Simple::CharacterSequence, software.amazon.cryptography.dbencryptionsdk.structuredencryption.ToDafny::CryptoAction);
    }

    public static DafnyMap<? extends DafnySequence<? extends Character>, ? extends DynamoDbTableEncryptionConfig> DynamoDbTableEncryptionConfigList(Map<String, software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbTableEncryptionConfig> nativeValue) {
        return ToDafny.Aggregate.GenericToMap(nativeValue, ToDafny.Simple::CharacterSequence, ToDafny::DynamoDbTableEncryptionConfig);
    }

    public static software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.IDynamoDbKeyBranchKeyIdSupplier DynamoDbKeyBranchKeyIdSupplier(IDynamoDbKeyBranchKeyIdSupplier nativeValue) {
        return DynamoDbKeyBranchKeyIdSupplier.wrap(nativeValue).impl();
    }

    public static ILegacyDynamoDbEncryptor LegacyDynamoDbEncryptor(software.amazon.cryptography.dbencryptionsdk.dynamodb.ILegacyDynamoDbEncryptor nativeValue) {
        return LegacyDynamoDbEncryptor.wrap(nativeValue).impl();
    }

    public static IDynamoDbEncryptionClient DynamoDbEncryption(DynamoDbEncryption nativeValue) {
        return nativeValue.impl();
    }
}

