/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.internal;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.LRUCache;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.MsClock;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.Utils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

@ThreadSafe
public final class TTLCache<T> {
    private final LRUCache<LockedState<T>> cache;
    private final long ttlInNanos;
    private final EntryLoader<T> defaultLoader;
    MsClock clock = MsClock.WALLCLOCK;
    private static final long TTL_GRACE_IN_NANO = TimeUnit.MILLISECONDS.toNanos(500L);

    public TTLCache(int maxSize, long ttlInMillis, EntryLoader<T> loader) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("maxSize " + maxSize + " must be at least 1");
        }
        if (ttlInMillis < 1L) {
            throw new IllegalArgumentException("ttlInMillis " + maxSize + " must be at least 1");
        }
        this.ttlInNanos = TimeUnit.MILLISECONDS.toNanos(ttlInMillis);
        this.cache = new LRUCache(maxSize);
        this.defaultLoader = Utils.checkNotNull(loader, "loader must not be null");
    }

    public T load(String key) {
        return (T)this.load(key, this.defaultLoader::load);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T load(String key, Function<String, T> f) {
        LockedState<T> ls = this.cache.get(key);
        if (ls == null) {
            return this.loadNewEntryIfAbsent(key, f);
        }
        if (this.clock.timestampNano() - ls.getState().lastUpdatedNano > this.ttlInNanos + TTL_GRACE_IN_NANO) {
            this.cache.remove(key);
            return this.loadNewEntryIfAbsent(key, f);
        }
        if (this.clock.timestampNano() - ls.getState().lastUpdatedNano <= this.ttlInNanos) {
            return ls.getState().data;
        }
        if (!ls.tryLock()) {
            return ls.getState().data;
        }
        try {
            T loadedData = f.apply(key);
            ls.update(loadedData, this.clock.timestampNano());
            Object t = ls.getState().data;
            return t;
        }
        finally {
            ls.unlock();
        }
    }

    private synchronized T loadNewEntryIfAbsent(String key, Function<String, T> f) {
        LockedState<T> cachedState = this.cache.get(key);
        if (cachedState != null) {
            return cachedState.getState().data;
        }
        T loadedData = f.apply(key);
        LockedState<T> ls = new LockedState<T>(loadedData, this.clock.timestampNano());
        this.cache.add(key, ls);
        return loadedData;
    }

    public synchronized T put(String key, T value) {
        LockedState<T> ls = new LockedState<T>(value, this.clock.timestampNano());
        LockedState<T> oldLockedState = this.cache.add(key, ls);
        if (oldLockedState == null || this.clock.timestampNano() - oldLockedState.getState().lastUpdatedNano > this.ttlInNanos + TTL_GRACE_IN_NANO) {
            return null;
        }
        return oldLockedState.getState().data;
    }

    public long getLastUpdated(String key) {
        LockedState<T> ls = this.cache.get(key);
        if (ls == null) {
            return 0L;
        }
        return ls.getState().lastUpdatedNano;
    }

    public int size() {
        return this.cache.size();
    }

    public int getMaxSize() {
        return this.cache.getMaxSize();
    }

    public void clear() {
        this.cache.clear();
    }

    public String toString() {
        return this.cache.toString();
    }

    private static class State<T> {
        public final T data;
        public final long lastUpdatedNano;

        public State(T data, long lastUpdatedNano) {
            this.data = data;
            this.lastUpdatedNano = lastUpdatedNano;
        }
    }

    private static class LockedState<T> {
        private final ReentrantLock lock = new ReentrantLock(true);
        private final AtomicReference<State<T>> state;

        public LockedState(T data, long createTimeNano) {
            this.state = new AtomicReference<State<T>>(new State<T>(data, createTimeNano));
        }

        public State<T> getState() {
            return this.state.get();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public boolean tryLock() {
            return this.lock.tryLock();
        }

        public void update(T data, long createTimeNano) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Lock not held by current thread");
            }
            this.state.set(new State<T>(data, createTimeNano));
        }
    }

    public static interface EntryLoader<T> {
        public T load(String var1);
    }
}

