/*
 * Decompiled with CFR 0.152.
 */
package DynamoDbNormalizeNumber_Compile;

import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import _System.nat;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple2;
import dafny.Tuple3;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;

public class __default {
    public static DafnySequence<? extends Character> SkipLeadingZeros(DafnySequence<? extends Character> val) {
        while (BigInteger.ONE.compareTo(BigInteger.valueOf(val.length())) < 0 && ((Character)val.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '0' && ((Character)val.select(Helpers.toInt((BigInteger)BigInteger.ONE))).charValue() != '.') {
            DafnySequence _in0;
            val = _in0 = val.drop(BigInteger.ONE);
        }
        return val;
    }

    public static DafnySequence<? extends Character> SkipTrailingZeros(DafnySequence<? extends Character> val) {
        while (BigInteger.ONE.compareTo(BigInteger.valueOf(val.length())) < 0 && ((Character)val.select(Helpers.toInt((BigInteger)BigInteger.valueOf(val.length()).subtract(BigInteger.ONE)))).charValue() == '0') {
            DafnySequence _in0;
            if (((Character)val.select(Helpers.toInt((BigInteger)BigInteger.valueOf(val.length()).subtract(BigInteger.valueOf(2L))))).charValue() == '.') {
                return val.take(BigInteger.valueOf(val.length()).subtract(BigInteger.valueOf(2L)));
            }
            val = _in0 = val.take(BigInteger.valueOf(val.length()).subtract(BigInteger.ONE));
        }
        return val;
    }

    public static DafnySequence<? extends Character> SkipAllTrailingZeros(DafnySequence<? extends Character> val) {
        while (BigInteger.valueOf(val.length()).signum() == 1 && ((Character)val.select(Helpers.toInt((BigInteger)BigInteger.valueOf(val.length()).subtract(BigInteger.ONE)))).charValue() == '0') {
            DafnySequence _in0;
            val = _in0 = val.take(BigInteger.valueOf(val.length()).subtract(BigInteger.ONE));
        }
        return val;
    }

    public static boolean IsDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    public static Result<BigInteger, DafnySequence<? extends Character>> StrToIntInner(DafnySequence<? extends Character> s, BigInteger acc) {
        while (true) {
            if (BigInteger.valueOf(s.length()).signum() == 0) {
                return Result.create_Success((TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)acc);
            }
            if (!__default.IsDecimalDigit(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue())) break;
            DafnySequence _in0 = s.drop(BigInteger.ONE);
            BigInteger _in1 = acc.multiply(BigInteger.valueOf(10L)).add(BigInteger.valueOf(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue())).subtract(BigInteger.valueOf(48L));
            s = _in0;
            acc = _in1;
        }
        return Result.create_Failure((TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"The character '"), (DafnySequence)s.take(BigInteger.ONE)), (DafnySequence)DafnySequence.asString((String)"' is not a valid decimal digit.")));
    }

    public static Result<BigInteger, DafnySequence<? extends Character>> StrToInt(DafnySequence<? extends Character> s) {
        if (BigInteger.valueOf(s.length()).signum() == 0) {
            return Result.create_Failure((TypeDescriptor)TypeDescriptor.BIG_INTEGER, (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.asString((String)"An empty string is not a valid number."));
        }
        if (((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '-') {
            Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.ONE.compareTo(BigInteger.valueOf(s.length())) < 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"An empty string is not a valid number."));
            if (_0_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _0_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), TypeDescriptor.BIG_INTEGER);
            }
            Result<BigInteger, DafnySequence<? extends Character>> _1_valueOrError1 = __default.StrToIntInner((DafnySequence<? extends Character>)s.drop(BigInteger.ONE), BigInteger.ZERO);
            if (_1_valueOrError1.IsFailure(nat._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _1_valueOrError1.PropagateFailure(nat._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), TypeDescriptor.BIG_INTEGER);
            }
            BigInteger _2_x = (BigInteger)_1_valueOrError1.Extract(nat._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return Result.create_Success((TypeDescriptor)TypeDescriptor.BIG_INTEGER, (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)BigInteger.ZERO.subtract(_2_x));
        }
        if (((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '+') {
            Outcome _3_valueOrError2 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.ONE.compareTo(BigInteger.valueOf(s.length())) < 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"An empty string is not a valid number."));
            if (_3_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _3_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), TypeDescriptor.BIG_INTEGER);
            }
            return __default.StrToIntInner((DafnySequence<? extends Character>)s.drop(BigInteger.ONE), BigInteger.ZERO);
        }
        return __default.StrToIntInner(s, BigInteger.ZERO);
    }

    public static DafnySequence<? extends Character> Zeros(BigInteger n) {
        return DafnySequence.Create((TypeDescriptor)TypeDescriptor.CHAR, (BigInteger)n, _0_i_boxed0 -> {
            BigInteger _0_i = _0_i_boxed0;
            return Character.valueOf('0');
        });
    }

    public static BigInteger CountDigits(DafnySequence<? extends Character> s) {
        BigInteger _0___accumulator = BigInteger.ZERO;
        while (true) {
            DafnySequence _in0;
            if (BigInteger.valueOf(s.length()).signum() == 0) {
                return BigInteger.ZERO.add(_0___accumulator);
            }
            if (!__default.IsDecimalDigit(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue())) break;
            _0___accumulator = _0___accumulator.add(BigInteger.ONE);
            s = _in0 = s.drop(BigInteger.ONE);
        }
        return BigInteger.ZERO.add(_0___accumulator);
    }

    public static boolean IsE(char ch) {
        return ch == 'e' || ch == 'E';
    }

    public static Result<Tuple3<DafnySequence<? extends Character>, BigInteger, BigInteger>, DafnySequence<? extends Character>> ParseNumber(DafnySequence<? extends Character> n) {
        BigInteger _0_preDot = __default.CountDigits(n);
        if (Objects.equals(BigInteger.valueOf(n.length()), _0_preDot)) {
            return Result.create_Success((TypeDescriptor)Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)TypeDescriptor.BIG_INTEGER, (TypeDescriptor)TypeDescriptor.BIG_INTEGER), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)Tuple3.create(n, (Object)BigInteger.valueOf(n.length()), (Object)BigInteger.ZERO));
        }
        if (((Character)n.select(Helpers.toInt((BigInteger)_0_preDot))).charValue() == '.') {
            BigInteger _1_postDot = __default.CountDigits((DafnySequence<? extends Character>)n.drop(_0_preDot.add(BigInteger.ONE)));
            Outcome _2_valueOrError0 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (_0_preDot.add(_1_postDot).signum() == 1 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"Number needs digits either before or after the decimal point."));
            if (_2_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _2_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
            }
            BigInteger _3_len = _0_preDot.add(_1_postDot).add(BigInteger.ONE);
            if (Objects.equals(_3_len, BigInteger.valueOf(n.length()))) {
                return Result.create_Success((TypeDescriptor)Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)Tuple3.create((Object)DafnySequence.concatenate((DafnySequence)n.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)_0_preDot)), (DafnySequence)n.drop(_0_preDot.add(BigInteger.ONE))), (Object)_0_preDot, (Object)BigInteger.ZERO));
            }
            if (__default.IsE(((Character)n.select(Helpers.toInt((BigInteger)_3_len))).charValue())) {
                Result<BigInteger, DafnySequence<? extends Character>> _4_valueOrError1 = __default.StrToInt((DafnySequence<? extends Character>)n.drop(_3_len.add(BigInteger.ONE)));
                if (_4_valueOrError1.IsFailure(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                    return _4_valueOrError1.PropagateFailure(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
                }
                BigInteger _5_exp = (BigInteger)_4_valueOrError1.Extract(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
                return Result.create_Success((TypeDescriptor)Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)Tuple3.create((Object)DafnySequence.concatenate((DafnySequence)n.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)_0_preDot)), (DafnySequence)n.subsequence(Helpers.toInt((BigInteger)_0_preDot.add(BigInteger.ONE)), Helpers.toInt((BigInteger)_3_len))), (Object)_0_preDot, (Object)_5_exp));
            }
            return Result.create_Failure((TypeDescriptor)Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Invalid Character in number at '"), (DafnySequence)n.drop(_3_len)), (DafnySequence)DafnySequence.asString((String)"'.")));
        }
        if (_0_preDot.signum() == 0) {
            return Result.create_Failure((TypeDescriptor)Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.asString((String)"Number needs digits either before or after the decimal point."));
        }
        if (__default.IsE(((Character)n.select(Helpers.toInt((BigInteger)_0_preDot))).charValue())) {
            Result<BigInteger, DafnySequence<? extends Character>> _6_valueOrError2 = __default.StrToInt((DafnySequence<? extends Character>)n.drop(_0_preDot.add(BigInteger.ONE)));
            if (_6_valueOrError2.IsFailure(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _6_valueOrError2.PropagateFailure(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
            }
            BigInteger _7_exp = (BigInteger)_6_valueOrError2.Extract(TypeDescriptor.BIG_INTEGER, DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return Result.create_Success((TypeDescriptor)Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)Tuple3.create((Object)n.take(_0_preDot), (Object)_0_preDot, (Object)_7_exp));
        }
        return Result.create_Failure((TypeDescriptor)Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Invalid Character in number at '"), (DafnySequence)n.drop(_0_preDot)), (DafnySequence)DafnySequence.asString((String)"'.")));
    }

    public static BigInteger CountZeros(DafnySequence<? extends Character> value) {
        BigInteger _0___accumulator = BigInteger.ZERO;
        while (BigInteger.valueOf(value.length()).signum() != 0 && ((Character)value.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '0') {
            DafnySequence _in0;
            _0___accumulator = _0___accumulator.add(BigInteger.ONE);
            value = _in0 = value.drop(BigInteger.ONE);
        }
        return BigInteger.ZERO.add(_0___accumulator);
    }

    public static Tuple2<DafnySequence<? extends Character>, BigInteger> NormalizeValue(DafnySequence<? extends Character> value, BigInteger pos) {
        while (true) {
            if (BigInteger.valueOf(value.length()).signum() == 0) {
                return Tuple2.create(value, (Object)pos);
            }
            if (((Character)value.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '0' && pos.signum() == 1) {
                DafnySequence _in0 = value.drop(BigInteger.ONE);
                BigInteger _in1 = pos.subtract(BigInteger.ONE);
                value = _in0;
                pos = _in1;
                continue;
            }
            if (((Character)value.select(Helpers.toInt((BigInteger)BigInteger.valueOf(value.length()).subtract(BigInteger.ONE)))).charValue() != '0' || pos.compareTo(BigInteger.valueOf(value.length())) >= 0) break;
            DafnySequence _in2 = value.take(BigInteger.valueOf(value.length()).subtract(BigInteger.ONE));
            BigInteger _in3 = pos;
            value = _in2;
            pos = _in3;
        }
        return Tuple2.create((Object)value, (Object)pos);
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> NormalizePositive(DafnySequence<? extends Character> n) {
        Result<Tuple3<DafnySequence<? extends Character>, BigInteger, BigInteger>, DafnySequence<? extends Character>> _0_valueOrError0 = __default.ParseNumber(n);
        if (_0_valueOrError0.IsFailure(Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _0_valueOrError0.PropagateFailure(Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        Tuple3 _let_tmp_rhs0 = (Tuple3)_0_valueOrError0.Extract(Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)nat._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        DafnySequence _1_value = (DafnySequence)_let_tmp_rhs0.dtor__0();
        BigInteger _2_pos = (BigInteger)_let_tmp_rhs0.dtor__1();
        BigInteger _3_exp = (BigInteger)_let_tmp_rhs0.dtor__2();
        Tuple2<DafnySequence<? extends Character>, BigInteger> _let_tmp_rhs1 = __default.NormalizeValue((DafnySequence<? extends Character>)_1_value, _2_pos);
        DafnySequence _4_value = (DafnySequence)_let_tmp_rhs1.dtor__0();
        BigInteger _5_pos = (BigInteger)_let_tmp_rhs1.dtor__1();
        DafnySequence<? extends Character> _6_digitsOfPrecision = __default.SkipAllTrailingZeros(__default.SkipLeadingZeros((DafnySequence<? extends Character>)_4_value));
        Outcome _7_valueOrError1 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.valueOf(_6_digitsOfPrecision.length()).compareTo(BigInteger.valueOf(38L)) <= 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"Attempting to store more than 38 significant digits in a Number."));
        if (_7_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _7_valueOrError1.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        BigInteger _8_newPos = _5_pos.add(_3_exp);
        if (BigInteger.valueOf(_6_digitsOfPrecision.length()).signum() == 0) {
            return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.asString((String)"0"));
        }
        if (_8_newPos.signum() != 1) {
            Outcome _9_valueOrError2 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (_8_newPos.subtract(__default.CountZeros((DafnySequence<? extends Character>)_4_value)).compareTo(BigInteger.valueOf(-129L)) >= 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"Attempting to store a number with magnitude smaller than supported range."));
            if (_9_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _9_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"0."), __default.Zeros(BigInteger.ZERO.subtract(_8_newPos))), (DafnySequence)_4_value));
        }
        if (_8_newPos.compareTo(BigInteger.valueOf(_4_value.length())) >= 0) {
            Outcome _10_valueOrError3 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (_8_newPos.subtract(__default.CountZeros((DafnySequence<? extends Character>)_4_value)).compareTo(BigInteger.valueOf(126L)) <= 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"Attempting to store a number with magnitude larger than supported range."));
            if (_10_valueOrError3.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _10_valueOrError3.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.concatenate((DafnySequence)_4_value, __default.Zeros(_8_newPos.subtract(BigInteger.valueOf(_4_value.length())))));
        }
        return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)_4_value.take(_8_newPos), (DafnySequence)DafnySequence.asString((String)".")), (DafnySequence)_4_value.drop(_8_newPos)));
    }

    public static DafnySequence<? extends Character> TrimZerosFromValidNumber(DafnySequence<? extends Character> n) {
        DafnySequence<? extends Character> _0_n = __default.SkipLeadingZeros(n);
        if (_0_n.contains((Object)Character.valueOf('.'))) {
            return __default.SkipTrailingZeros(_0_n);
        }
        return _0_n;
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> NormalizeNumber2(DafnySequence<? extends Character> n) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.valueOf(n.length()).signum() == 1 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"An empty string is not a valid number."));
        if (_0_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _0_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        Tuple2 _let_tmp_rhs0 = ((Character)n.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '-' ? Tuple2.create((Object)true, (Object)n.drop(BigInteger.ONE)) : (((Character)n.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue() == '+' ? Tuple2.create((Object)false, (Object)n.drop(BigInteger.ONE)) : Tuple2.create((Object)false, n));
        boolean _1_neg = (Boolean)_let_tmp_rhs0.dtor__0();
        DafnySequence _2_n = (DafnySequence)_let_tmp_rhs0.dtor__1();
        Outcome _3_valueOrError1 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (BigInteger.valueOf(_2_n.length()).signum() == 1 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"An empty string is not a valid number."));
        if (_3_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _3_valueOrError1.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _4_valueOrError2 = __default.NormalizePositive((DafnySequence<? extends Character>)_2_n);
        if (_4_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _4_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        DafnySequence _5_n = (DafnySequence)_4_valueOrError2.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        DafnySequence<? extends Character> _6_n = __default.TrimZerosFromValidNumber((DafnySequence<? extends Character>)_5_n);
        if (_1_neg && !_6_n.equals((Object)DafnySequence.asString((String)"0"))) {
            return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.concatenate((DafnySequence)DafnySequence.of((char[])new char[]{'-'}), _6_n));
        }
        return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _6_n);
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> NormalizeNumber(DafnySequence<? extends Character> n) {
        Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _0_ret = __default.NormalizeNumber2(n);
        if (_0_ret.is_Success()) {
            return _0_ret;
        }
        return Result.create_Failure((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)((DafnySequence)_0_ret.dtor_error()), (DafnySequence)DafnySequence.asString((String)" when parsing '")), n), (DafnySequence)DafnySequence.asString((String)"'.")));
    }

    public String toString() {
        return "DynamoDbNormalizeNumber._default";
    }
}

