/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchpipelines.questionanswering.generative;

import java.util.Map;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.searchpipelines.questionanswering.generative.GenerativeQAProcessorConstants;

public class GenerativeQARequestProcessor
extends AbstractProcessor
implements SearchRequestProcessor {
    private String modelId;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    protected GenerativeQARequestProcessor(String tag, String description, boolean ignoreFailure, String modelId, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super(tag, description, ignoreFailure);
        this.modelId = modelId;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public SearchRequest processRequest(SearchRequest request) throws Exception {
        if (!this.mlFeatureEnabledSetting.isRagSearchPipelineEnabled()) {
            throw new MLException(GenerativeQAProcessorConstants.FEATURE_NOT_ENABLED_ERROR_MSG);
        }
        return request;
    }

    public String getType() {
        return "question_rewrite";
    }

    public static final class Factory
    implements Processor.Factory<SearchRequestProcessor> {
        private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

        public Factory(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
            this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        }

        public SearchRequestProcessor create(Map<String, Processor.Factory<SearchRequestProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) throws Exception {
            if (this.mlFeatureEnabledSetting.isRagSearchPipelineEnabled()) {
                return new GenerativeQARequestProcessor(tag, description, ignoreFailure, ConfigurationUtils.readStringProperty((String)"question_rewrite", (String)tag, config, (String)"model_id"), this.mlFeatureEnabledSetting);
            }
            throw new MLException(GenerativeQAProcessorConstants.FEATURE_NOT_ENABLED_ERROR_MSG);
        }
    }
}

