/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.remote.metadata.client.AbstractSdkClient;
import org.opensearch.remote.metadata.client.BulkDataObjectRequest;
import org.opensearch.remote.metadata.client.BulkDataObjectResponse;
import org.opensearch.remote.metadata.client.DataObjectRequest;
import org.opensearch.remote.metadata.client.DataObjectResponse;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectResponse;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.client.SearchDataObjectResponse;
import org.opensearch.remote.metadata.client.UpdateDataObjectRequest;
import org.opensearch.remote.metadata.client.UpdateDataObjectResponse;
import org.opensearch.remote.metadata.client.impl.AOSOpenSearchClient;
import org.opensearch.remote.metadata.client.impl.DDBJsonTransformer;
import org.opensearch.remote.metadata.client.impl.RemoteClusterIndicesClient;
import org.opensearch.remote.metadata.common.CommonValue;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.secure_sm.AccessController;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.DynamoDbItemEncryptor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model.DecryptItemInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model.DynamoDbItemEncryptorConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model.EncryptItemInput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.materialproviders.IClientSupplier;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.MaterialProviders;
import software.amazon.cryptography.materialproviders.model.CreateAwsKmsMrkMultiKeyringInput;
import software.amazon.cryptography.materialproviders.model.GetClientInput;
import software.amazon.cryptography.materialproviders.model.MaterialProvidersConfig;

public class DDBOpenSearchClient
extends AbstractSdkClient {
    private static final Logger log = LogManager.getLogger(RemoteClusterIndicesClient.class);
    private static final Long DEFAULT_SEQUENCE_NUMBER = 0L;
    private static final Long DEFAULT_PRIMARY_TERM = 1L;
    private static final String RANGE_KEY = "_id";
    private static final String HASH_KEY = "_tenant_id";
    private static final String SOURCE = "_source";
    private static final String SEQ_NO_KEY = "_seq_no";
    private DynamoDbAsyncClient dynamoDbAsyncClient;
    private AOSOpenSearchClient aosOpenSearchClient;

    public boolean supportsMetadataType(String metadataType) {
        return "AWSDynamoDB".equals(metadataType);
    }

    public void initialize(Map<String, String> metadataSettings) {
        super.initialize(metadataSettings);
        DDBOpenSearchClient.validateAwsParams(this.remoteMetadataType, this.remoteMetadataEndpoint, this.region, this.serviceName);
        this.dynamoDbAsyncClient = DDBOpenSearchClient.createDynamoDbAsyncClient(this.region);
        this.aosOpenSearchClient = new AOSOpenSearchClient();
        this.aosOpenSearchClient.initialize(metadataSettings);
    }

    public DDBOpenSearchClient() {
    }

    DDBOpenSearchClient(DynamoDbAsyncClient dynamoDbAsyncClient, AOSOpenSearchClient aosOpenSearchClient, String tenantIdField) {
        this.dynamoDbAsyncClient = dynamoDbAsyncClient;
        this.aosOpenSearchClient = aosOpenSearchClient;
        this.tenantIdField = tenantIdField;
    }

    DDBOpenSearchClient(DynamoDbAsyncClient dynamoDbAsyncClient, AOSOpenSearchClient aosOpenSearchClient, Map<String, String> metadataSettings) {
        super.initialize(metadataSettings);
        this.dynamoDbAsyncClient = dynamoDbAsyncClient;
        this.aosOpenSearchClient = aosOpenSearchClient;
    }

    public CompletionStage<PutDataObjectResponse> putDataObjectAsync(PutDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        String id = this.shouldUseId(request.id()) ? request.id() : UUID.randomUUID().toString();
        try (XContentBuilder sourceBuilder = XContentFactory.jsonBuilder();){
            IndexRequest indexRequest = new IndexRequest(request.index()).opType(request.overwriteIfExists() ? DocWriteRequest.OpType.INDEX : DocWriteRequest.OpType.CREATE).source(request.dataObject().toXContent(sourceBuilder, ToXContent.EMPTY_PARAMS));
            indexRequest.id(id);
            ActionRequestValidationException validationException = indexRequest.validate();
            if (validationException != null) {
                throw new OpenSearchStatusException(validationException.getMessage(), RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
        catch (IOException e) {
            throw new OpenSearchStatusException("Request body validation failed.", RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
        String tenantId = request.tenantId() != null ? request.tenantId() : "DEFAULT_TENANT";
        String tableName = request.index();
        GetItemRequest getItemRequest = this.buildGetItemRequest(tenantId, id, request.index());
        return (CompletionStage)AccessController.doPrivileged(() -> this.dynamoDbAsyncClient.getItem(getItemRequest).thenCompose(getItemResponse -> {
            try {
                if (!request.overwriteIfExists() && getItemResponse != null && getItemResponse.item() != null && !getItemResponse.item().isEmpty()) {
                    throw new OpenSearchStatusException("Existing data object for ID: " + request.id(), RestStatus.CONFLICT, new Object[0]);
                }
                Long sequenceNumber = this.initOrIncrementSeqNo((GetItemResponse)getItemResponse);
                String source = Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)request.dataObject());
                JsonNode jsonNode = OBJECT_MAPPER.readTree(source);
                Map<String, AttributeValue> sourceMap = DDBJsonTransformer.convertJsonObjectToDDBAttributeMap(jsonNode);
                if (request.tenantId() != null) {
                    sourceMap.put(this.tenantIdField, (AttributeValue)AttributeValue.builder().s(tenantId).build());
                }
                Map<String, Object> item = new HashMap<String, AttributeValue>();
                item.put(HASH_KEY, (AttributeValue)AttributeValue.builder().s(tenantId).build());
                item.put(RANGE_KEY, (AttributeValue)AttributeValue.builder().s(id).build());
                item.put(SOURCE, (AttributeValue)AttributeValue.builder().m(sourceMap).build());
                item.put(SEQ_NO_KEY, (AttributeValue)AttributeValue.builder().n(sequenceNumber.toString()).build());
                if (Objects.nonNull(request.cmkRoleArn())) {
                    DynamoDbItemEncryptor enc = this.getEncryptorForTable(tableName, request.cmkRoleArn(), request.assumeRoleArn());
                    item = enc.EncryptItem(EncryptItemInput.builder().plaintextItem(item).build()).encryptedItem();
                }
                PutItemRequest.Builder builder = PutItemRequest.builder().tableName(tableName).item(item);
                if (!request.overwriteIfExists()) {
                    builder.conditionExpression("attribute_not_exists(#hk) AND attribute_not_exists(#rk)").expressionAttributeNames(Map.of("#hk", HASH_KEY, "#rk", RANGE_KEY));
                } else if (request.ifSeqNo() != null) {
                    builder.conditionExpression("#seqNo = :seqNo").expressionAttributeNames(Map.of("#seqNo", SEQ_NO_KEY)).expressionAttributeValues(Map.of(":seqNo", (AttributeValue)AttributeValue.builder().n(Long.toString(request.ifSeqNo())).build()));
                }
                PutItemRequest putItemRequest = (PutItemRequest)builder.build();
                return ((CompletableFuture)this.dynamoDbAsyncClient.putItem(putItemRequest).thenApply(putItemResponse -> {
                    try {
                        String simulatedIndexResponse = DDBOpenSearchClient.simulateOpenSearchResponse(request.index(), id, source, sequenceNumber, Map.of("result", "created"));
                        return ((PutDataObjectResponse.Builder)((PutDataObjectResponse.Builder)PutDataObjectResponse.builder().id(id)).parser(SdkClientUtils.createParser((String)simulatedIndexResponse))).build();
                    }
                    catch (IOException e) {
                        throw new OpenSearchStatusException("Failed to create parser for response", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
                    }
                })).exceptionally(e -> {
                    if (e.getCause() instanceof ConditionalCheckFailedException) {
                        String message = request.overwriteIfExists() ? "Document version conflict for ID: " + request.id() : "Concurrent write detected for ID: " + request.id();
                        throw new OpenSearchStatusException(message, RestStatus.CONFLICT, new Object[0]);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new CompletionException((Throwable)e);
                });
            }
            catch (IOException e2) {
                throw new OpenSearchStatusException("Failed to parse data object " + request.id(), RestStatus.BAD_REQUEST, (Throwable)e2, new Object[0]);
            }
        }));
    }

    public CompletionStage<GetDataObjectResponse> getDataObjectAsync(GetDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        if (Boolean.FALSE.equals(isMultiTenancyEnabled) || Strings.isNullOrEmpty((String)this.globalTenantId)) {
            return this.innerGetDataObjectAsync(request, executor, isMultiTenancyEnabled);
        }
        GetDataObjectResponse getDataObjectFromCache = this.getGlobalResourceDataFromCache(request);
        if (getDataObjectFromCache != null) {
            return CompletableFuture.completedFuture(getDataObjectFromCache);
        }
        CompletionStage<GetDataObjectResponse> getDataFromDynamoDB = this.innerGetDataObjectAsync(request, executor, isMultiTenancyEnabled);
        return getDataFromDynamoDB.thenCompose(response -> {
            if (Optional.ofNullable(response).map(GetDataObjectResponse::getResponse).map(GetResponse::isExists).orElse(false).booleanValue()) {
                return CompletableFuture.completedFuture(response);
            }
            GetDataObjectRequest requestWithGlobalTenantId = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().tenantId(this.globalTenantId)).id(request.id())).index(request.index())).build();
            CompletionStage<GetDataObjectResponse> dataFetchedWithGlobalTenantId = this.innerGetDataObjectAsync(requestWithGlobalTenantId, executor, isMultiTenancyEnabled);
            return this.addToGlobalResourceCache(request, dataFetchedWithGlobalTenantId);
        });
    }

    protected CompletionStage<GetDataObjectResponse> innerGetDataObjectAsync(GetDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        GetItemRequest getItemRequest = this.buildGetItemRequest(request.tenantId(), request.id(), request.index());
        return ((CompletableFuture)AccessController.doPrivileged(() -> this.dynamoDbAsyncClient.getItem(getItemRequest))).thenApply(getItemResponse -> {
            try {
                ObjectNode sourceObject;
                boolean found;
                String sequenceNumberString = null;
                if (getItemResponse == null || getItemResponse.item() == null || getItemResponse.item().isEmpty()) {
                    found = false;
                    sourceObject = null;
                } else {
                    found = true;
                    Map resultItems = getItemResponse.item();
                    if (Objects.nonNull(request.cmkRoleArn())) {
                        DynamoDbItemEncryptor dynamoDbItemEncryptor = this.getEncryptorForTable(getItemRequest.tableName(), request.cmkRoleArn(), request.assumeRoleArn());
                        resultItems = dynamoDbItemEncryptor.DecryptItem(DecryptItemInput.builder().encryptedItem(getItemResponse.item()).build()).plaintextItem();
                    }
                    sourceObject = DDBJsonTransformer.convertDDBAttributeValueMapToObjectNode(((AttributeValue)resultItems.get(SOURCE)).m());
                    if (getItemResponse.item().containsKey(SEQ_NO_KEY)) {
                        sequenceNumberString = ((AttributeValue)getItemResponse.item().get(SEQ_NO_KEY)).n();
                    }
                }
                String source = OBJECT_MAPPER.writeValueAsString(sourceObject);
                Long sequenceNumber = sequenceNumberString == null || sequenceNumberString.isEmpty() ? null : Long.valueOf(Long.parseLong(sequenceNumberString));
                String simulatedGetResponse = DDBOpenSearchClient.simulateOpenSearchResponse(request.index(), request.id(), source, sequenceNumber, Map.of("found", found));
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, simulatedGetResponse);
                Map sourceAsMap = GetResponse.fromXContent((XContentParser)JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, simulatedGetResponse)).getSourceAsMap();
                return ((GetDataObjectResponse.Builder)((GetDataObjectResponse.Builder)GetDataObjectResponse.builder().id(request.id())).parser(parser)).source(sourceAsMap).build();
            }
            catch (IOException e) {
                throw new OpenSearchStatusException("Failed to parse response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
        });
    }

    public CompletionStage<UpdateDataObjectResponse> updateDataObjectAsync(UpdateDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        try (XContentBuilder sourceBuilder = XContentFactory.jsonBuilder();){
            ActionRequestValidationException validationException;
            UpdateRequest updateRequest = new UpdateRequest(request.index(), request.id()).doc(request.dataObject().toXContent(sourceBuilder, ToXContent.EMPTY_PARAMS));
            if (request.ifSeqNo() != null) {
                updateRequest.setIfSeqNo(request.ifSeqNo().longValue());
            }
            if (request.ifPrimaryTerm() != null) {
                updateRequest.setIfPrimaryTerm(request.ifPrimaryTerm().longValue());
            }
            if (request.retryOnConflict() > 0) {
                updateRequest.retryOnConflict(request.retryOnConflict());
            }
            if ((validationException = updateRequest.validate()) != null) {
                throw new OpenSearchStatusException(validationException.getMessage(), RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
        catch (IOException e) {
            throw new OpenSearchStatusException("Request body validation failed.", RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
        return this.isGlobalResource(request.index(), request.id(), executor, isMultiTenancyEnabled).thenCompose(isGlobalResource -> {
            if (isGlobalResource.booleanValue()) {
                return this.updateItem(request, this.globalTenantId);
            }
            return this.updateItem(request, request.tenantId() != null ? request.tenantId() : "DEFAULT_TENANT");
        }).exceptionally(t -> {
            Throwable cause;
            log.error("Failed to check the resource type, aborting the update", t);
            Throwable throwable = cause = t.getCause() != null ? t.getCause() : t;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new CompletionException("Failed to get the item.", cause);
        });
    }

    private CompletionStage<UpdateDataObjectResponse> updateItem(UpdateDataObjectRequest request, String tenantId) {
        return (CompletionStage)AccessController.doPrivileged(() -> {
            try {
                String source = Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)request.dataObject());
                JsonNode jsonNode = OBJECT_MAPPER.readTree(source);
                return this.updateItemWithRetryOnConflict(tenantId, jsonNode, request).thenApply(sequenceNumber -> {
                    try {
                        String simulatedUpdateResponse = DDBOpenSearchClient.simulateOpenSearchResponse(request.index(), request.id(), source, sequenceNumber, Map.of("result", "updated"));
                        return ((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)UpdateDataObjectResponse.builder().id(request.id())).parser(SdkClientUtils.createParser((String)simulatedUpdateResponse))).build();
                    }
                    catch (IOException e) {
                        throw new OpenSearchStatusException("Parsing error creating update response", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
                    }
                });
            }
            catch (IOException e) {
                log.error("Error updating {} in {}: {}", (Object)request.id(), (Object)request.index(), (Object)e.getMessage(), (Object)e);
                throw new OpenSearchStatusException("Parsing error updating data object " + request.id() + " in index " + request.index(), RestStatus.BAD_REQUEST, new Object[0]);
            }
        });
    }

    private CompletionStage<Long> updateItemWithRetryOnConflict(String tenantId, JsonNode jsonNode, UpdateDataObjectRequest request) {
        Map<String, AttributeValue> updateItem = DDBJsonTransformer.convertJsonObjectToDDBAttributeMap(jsonNode);
        updateItem.remove(this.tenantIdField);
        updateItem.remove(RANGE_KEY);
        HashMap<String, AttributeValue> updateKey = new HashMap<String, AttributeValue>();
        updateKey.put(HASH_KEY, (AttributeValue)AttributeValue.builder().s(tenantId).build());
        updateKey.put(RANGE_KEY, (AttributeValue)AttributeValue.builder().s(request.id()).build());
        HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
        expressionAttributeNames.put("#seqNo", SEQ_NO_KEY);
        expressionAttributeNames.put("#source", SOURCE);
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(":incr", (AttributeValue)AttributeValue.builder().n("1").build());
        return this.retryUpdate(request, updateKey, updateItem, expressionAttributeNames, expressionAttributeValues, request.retryOnConflict());
    }

    private CompletionStage<Long> retryUpdate(UpdateDataObjectRequest request, Map<String, AttributeValue> updateKey, Map<String, AttributeValue> updateItem, Map<String, String> expressionAttributeNames, Map<String, AttributeValue> expressionAttributeValues, int retriesRemaining) {
        return this.dynamoDbAsyncClient.getItem((GetItemRequest)GetItemRequest.builder().tableName(request.index()).key(updateKey).build()).thenCompose(currentItem -> {
            HashMap dataObject = new HashMap(((AttributeValue)currentItem.item().get(SOURCE)).m());
            dataObject.putAll(updateItem);
            expressionAttributeValues.put(":source", (AttributeValue)AttributeValue.builder().m(dataObject).build());
            if (request.ifSeqNo() != null) {
                expressionAttributeValues.put(":currentSeqNo", (AttributeValue)AttributeValue.builder().n(Long.toString(request.ifSeqNo())).build());
            } else {
                expressionAttributeValues.put(":currentSeqNo", (AttributeValue)currentItem.item().get(SEQ_NO_KEY));
            }
            UpdateItemRequest.Builder updateItemRequestBuilder = UpdateItemRequest.builder().tableName(request.index()).key(updateKey);
            updateItemRequestBuilder.updateExpression("SET #seqNo = #seqNo + :incr, #source = :source ");
            updateItemRequestBuilder.conditionExpression("#seqNo = :currentSeqNo");
            updateItemRequestBuilder.expressionAttributeNames(expressionAttributeNames).expressionAttributeValues(expressionAttributeValues);
            updateItemRequestBuilder.returnValues("UPDATED_NEW");
            UpdateItemRequest updateItemRequest = (UpdateItemRequest)updateItemRequestBuilder.build();
            return ((CompletableFuture)this.dynamoDbAsyncClient.updateItem(updateItemRequest).thenApply(updateItemResponse -> {
                if (updateItemResponse != null && updateItemResponse.attributes() != null && updateItemResponse.attributes().containsKey(SEQ_NO_KEY)) {
                    return Long.parseLong(((AttributeValue)updateItemResponse.attributes().get(SEQ_NO_KEY)).n());
                }
                return null;
            })).exceptionally(e -> {
                if (e.getCause() instanceof ConditionalCheckFailedException) {
                    if (retriesRemaining > 0) {
                        return this.retryUpdate(request, updateKey, updateItem, expressionAttributeNames, expressionAttributeValues, retriesRemaining - 1).toCompletableFuture().join();
                    }
                    String message = "Document version conflict updating " + request.id() + " in index " + request.index();
                    log.error(message + ": {}", (Object)e.getMessage(), e);
                    throw new OpenSearchStatusException(message, RestStatus.CONFLICT, new Object[0]);
                }
                throw new CompletionException((Throwable)e);
            });
        });
    }

    public CompletionStage<DeleteDataObjectResponse> deleteDataObjectAsync(DeleteDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        String tenantId = request.tenantId() != null ? request.tenantId() : "DEFAULT_TENANT";
        DeleteItemRequest.Builder builder = DeleteItemRequest.builder().tableName(request.index()).key(Map.ofEntries(Map.entry(HASH_KEY, (AttributeValue)AttributeValue.builder().s(tenantId).build()), Map.entry(RANGE_KEY, (AttributeValue)AttributeValue.builder().s(request.id()).build()))).returnValues("ALL_OLD");
        if (request.ifSeqNo() != null) {
            builder.conditionExpression("#seqNo = :seqNo").expressionAttributeNames(Map.of("#seqNo", SEQ_NO_KEY)).expressionAttributeValues(Map.of(":seqNo", (AttributeValue)AttributeValue.builder().n(Long.toString(request.ifSeqNo())).build()));
        }
        DeleteItemRequest deleteItemRequest = (DeleteItemRequest)builder.build();
        return (CompletionStage)AccessController.doPrivileged(() -> ((CompletableFuture)this.dynamoDbAsyncClient.deleteItem(deleteItemRequest).thenApply(deleteItemResponse -> {
            try {
                Long sequenceNumber = null;
                if (deleteItemResponse.attributes() != null && deleteItemResponse.attributes().containsKey(SEQ_NO_KEY)) {
                    sequenceNumber = Long.parseLong(((AttributeValue)deleteItemResponse.attributes().get(SEQ_NO_KEY)).n()) + 1L;
                }
                String simulatedDeleteResponse = DDBOpenSearchClient.simulateOpenSearchResponse(request.index(), request.id(), null, sequenceNumber, Map.of("result", "deleted"));
                return ((DeleteDataObjectResponse.Builder)((DeleteDataObjectResponse.Builder)DeleteDataObjectResponse.builder().id(request.id())).parser(SdkClientUtils.createParser((String)simulatedDeleteResponse))).build();
            }
            catch (IOException e) {
                throw new OpenSearchStatusException("Failed to parse response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
        })).exceptionally(e -> {
            if (e.getCause() instanceof ConditionalCheckFailedException) {
                String message = "Document version conflict deleting " + request.id() + " from index " + request.index();
                throw new OpenSearchStatusException(message, RestStatus.CONFLICT, new Object[0]);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CompletionException((Throwable)e);
        }));
    }

    public CompletionStage<BulkDataObjectResponse> bulkDataObjectAsync(BulkDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        return (CompletionStage)AccessController.doPrivileged(() -> {
            log.info("Performing {} bulk actions on table {}", (Object)request.requests().size(), (Object)request.getIndices());
            long startNanos = System.nanoTime();
            return this.processBulkRequestsAsync(request.requests(), 0, new ArrayList<DataObjectResponse>(), executor, isMultiTenancyEnabled).thenCompose(responses -> {
                long endNanos = System.nanoTime();
                long tookMillis = TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos);
                log.info("Bulk action complete for {} items, took {} ms", (Object)responses.size(), (Object)tookMillis);
                return this.buildBulkDataObjectResponse((List<DataObjectResponse>)responses, tookMillis);
            });
        });
    }

    private CompletionStage<List<DataObjectResponse>> processBulkRequestsAsync(List<DataObjectRequest> requests, int index, List<DataObjectResponse> responses, Executor executor, Boolean isMultiTenancyEnabled) {
        if (index >= requests.size()) {
            return CompletableFuture.completedFuture(responses);
        }
        DataObjectRequest dataObjectRequest = requests.get(index);
        CompletionStage<Object> futureResponse = dataObjectRequest instanceof PutDataObjectRequest ? this.putDataObjectAsync((PutDataObjectRequest)dataObjectRequest, executor, isMultiTenancyEnabled) : (dataObjectRequest instanceof UpdateDataObjectRequest ? this.updateDataObjectAsync((UpdateDataObjectRequest)dataObjectRequest, executor, isMultiTenancyEnabled) : (dataObjectRequest instanceof DeleteDataObjectRequest ? this.deleteDataObjectAsync((DeleteDataObjectRequest)dataObjectRequest, executor, isMultiTenancyEnabled) : CompletableFuture.failedFuture(new IllegalArgumentException("Unsupported request type: " + dataObjectRequest.getClass().getSimpleName()))));
        return futureResponse.handle((response, throwable) -> {
            if (throwable != null) {
                Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                RestStatus status = ExceptionsHelper.status((Throwable)cause);
                if (dataObjectRequest instanceof PutDataObjectRequest) {
                    return ((PutDataObjectResponse.Builder)((PutDataObjectResponse.Builder)((PutDataObjectResponse.Builder)((PutDataObjectResponse.Builder)((PutDataObjectResponse.Builder)new PutDataObjectResponse.Builder().index(dataObjectRequest.index())).id(dataObjectRequest.id())).failed(true)).cause(cause)).status(status)).build();
                }
                if (dataObjectRequest instanceof UpdateDataObjectRequest) {
                    return ((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)((UpdateDataObjectResponse.Builder)new UpdateDataObjectResponse.Builder().index(dataObjectRequest.index())).id(dataObjectRequest.id())).failed(true)).cause(cause)).status(status)).build();
                }
                if (dataObjectRequest instanceof DeleteDataObjectRequest) {
                    return ((DeleteDataObjectResponse.Builder)((DeleteDataObjectResponse.Builder)((DeleteDataObjectResponse.Builder)((DeleteDataObjectResponse.Builder)((DeleteDataObjectResponse.Builder)new DeleteDataObjectResponse.Builder().index(dataObjectRequest.index())).id(dataObjectRequest.id())).failed(true)).cause(cause)).status(status)).build();
                }
                log.error("Error in bulk operation for id {}: {}", (Object)dataObjectRequest.id(), (Object)throwable.getMessage(), throwable);
            }
            return response;
        }).thenCompose(response -> {
            responses.add((DataObjectResponse)response);
            return this.processBulkRequestsAsync(requests, index + 1, responses, executor, isMultiTenancyEnabled);
        });
    }

    private CompletionStage<BulkDataObjectResponse> buildBulkDataObjectResponse(List<DataObjectResponse> responses, long tookMillis) {
        CompletableFuture<BulkDataObjectResponse> completableFuture;
        block9: {
            BulkItemResponse[] responseArray = new BulkItemResponse[responses.size()];
            XContentBuilder builder = XContentFactory.jsonBuilder();
            try {
                for (int id = 0; id < responses.size(); ++id) {
                    responseArray[id] = this.buildBulkItemResponse(responses, id);
                }
                BulkResponse br = new BulkResponse(responseArray, tookMillis);
                br.toXContent(builder, ToXContent.EMPTY_PARAMS);
                completableFuture = CompletableFuture.completedFuture(new BulkDataObjectResponse(responses.toArray(new DataObjectResponse[0]), tookMillis, br.hasFailures(), SdkClientUtils.createParser((String)builder.toString())));
                if (builder == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture((Throwable)new OpenSearchStatusException("Failed to parse bulk response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }
            builder.close();
        }
        return completableFuture;
    }

    private BulkItemResponse buildBulkItemResponse(List<DataObjectResponse> responses, int bulkId) throws IOException {
        DataObjectResponse response = responses.get(bulkId);
        DocWriteRequest.OpType opType = null;
        if (response instanceof PutDataObjectResponse) {
            opType = DocWriteRequest.OpType.INDEX;
        } else if (response instanceof UpdateDataObjectResponse) {
            opType = DocWriteRequest.OpType.UPDATE;
        } else if (response instanceof DeleteDataObjectResponse) {
            opType = DocWriteRequest.OpType.DELETE;
        }
        if (response.isFailed()) {
            return new BulkItemResponse(bulkId, opType, new BulkItemResponse.Failure(response.index(), response.id(), response.cause()));
        }
        IndexResponse writeResponse = null;
        if (response instanceof PutDataObjectResponse) {
            writeResponse = IndexResponse.fromXContent((XContentParser)response.parser());
        } else if (response instanceof UpdateDataObjectResponse) {
            writeResponse = UpdateResponse.fromXContent((XContentParser)response.parser());
        } else if (response instanceof DeleteDataObjectResponse) {
            writeResponse = DeleteResponse.fromXContent((XContentParser)response.parser());
        }
        return new BulkItemResponse(bulkId, opType, (DocWriteResponse)writeResponse);
    }

    public CompletionStage<SearchDataObjectResponse> searchDataObjectAsync(SearchDataObjectRequest request, Executor executor, Boolean isMultiTenancyEnabled) {
        List<String> indices = Arrays.stream(request.indices()).map(this::getIndexName).collect(Collectors.toList());
        SearchDataObjectRequest searchDataObjectRequest = new SearchDataObjectRequest(indices.toArray(new String[0]), request.tenantId(), request.searchSourceBuilder());
        return this.aosOpenSearchClient.searchDataObjectAsync(searchDataObjectRequest, executor, isMultiTenancyEnabled);
    }

    private String getIndexName(String index) {
        return index.length() > 1 && index.charAt(0) == '.' ? index.substring(1) : index;
    }

    private GetItemRequest buildGetItemRequest(String requestTenantId, String documentId, String index) {
        String tenantId = requestTenantId != null ? requestTenantId : "DEFAULT_TENANT";
        return (GetItemRequest)GetItemRequest.builder().tableName(index).key(Map.ofEntries(Map.entry(HASH_KEY, (AttributeValue)AttributeValue.builder().s(tenantId).build()), Map.entry(RANGE_KEY, (AttributeValue)AttributeValue.builder().s(documentId).build()))).consistentRead(Boolean.valueOf(true)).build();
    }

    private Long initOrIncrementSeqNo(GetItemResponse getItemResponse) {
        Long sequenceNumber = DEFAULT_SEQUENCE_NUMBER;
        if (getItemResponse != null && getItemResponse.item() != null && getItemResponse.item().containsKey(SEQ_NO_KEY)) {
            sequenceNumber = Long.parseLong(((AttributeValue)getItemResponse.item().get(SEQ_NO_KEY)).n()) + 1L;
        }
        return sequenceNumber;
    }

    static String simulateOpenSearchResponse(String index, String id, String source, Long sequenceNumber, Map<String, Object> additionalFields) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("_index", index);
        response.put(RANGE_KEY, id);
        if (sequenceNumber == null) {
            response.put("_primary_term", 0L);
            response.put(SEQ_NO_KEY, -2L);
        } else {
            response.put("_primary_term", DEFAULT_PRIMARY_TERM);
            response.put(SEQ_NO_KEY, sequenceNumber);
        }
        response.put("_version", -1);
        response.put("_shards", new ReplicationResponse.ShardInfo());
        response.putAll(additionalFields);
        if (source != null) {
            response.put(SOURCE, mapper.readTree(source));
        }
        return mapper.writeValueAsString(response);
    }

    private static void validateAwsParams(String clientType, String remoteMetadataEndpoint, String region, String serviceName) {
        if (Strings.isNullOrEmpty((String)remoteMetadataEndpoint) || Strings.isNullOrEmpty((String)region)) {
            throw new OpenSearchException(clientType + " client requires a metadata endpoint and region.", new Object[0]);
        }
        if (serviceName == null) {
            throw new OpenSearchException(clientType + " client requires a service name.", new Object[0]);
        }
        if (!CommonValue.VALID_AWS_OPENSEARCH_SERVICE_NAMES.contains(serviceName)) {
            throw new OpenSearchException(clientType + " client only supports service names " + String.valueOf(CommonValue.VALID_AWS_OPENSEARCH_SERVICE_NAMES), new Object[0]);
        }
    }

    private static DynamoDbAsyncClient createDynamoDbAsyncClient(String region) {
        if (region == null) {
            throw new IllegalStateException("REGION environment variable needs to be set!");
        }
        return (DynamoDbAsyncClient)AccessController.doPrivileged(() -> (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)((DynamoDbAsyncClientBuilder)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().httpClient(NettyNioAsyncHttpClient.builder().build())).region(Region.of((String)region))).credentialsProvider(DDBOpenSearchClient.createCredentialsProvider())).build());
    }

    private static AwsCredentialsProvider createCredentialsProvider() {
        return AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)ContainerCredentialsProvider.builder().build()).addCredentialsProvider((AwsCredentialsProvider)InstanceProfileCredentialsProvider.create()).build();
    }

    private static AwsCredentialsProvider createCredentialsByAssumeRole(String assumeRoleArn) {
        AwsCredentialsProvider baseProvider = DDBOpenSearchClient.createCredentialsProvider();
        if (Objects.isNull(assumeRoleArn)) {
            return baseProvider;
        }
        StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(baseProvider)).region(Region.AWS_GLOBAL)).build();
        StsAssumeRoleCredentialsProvider assumeRoleProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(req -> req.roleArn(assumeRoleArn).roleSessionName("kms-assume-session")).build();
        return AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)assumeRoleProvider).addCredentialsProvider(baseProvider).build();
    }

    public void close() throws Exception {
        if (this.dynamoDbAsyncClient != null) {
            this.dynamoDbAsyncClient.close();
        }
        if (this.aosOpenSearchClient != null) {
            this.aosOpenSearchClient.close();
        }
    }

    public DynamoDbItemEncryptor getEncryptorForTable(String tableName, String kmsKeyArn, String assumeRoleArn) {
        String[] arnParts = kmsKeyArn.split(":", 6);
        FixedCredsKmsClientSupplier supplier = new FixedCredsKmsClientSupplier(DDBOpenSearchClient.createCredentialsByAssumeRole(assumeRoleArn), Region.of((String)arnParts[3]));
        MaterialProviders matProv = MaterialProviders.builder().MaterialProvidersConfig(MaterialProvidersConfig.builder().build()).build();
        IKeyring kmsKeyring = matProv.CreateAwsKmsMrkMultiKeyring(CreateAwsKmsMrkMultiKeyringInput.builder().generator(kmsKeyArn).clientSupplier((IClientSupplier)supplier).build());
        HashMap<String, CryptoAction> actions = new HashMap<String, CryptoAction>();
        actions.put(HASH_KEY, CryptoAction.SIGN_ONLY);
        actions.put(RANGE_KEY, CryptoAction.SIGN_ONLY);
        actions.put(SOURCE, CryptoAction.ENCRYPT_AND_SIGN);
        actions.put(SEQ_NO_KEY, CryptoAction.SIGN_ONLY);
        DynamoDbItemEncryptorConfig itemConfig = DynamoDbItemEncryptorConfig.builder().logicalTableName(tableName).partitionKeyName(HASH_KEY).sortKeyName(RANGE_KEY).attributeActionsOnEncrypt(actions).allowedUnsignedAttributePrefix(":").keyring(kmsKeyring).build();
        return DynamoDbItemEncryptor.builder().DynamoDbItemEncryptorConfig(itemConfig).build();
    }

    static final class FixedCredsKmsClientSupplier
    implements IClientSupplier {
        private final AwsCredentialsProvider creds;
        private final Region region;

        FixedCredsKmsClientSupplier(AwsCredentialsProvider creds, Region region) {
            this.creds = creds;
            this.region = region;
        }

        public KmsClient GetClient(GetClientInput input) {
            return (KmsClient)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().region(this.region)).credentialsProvider(this.creds)).build();
        }
    }
}

