/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredDataTerminal;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.model.DBEAlgorithmSuiteId;

public class EncryptStructureInput {
    private final String tableName;
    private final Map<String, StructuredDataTerminal> plaintextStructure;
    private final Map<String, CryptoAction> cryptoSchema;
    private final ICryptographicMaterialsManager cmm;
    private final DBEAlgorithmSuiteId algorithmSuiteId;
    private final Map<String, String> encryptionContext;

    protected EncryptStructureInput(BuilderImpl builder) {
        this.tableName = builder.tableName();
        this.plaintextStructure = builder.plaintextStructure();
        this.cryptoSchema = builder.cryptoSchema();
        this.cmm = builder.cmm();
        this.algorithmSuiteId = builder.algorithmSuiteId();
        this.encryptionContext = builder.encryptionContext();
    }

    public String tableName() {
        return this.tableName;
    }

    public Map<String, StructuredDataTerminal> plaintextStructure() {
        return this.plaintextStructure;
    }

    public Map<String, CryptoAction> cryptoSchema() {
        return this.cryptoSchema;
    }

    public ICryptographicMaterialsManager cmm() {
        return this.cmm;
    }

    public DBEAlgorithmSuiteId algorithmSuiteId() {
        return this.algorithmSuiteId;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String tableName;
        protected Map<String, StructuredDataTerminal> plaintextStructure;
        protected Map<String, CryptoAction> cryptoSchema;
        protected ICryptographicMaterialsManager cmm;
        protected DBEAlgorithmSuiteId algorithmSuiteId;
        protected Map<String, String> encryptionContext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EncryptStructureInput model) {
            this.tableName = model.tableName();
            this.plaintextStructure = model.plaintextStructure();
            this.cryptoSchema = model.cryptoSchema();
            this.cmm = model.cmm();
            this.algorithmSuiteId = model.algorithmSuiteId();
            this.encryptionContext = model.encryptionContext();
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public String tableName() {
            return this.tableName;
        }

        @Override
        public Builder plaintextStructure(Map<String, StructuredDataTerminal> plaintextStructure) {
            this.plaintextStructure = plaintextStructure;
            return this;
        }

        @Override
        public Map<String, StructuredDataTerminal> plaintextStructure() {
            return this.plaintextStructure;
        }

        @Override
        public Builder cryptoSchema(Map<String, CryptoAction> cryptoSchema) {
            this.cryptoSchema = cryptoSchema;
            return this;
        }

        @Override
        public Map<String, CryptoAction> cryptoSchema() {
            return this.cryptoSchema;
        }

        @Override
        public Builder cmm(ICryptographicMaterialsManager cmm) {
            this.cmm = CryptographicMaterialsManager.wrap((ICryptographicMaterialsManager)cmm);
            return this;
        }

        @Override
        public ICryptographicMaterialsManager cmm() {
            return this.cmm;
        }

        @Override
        public Builder algorithmSuiteId(DBEAlgorithmSuiteId algorithmSuiteId) {
            this.algorithmSuiteId = algorithmSuiteId;
            return this;
        }

        @Override
        public DBEAlgorithmSuiteId algorithmSuiteId() {
            return this.algorithmSuiteId;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public EncryptStructureInput build() {
            if (Objects.isNull(this.tableName())) {
                throw new IllegalArgumentException("Missing value for required field `tableName`");
            }
            if (Objects.isNull(this.plaintextStructure())) {
                throw new IllegalArgumentException("Missing value for required field `plaintextStructure`");
            }
            if (Objects.isNull(this.cryptoSchema())) {
                throw new IllegalArgumentException("Missing value for required field `cryptoSchema`");
            }
            if (Objects.isNull(this.cmm())) {
                throw new IllegalArgumentException("Missing value for required field `cmm`");
            }
            return new EncryptStructureInput(this);
        }
    }

    public static interface Builder {
        public Builder tableName(String var1);

        public String tableName();

        public Builder plaintextStructure(Map<String, StructuredDataTerminal> var1);

        public Map<String, StructuredDataTerminal> plaintextStructure();

        public Builder cryptoSchema(Map<String, CryptoAction> var1);

        public Map<String, CryptoAction> cryptoSchema();

        public Builder cmm(ICryptographicMaterialsManager var1);

        public ICryptographicMaterialsManager cmm();

        public Builder algorithmSuiteId(DBEAlgorithmSuiteId var1);

        public DBEAlgorithmSuiteId algorithmSuiteId();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public EncryptStructureInput build();
    }
}

