/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.ILegacyDynamoDbEncryptor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.LegacyDynamoDbEncryptor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.LegacyPolicy;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;

public class LegacyOverride {
    private final LegacyPolicy policy;
    private final ILegacyDynamoDbEncryptor encryptor;
    private final Map<String, CryptoAction> attributeActionsOnEncrypt;
    private final CryptoAction defaultAttributeFlag;

    protected LegacyOverride(BuilderImpl builder) {
        this.policy = builder.policy();
        this.encryptor = builder.encryptor();
        this.attributeActionsOnEncrypt = builder.attributeActionsOnEncrypt();
        this.defaultAttributeFlag = builder.defaultAttributeFlag();
    }

    public LegacyPolicy policy() {
        return this.policy;
    }

    public ILegacyDynamoDbEncryptor encryptor() {
        return this.encryptor;
    }

    public Map<String, CryptoAction> attributeActionsOnEncrypt() {
        return this.attributeActionsOnEncrypt;
    }

    public CryptoAction defaultAttributeFlag() {
        return this.defaultAttributeFlag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected LegacyPolicy policy;
        protected ILegacyDynamoDbEncryptor encryptor;
        protected Map<String, CryptoAction> attributeActionsOnEncrypt;
        protected CryptoAction defaultAttributeFlag;

        protected BuilderImpl() {
        }

        protected BuilderImpl(LegacyOverride model) {
            this.policy = model.policy();
            this.encryptor = model.encryptor();
            this.attributeActionsOnEncrypt = model.attributeActionsOnEncrypt();
            this.defaultAttributeFlag = model.defaultAttributeFlag();
        }

        @Override
        public Builder policy(LegacyPolicy policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public LegacyPolicy policy() {
            return this.policy;
        }

        @Override
        public Builder encryptor(ILegacyDynamoDbEncryptor encryptor) {
            this.encryptor = LegacyDynamoDbEncryptor.wrap(encryptor);
            return this;
        }

        @Override
        public ILegacyDynamoDbEncryptor encryptor() {
            return this.encryptor;
        }

        @Override
        public Builder attributeActionsOnEncrypt(Map<String, CryptoAction> attributeActionsOnEncrypt) {
            this.attributeActionsOnEncrypt = attributeActionsOnEncrypt;
            return this;
        }

        @Override
        public Map<String, CryptoAction> attributeActionsOnEncrypt() {
            return this.attributeActionsOnEncrypt;
        }

        @Override
        public Builder defaultAttributeFlag(CryptoAction defaultAttributeFlag) {
            this.defaultAttributeFlag = defaultAttributeFlag;
            return this;
        }

        @Override
        public CryptoAction defaultAttributeFlag() {
            return this.defaultAttributeFlag;
        }

        @Override
        public LegacyOverride build() {
            if (Objects.isNull((Object)this.policy())) {
                throw new IllegalArgumentException("Missing value for required field `policy`");
            }
            if (Objects.isNull(this.encryptor())) {
                throw new IllegalArgumentException("Missing value for required field `encryptor`");
            }
            if (Objects.isNull(this.attributeActionsOnEncrypt())) {
                throw new IllegalArgumentException("Missing value for required field `attributeActionsOnEncrypt`");
            }
            return new LegacyOverride(this);
        }
    }

    public static interface Builder {
        public Builder policy(LegacyPolicy var1);

        public LegacyPolicy policy();

        public Builder encryptor(ILegacyDynamoDbEncryptor var1);

        public ILegacyDynamoDbEncryptor encryptor();

        public Builder attributeActionsOnEncrypt(Map<String, CryptoAction> var1);

        public Map<String, CryptoAction> attributeActionsOnEncrypt();

        public Builder defaultAttributeFlag(CryptoAction var1);

        public CryptoAction defaultAttributeFlag();

        public LegacyOverride build();
    }
}

