/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;

public class GetSegments {
    private final String split;
    private final Integer low;
    private final Integer high;

    protected GetSegments(BuilderImpl builder) {
        this.split = builder.split();
        this.low = builder.low();
        this.high = builder.high();
    }

    public String split() {
        return this.split;
    }

    public Integer low() {
        return this.low;
    }

    public Integer high() {
        return this.high;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String split;
        protected Integer low;
        protected Integer high;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetSegments model) {
            this.split = model.split();
            this.low = model.low();
            this.high = model.high();
        }

        @Override
        public Builder split(String split) {
            this.split = split;
            return this;
        }

        @Override
        public String split() {
            return this.split;
        }

        @Override
        public Builder low(Integer low) {
            this.low = low;
            return this;
        }

        @Override
        public Integer low() {
            return this.low;
        }

        @Override
        public Builder high(Integer high) {
            this.high = high;
            return this;
        }

        @Override
        public Integer high() {
            return this.high;
        }

        @Override
        public GetSegments build() {
            if (Objects.isNull(this.split())) {
                throw new IllegalArgumentException("Missing value for required field `split`");
            }
            if (Objects.nonNull(this.split()) && this.split().length() < 1) {
                throw new IllegalArgumentException("The size of `split` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.split()) && this.split().length() > 1) {
                throw new IllegalArgumentException("The size of `split` must be less than or equal to 1");
            }
            if (Objects.isNull(this.low())) {
                throw new IllegalArgumentException("Missing value for required field `low`");
            }
            if (Objects.isNull(this.high())) {
                throw new IllegalArgumentException("Missing value for required field `high`");
            }
            return new GetSegments(this);
        }
    }

    public static interface Builder {
        public Builder split(String var1);

        public String split();

        public Builder low(Integer var1);

        public Integer low();

        public Builder high(Integer var1);

        public Integer high();

        public GetSegments build();
    }
}

