/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.MultiKeyStore;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.SingleKeyStore;

public class BeaconKeySource {
    private final SingleKeyStore single;
    private final MultiKeyStore multi;

    protected BeaconKeySource(BuilderImpl builder) {
        this.single = builder.single();
        this.multi = builder.multi();
    }

    public SingleKeyStore single() {
        return this.single;
    }

    public MultiKeyStore multi() {
        return this.multi;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected SingleKeyStore single;
        protected MultiKeyStore multi;

        protected BuilderImpl() {
        }

        protected BuilderImpl(BeaconKeySource model) {
            this.single = model.single();
            this.multi = model.multi();
        }

        @Override
        public Builder single(SingleKeyStore single) {
            this.single = single;
            return this;
        }

        @Override
        public SingleKeyStore single() {
            return this.single;
        }

        @Override
        public Builder multi(MultiKeyStore multi) {
            this.multi = multi;
            return this;
        }

        @Override
        public MultiKeyStore multi() {
            return this.multi;
        }

        @Override
        public BeaconKeySource build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`BeaconKeySource` is a Union. A Union MUST have one and only one value set.");
            }
            return new BeaconKeySource(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.single, this.multi};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder single(SingleKeyStore var1);

        public SingleKeyStore single();

        public Builder multi(MultiKeyStore var1);

        public MultiKeyStore multi();

        public BeaconKeySource build();
    }
}

