/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.DecryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.EncryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.SymmetricRawMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Map;
import javax.crypto.SecretKey;

public class SymmetricStaticProvider
implements EncryptionMaterialsProvider {
    private final SymmetricRawMaterials materials;

    public SymmetricStaticProvider(SecretKey encryptionKey, KeyPair signingPair) {
        this(encryptionKey, signingPair, Collections.emptyMap());
    }

    public SymmetricStaticProvider(SecretKey encryptionKey, KeyPair signingPair, Map<String, String> description) {
        this.materials = new SymmetricRawMaterials(encryptionKey, signingPair, description);
    }

    public SymmetricStaticProvider(SecretKey encryptionKey, SecretKey macKey) {
        this(encryptionKey, macKey, Collections.emptyMap());
    }

    public SymmetricStaticProvider(SecretKey encryptionKey, SecretKey macKey, Map<String, String> description) {
        this.materials = new SymmetricRawMaterials(encryptionKey, macKey, description);
    }

    @Override
    public DecryptionMaterials getDecryptionMaterials(EncryptionContext context) {
        if (context.getMaterialDescription().entrySet().containsAll(this.materials.getMaterialDescription().entrySet())) {
            return this.materials;
        }
        return null;
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials(EncryptionContext context) {
        return this.materials;
    }

    @Override
    public void refresh() {
    }
}

