/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DHDomainParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 160;
    private final BigInteger g;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger j;
    private final int m;
    private final int l;
    private final DHValidationParameters validation;

    private static int getDefaultMParam(int n) {
        if (n == 0) {
            return 160;
        }
        return n < 160 ? n : 160;
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, null, bigInteger2, 0);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        this(bigInteger, null, bigInteger2, n);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
        this(bigInteger, bigInteger2, bigInteger3, DHDomainParameters.getDefaultMParam(n), n, null, null);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, int n2) {
        this(bigInteger, bigInteger2, bigInteger3, n, n2, null, null);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        this(bigInteger, bigInteger2, bigInteger3, 160, 0, bigInteger4, dHValidationParameters);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, DHValidationParameters dHValidationParameters) {
        this(bigInteger, bigInteger2, bigInteger3, DHDomainParameters.getDefaultMParam(n), n, null, dHValidationParameters);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, int n2, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        if (n2 != 0) {
            BigInteger bigInteger5 = BigInteger.valueOf(2L ^ (long)(n2 - 1));
            if (bigInteger5.compareTo(bigInteger) == 1) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (n2 < n) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        this.g = bigInteger3;
        this.p = bigInteger;
        this.q = bigInteger2;
        this.m = n;
        this.l = n2;
        this.j = bigInteger4;
        this.validation = dHValidationParameters;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public DHValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHDomainParameters)) {
            return false;
        }
        DHDomainParameters dHDomainParameters = (DHDomainParameters)object;
        return dHDomainParameters.getP().equals(this.p) && dHDomainParameters.getG().equals(this.g);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG().hashCode();
    }
}

