/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class IVAlgorithmParameterGenerator
extends BaseAlgorithmParameterGenerator {
    private final String algorithm;
    private final int ivLength;

    IVAlgorithmParameterGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, int n) {
        super(bouncyCastleFipsProvider, 0);
        this.algorithm = string;
        this.ivLength = n;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for " + this.algorithm + " parameter generation");
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters;
        byte[] byArray = new byte[this.ivLength];
        this.random.nextBytes(byArray);
        try {
            algorithmParameters = AlgorithmParameters.getInstance(this.algorithm, this.fipsProvider);
            algorithmParameters.init(new IvParameterSpec(byArray));
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.getMessage(), exception);
        }
        return algorithmParameters;
    }
}

