/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.TestTrigger;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AESNativeGCM
implements AEADBlockCipher {
    private GCMRefWrapper refWrapper;
    private int macSize = 0;
    private byte[] nonce;
    private byte[] lastKey;
    private byte[] initialAssociatedText;
    private boolean forEncryption = false;
    private boolean initialised = false;
    private byte[] keptMac = null;
    private static byte[] K = Hex.decode("feffe9928665731c6d6a8f9467308308");
    private static byte[] P = Hex.decode("d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39");
    private static byte[] A = Hex.decode("feedfacedeadbeeffeedfacedeadbeefabaddad2");
    private static byte[] IV = Hex.decode("cafebabefacedbaddecaf888");
    private static byte[] C = Hex.decode("42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091");
    private static byte[] T = Hex.decode("5bc94fbc3221a5db94fae95ae7121a47");
    private static TestTrigger trigger = new TestTrigger();

    private AESNativeGCM() {
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        BlockCipher blockCipher = (BlockCipher)FipsAES.ENGINE_PROVIDER.createEngine();
        if (this.lastKey != null) {
            blockCipher.init(true, new KeyParameterImpl(this.lastKey));
        }
        return blockCipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            KeyParameter keyParameter;
            this.forEncryption = bl;
            byte[] byArray = null;
            this.keptMac = null;
            if (cipherParameters instanceof AEADParameters) {
                AEADParameters aEADParameters = (AEADParameters)cipherParameters;
                byArray = aEADParameters.getNonce();
                this.initialAssociatedText = aEADParameters.getAssociatedText();
                int n = aEADParameters.getMacSize();
                if (n < 32 || n > 128 || n % 8 != 0) {
                    throw new IllegalArgumentException("invalid value for MAC size: " + n);
                }
                this.macSize = n;
                keyParameter = aEADParameters.getKey();
            } else if (cipherParameters instanceof ParametersWithIV) {
                ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                byArray = parametersWithIV.getIV();
                this.initialAssociatedText = null;
                this.macSize = 128;
                keyParameter = (KeyParameter)parametersWithIV.getParameters();
            } else {
                throw new IllegalArgumentException("invalid parameters passed to GCM");
            }
            if (byArray == null || byArray.length < 12) {
                throw new IllegalArgumentException("IV must be at least 12 bytes");
            }
            if (bl && this.nonce != null && Arrays.areEqual(this.nonce, byArray)) {
                if (keyParameter == null) {
                    throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                }
                if (this.lastKey != null && Arrays.areEqual(this.lastKey, keyParameter.getKey())) {
                    throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                }
            }
            this.nonce = byArray;
            if (keyParameter != null) {
                this.lastKey = keyParameter.getKey();
            }
            switch (this.lastKey.length) {
                case 16: 
                case 24: 
                case 32: {
                    break;
                }
                default: {
                    throw new IllegalStateException("key must be only 16,24,or 32 bytes long.");
                }
            }
            this.initRef(this.lastKey.length);
            AESNativeGCM.initNative(this.refWrapper.getReference(), bl, this.lastKey, this.nonce, this.initialAssociatedText, this.macSize);
            this.initialised = true;
        }
    }

    private void initRef(int n) {
        this.refWrapper = new GCMRefWrapper(AESNativeGCM.makeNative(n, this.forEncryption));
    }

    @Override
    public String getAlgorithmName() {
        return "AES/GCM";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAADByte(byte by) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            AESNativeGCM.processAADByte(this.refWrapper.getReference(), by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            AESNativeGCM.processAADBytes(this.refWrapper.getReference(), byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            return AESNativeGCM.processByte(this.refWrapper.getReference(), by, byArray, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM is uninitialized");
            }
            return AESNativeGCM.processBytes(this.refWrapper.getReference(), byArray, n, n2, byArray2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            this.checkStatus();
            int n2 = AESNativeGCM.doFinal(this.refWrapper.getReference(), byArray, n);
            this.resetKeepMac();
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getMac() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.keptMac != null) {
                return Arrays.clone(this.keptMac);
            }
            return AESNativeGCM.getMac(this.refWrapper.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateOutputSize(int n) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            return AESNativeGCM.getUpdateOutputSize(this.refWrapper.getReference(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutputSize(int n) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            return AESNativeGCM.getOutputSize(this.refWrapper.getReference(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                return;
            }
            this.reset(this.refWrapper.getReference());
            this.initialised = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKeepMac() {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            if (this.refWrapper == null) {
                return;
            }
            this.keptMac = this.getMac();
            this.reset(this.refWrapper.getReference());
        }
    }

    private void checkStatus() {
        if (!this.initialised) {
            if (this.forEncryption) {
                throw new IllegalStateException("GCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("GCM cipher needs to be initialised");
        }
    }

    private native void reset(long var1);

    static native void initNative(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5, int var6);

    static native long makeNative(int var0, boolean var1);

    static native void dispose(long var0);

    private static native void processAADByte(long var0, byte var2);

    private static native void processAADBytes(long var0, byte[] var2, int var3, int var4);

    private static native int processByte(long var0, byte var2, byte[] var3, int var4);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int doFinal(long var0, byte[] var2, int var3);

    private static native int getUpdateOutputSize(long var0, int var2);

    private static native int getOutputSize(long var0, int var2);

    public static native byte[] getMac(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBlocksRemainingDown(long l) {
        AESNativeGCM aESNativeGCM = this;
        synchronized (aESNativeGCM) {
            this.setBlocksRemainingDown(this.refWrapper.getReference(), l);
        }
    }

    private native void setBlocksRemainingDown(long var1, long var3);

    public String toString() {
        if (this.lastKey != null) {
            return "GCM[Native](AES[Native](" + this.lastKey.length * 8 + "))";
        }
        return "GCM[Native](AES[Native](not initialized))";
    }

    static AESNativeGCM newInstance() {
        AESNativeGCM aESNativeGCM = new AESNativeGCM();
        if (trigger.triggerTest()) {
            return SelfTestExecutor.validate(FipsAES.GCM.getAlgorithm(), aESNativeGCM, new BasicKatTest<AESNativeGCM>(){

                @Override
                public boolean hasTestPassed(AESNativeGCM aESNativeGCM) throws Exception {
                    AESNativeGCM aESNativeGCM2 = aESNativeGCM;
                    AEADParameters aEADParameters = new AEADParameters(new KeyParameterImpl(K), T.length * 8, IV, A);
                    aESNativeGCM2.init(true, aEADParameters);
                    byte[] byArray = new byte[aESNativeGCM2.getOutputSize(P.length)];
                    int n = aESNativeGCM2.processBytes(P, 0, P.length, byArray, 0);
                    n += aESNativeGCM2.doFinal(byArray, n);
                    if (byArray.length != n) {
                        return false;
                    }
                    byte[] byArray2 = aESNativeGCM2.getMac();
                    byte[] byArray3 = new byte[P.length];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
                    byte[] byArray4 = new byte[byArray.length - P.length];
                    System.arraycopy(byArray, P.length, byArray4, 0, byArray4.length);
                    if (!Arrays.areEqual(C, byArray3)) {
                        return false;
                    }
                    if (!Arrays.areEqual(T, byArray2)) {
                        return false;
                    }
                    if (!Arrays.areEqual(T, byArray4)) {
                        return false;
                    }
                    AESNativeGCM aESNativeGCM3 = aESNativeGCM;
                    aESNativeGCM3.init(false, aEADParameters);
                    byte[] byArray5 = new byte[aESNativeGCM3.getOutputSize(byArray.length)];
                    n = aESNativeGCM3.processBytes(byArray, 0, byArray.length, byArray5, 0);
                    aESNativeGCM3.doFinal(byArray5, n);
                    byArray2 = aESNativeGCM3.getMac();
                    byArray3 = new byte[C.length];
                    System.arraycopy(byArray5, 0, byArray3, 0, byArray3.length);
                    aESNativeGCM.refWrapper = null;
                    return Arrays.areEqual(P, byArray3) && Arrays.areEqual(T, byArray2);
                }
            });
        }
        return aESNativeGCM;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeGCM.dispose(l);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class GCMRefWrapper
    extends NativeReference {
        public GCMRefWrapper(long l) {
            super(l);
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }
}

