/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nativeprotocol;

import java.io.IOException;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.bytes.CompositeBytesReference;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.transport.BytesTransportRequest;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.TcpHeader;
import org.opensearch.transport.TransportStatus;
import org.opensearch.transport.nativeprotocol.CompressibleBytesOutputStream;
import org.opensearch.transport.nativeprotocol.NetworkMessage;

@ExperimentalApi
public abstract class NativeOutboundMessage
extends NetworkMessage {
    private final Writeable message;

    NativeOutboundMessage(ThreadContext threadContext, Version version, byte status, long requestId, Writeable message) {
        super(threadContext, version, status, requestId);
        this.message = message;
    }

    public BytesReference serialize(BytesStreamOutput bytesStream) throws IOException {
        BytesReference reference;
        bytesStream.setVersion(this.version);
        bytesStream.skip(TcpHeader.headerSize(this.version));
        int variableHeaderLength = -1;
        long preHeaderPosition = bytesStream.position();
        this.writeVariableHeader((StreamOutput)bytesStream);
        variableHeaderLength = Math.toIntExact(bytesStream.position() - preHeaderPosition);
        try (CompressibleBytesOutputStream stream = new CompressibleBytesOutputStream(bytesStream, TransportStatus.isCompress(this.status));){
            stream.setVersion(this.version);
            stream.setFeatures(bytesStream.getFeatures());
            if (variableHeaderLength == -1) {
                this.writeVariableHeader(stream);
            }
            reference = this.writeMessage(stream);
        }
        bytesStream.seek(0L);
        int contentSize = reference.length() - TcpHeader.headerSize(this.version);
        TcpHeader.writeHeader((StreamOutput)bytesStream, this.requestId, this.status, this.version, contentSize, variableHeaderLength);
        return reference;
    }

    protected void writeVariableHeader(StreamOutput stream) throws IOException {
        this.threadContext.writeTo(stream);
    }

    protected BytesReference writeMessage(CompressibleBytesOutputStream stream) throws IOException {
        BytesReference zeroCopyBuffer;
        Writeable writeable = this.message;
        if (writeable instanceof BytesTransportRequest) {
            BytesTransportRequest bytesTransportRequest = (BytesTransportRequest)writeable;
            bytesTransportRequest.writeThin(stream);
            zeroCopyBuffer = bytesTransportRequest.bytes();
        } else {
            writeable = this.message;
            if (writeable instanceof RemoteTransportException) {
                RemoteTransportException remoteTransportException = (RemoteTransportException)writeable;
                stream.writeException((Throwable)((Object)remoteTransportException));
                zeroCopyBuffer = BytesArray.EMPTY;
            } else {
                this.message.writeTo((StreamOutput)stream);
                zeroCopyBuffer = BytesArray.EMPTY;
            }
        }
        BytesReference message = stream.materializeBytes();
        if (zeroCopyBuffer.length() == 0) {
            return message;
        }
        return CompositeBytesReference.of((BytesReference[])new BytesReference[]{message, zeroCopyBuffer});
    }

    private static boolean canCompress(Writeable message) {
        return !(message instanceof BytesTransportRequest);
    }

    public static class Response
    extends NativeOutboundMessage {
        private final Set<String> features;

        public Response(ThreadContext threadContext, Set<String> features, Writeable message, Version version, long requestId, boolean isHandshake, boolean compress) {
            super(threadContext, version, Response.setStatus(compress, isHandshake, message), requestId, message);
            this.features = features;
        }

        @Override
        protected void writeVariableHeader(StreamOutput stream) throws IOException {
            super.writeVariableHeader(stream);
            stream.setFeatures(this.features);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setResponse(status);
            if (message instanceof RemoteTransportException) {
                status = TransportStatus.setError(status);
            }
            if (compress) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }

    static class Request
    extends NativeOutboundMessage {
        private final String[] features;
        private final String action;

        Request(ThreadContext threadContext, String[] features, Writeable message, Version version, String action, long requestId, boolean isHandshake, boolean compress) {
            super(threadContext, version, Request.setStatus(compress, isHandshake, message), requestId, message);
            this.features = features;
            this.action = action;
        }

        @Override
        protected void writeVariableHeader(StreamOutput stream) throws IOException {
            super.writeVariableHeader(stream);
            stream.writeStringArray(this.features);
            stream.writeString(this.action);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setRequest(status);
            if (compress && NativeOutboundMessage.canCompress(message)) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }
}

