/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.MergingDigest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class TDigestState
extends MergingDigest {
    private final double compression;

    public TDigestState(double compression) {
        super(compression);
        this.compression = compression;
    }

    private TDigestState(double compression, MergingDigest in) {
        super(compression);
        this.compression = compression;
        this.add(List.of(in));
    }

    public double compression() {
        return this.compression;
    }

    public static void write(TDigestState state, StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_3_4_0)) {
            out.writeDouble(state.compression);
            out.writeVInt(state.centroidCount());
            for (Centroid centroid : state.centroids()) {
                out.writeDouble(centroid.mean());
                out.writeVLong((long)centroid.count());
            }
        } else {
            int byteSize = state.byteSize();
            out.writeVInt(byteSize);
            ByteBuffer buf = ByteBuffer.allocate(byteSize);
            state.asBytes(buf);
            out.writeBytes(buf.array());
        }
    }

    public static TDigestState read(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_3_4_0)) {
            double compression = in.readDouble();
            int n = in.readVInt();
            if (n <= 0) {
                return new TDigestState(compression);
            }
            AVLTreeDigest treeDigest = new AVLTreeDigest(compression);
            for (int i = 0; i < n; ++i) {
                treeDigest.add(in.readDouble(), in.readVInt());
            }
            TDigestState state = new TDigestState(compression);
            state.add(List.of(treeDigest));
            return state;
        }
        int byteSize = in.readVInt();
        byte[] bytes = new byte[byteSize];
        in.readBytes(bytes, 0, byteSize);
        MergingDigest mergingDigest = MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(bytes));
        if (mergingDigest.centroids().isEmpty()) {
            return new TDigestState(mergingDigest.compression());
        }
        return new TDigestState(mergingDigest.compression(), mergingDigest);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TDigestState)) {
            return false;
        }
        TDigestState that = (TDigestState)((Object)obj);
        if (this.compression != that.compression) {
            return false;
        }
        Iterator thisCentroids = this.centroids().iterator();
        Iterator thatCentroids = that.centroids().iterator();
        while (thisCentroids.hasNext()) {
            if (!thatCentroids.hasNext()) {
                return false;
            }
            Centroid thisNext = (Centroid)thisCentroids.next();
            Centroid thatNext = (Centroid)thatCentroids.next();
            if (thisNext.mean() == thatNext.mean() && thisNext.count() == thatNext.count()) continue;
            return false;
        }
        return !thatCentroids.hasNext();
    }

    public int hashCode() {
        int h = ((Object)((Object)this)).getClass().hashCode();
        h = 31 * h + Double.hashCode(this.compression);
        for (Centroid centroid : this.centroids()) {
            h = 31 * h + Double.hashCode(centroid.mean());
            h = 31 * h + centroid.count();
        }
        return h;
    }
}

