/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent;

import org.opensearch.common.Nullable;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.persistent.AllocatedPersistentTask;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.threadpool.ThreadPool;

public class NodePersistentTasksExecutor {
    private final ThreadPool threadPool;

    NodePersistentTasksExecutor(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void executeTask(final Params params, final @Nullable PersistentTaskState state, final AllocatedPersistentTask task, final PersistentTasksExecutor<Params> executor) {
        this.threadPool.executor(executor.getExecutor()).execute(new AbstractRunnable(this){

            @Override
            public void onFailure(Exception e) {
                task.markAsFailed(e);
            }

            @Override
            protected void doRun() throws Exception {
                try {
                    executor.nodeOperation(task, params, state);
                }
                catch (Exception ex) {
                    task.markAsFailed(ex);
                }
            }
        });
    }
}

