/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.ScrollableHitSource;

class BulkByScrollResponseBuilder
extends BulkByScrollTask.StatusBuilder {
    private TimeValue took;
    private BulkByScrollTask.Status status;
    private List<BulkItemResponse.Failure> bulkFailures = new ArrayList<BulkItemResponse.Failure>();
    private List<ScrollableHitSource.SearchFailure> searchFailures = new ArrayList<ScrollableHitSource.SearchFailure>();
    private boolean timedOut;

    BulkByScrollResponseBuilder() {
    }

    public void setTook(long took) {
        this.setTook(new TimeValue(took, TimeUnit.MILLISECONDS));
    }

    public void setTook(TimeValue took) {
        this.took = took;
    }

    public void setStatus(BulkByScrollTask.Status status) {
        this.status = status;
    }

    public void setFailures(List<Object> failures) {
        if (failures != null) {
            for (Object object : failures) {
                if (object instanceof BulkItemResponse.Failure) {
                    BulkItemResponse.Failure failure = (BulkItemResponse.Failure)object;
                    this.bulkFailures.add(failure);
                    continue;
                }
                if (!(object instanceof ScrollableHitSource.SearchFailure)) continue;
                ScrollableHitSource.SearchFailure searchFailure = (ScrollableHitSource.SearchFailure)object;
                this.searchFailures.add(searchFailure);
            }
        }
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public BulkByScrollResponse buildResponse() {
        this.status = super.buildStatus();
        return new BulkByScrollResponse(this.took, this.status, this.bulkFailures, this.searchFailures, this.timedOut);
    }
}

