/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.action.ActionType;
import org.opensearch.action.OriginalIndices;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.OptionallyResolvedIndices;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.index.Index;
import org.opensearch.transport.RemoteClusterService;

@ExperimentalApi
public class ResolvedIndices
extends OptionallyResolvedIndices {
    private final Local local;
    private final Remote remote;

    public static ResolvedIndices of(String ... indicesAliasesAndDataStreams) {
        return new ResolvedIndices(new Local(Set.of(indicesAliasesAndDataStreams), null, Map.of()), Remote.EMPTY);
    }

    public static ResolvedIndices of(Index ... indices) {
        return new ResolvedIndices(new Local.Concrete(Set.of(indices), Stream.of(indices).map(Index::getName).collect(Collectors.toUnmodifiableSet()), null, Map.of(), List.of()), Remote.EMPTY);
    }

    public static ResolvedIndices of(Collection<String> indicesAliasesAndDataStreams) {
        return new ResolvedIndices(new Local(Set.copyOf(indicesAliasesAndDataStreams), null, Map.of()), Remote.EMPTY);
    }

    public static ResolvedIndices of(Local local) {
        return new ResolvedIndices(local, Remote.EMPTY);
    }

    public static OptionallyResolvedIndices unknown() {
        return OptionallyResolvedIndices.unknown();
    }

    public static ResolvedIndices ofNonNull(String ... indicesAliasesAndDataStreams) {
        HashSet<String> indexSet = new HashSet<String>(indicesAliasesAndDataStreams.length);
        for (String index : indicesAliasesAndDataStreams) {
            if (index == null) continue;
            indexSet.add(index);
        }
        return new ResolvedIndices(new Local(Collections.unmodifiableSet(indexSet), null, Map.of()), Remote.EMPTY);
    }

    private ResolvedIndices(Local local, Remote remote) {
        this.local = local;
        this.remote = remote;
    }

    @Override
    public Local local() {
        return this.local;
    }

    public Remote remote() {
        return this.remote;
    }

    public ResolvedIndices withRemoteIndices(Map<String, OriginalIndices> remoteIndices) {
        if (remoteIndices.isEmpty()) {
            return this;
        }
        HashMap<String, OriginalIndices> newRemoteIndices = new HashMap<String, OriginalIndices>(remoteIndices);
        newRemoteIndices.putAll(this.remote.clusterToOriginalIndicesMap);
        return new ResolvedIndices(this.local, new Remote(Collections.unmodifiableMap(newRemoteIndices)));
    }

    public ResolvedIndices withLocalOriginalIndices(OriginalIndices originalIndices) {
        return new ResolvedIndices(this.local.withOriginalIndices(originalIndices), this.remote);
    }

    public ResolvedIndices withLocalSubActions(ActionType<?> actionType, Local local) {
        return new ResolvedIndices(this.local.withSubActions(actionType, local), this.remote);
    }

    public ResolvedIndices withLocalSubActions(String actionType, Local local) {
        return new ResolvedIndices(this.local.withSubActions(actionType, local), this.remote);
    }

    public boolean isEmpty() {
        return this.local.isEmpty() && this.remote.isEmpty();
    }

    @Override
    public String toString() {
        return "ResolvedIndices{local=" + String.valueOf(this.local) + ", remote=" + String.valueOf(this.remote) + "}";
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ResolvedIndices)) {
            return false;
        }
        ResolvedIndices otherResolvedIndices = (ResolvedIndices)other;
        return this.local.equals(otherResolvedIndices.local) && this.remote.equals(otherResolvedIndices.remote);
    }

    @Override
    public int hashCode() {
        return this.local.hashCode() + this.remote.hashCode() * 31;
    }

    @ExperimentalApi
    public static class Local
    extends OptionallyResolvedIndices.Local {
        protected final Set<String> names;
        protected final OriginalIndices originalIndices;
        protected final Map<String, Local> subActions;
        private Set<String> namesOfIndices;

        public static Local of(Collection<String> indicesAliasesAndDataStreams) {
            return new Local(Set.copyOf(indicesAliasesAndDataStreams), null, Map.of());
        }

        public static Local of(String ... indicesAliasesAndDataStreams) {
            return Local.of(Arrays.asList(indicesAliasesAndDataStreams));
        }

        private Local(Set<String> names, OriginalIndices originalIndices, Map<String, Local> subActions) {
            this.names = names;
            this.originalIndices = originalIndices;
            this.subActions = subActions;
        }

        public Set<String> names() {
            return this.names;
        }

        public String[] namesAsArray() {
            return this.names().toArray(new String[0]);
        }

        @Override
        public Set<String> names(ClusterState clusterState) {
            return this.names;
        }

        public Set<String> namesOfIndices(ClusterState clusterState) {
            Set<String> result = this.namesOfIndices;
            if (result == null) {
                SortedMap<String, IndexAbstraction> indicesLookup = clusterState.metadata().getIndicesLookup();
                result = new HashSet<String>(this.names.size());
                for (String name : this.names) {
                    IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(name);
                    if (indexAbstraction == null) {
                        result.add(name);
                        continue;
                    }
                    if (indexAbstraction instanceof IndexAbstraction.Index) {
                        result.add(name);
                        continue;
                    }
                    for (IndexMetadata index : indexAbstraction.getIndices()) {
                        result.add(index.getIndex().getName());
                    }
                }
                this.namesOfIndices = result = Collections.unmodifiableSet(result);
            }
            return result;
        }

        public OriginalIndices originalIndices() {
            return this.originalIndices;
        }

        public Map<String, Local> subActions() {
            return this.subActions;
        }

        @Override
        public boolean isEmpty() {
            return this.names.isEmpty();
        }

        @Override
        public boolean contains(String name) {
            return this.names.contains(name);
        }

        @Override
        public boolean containsAny(Collection<String> names) {
            return names.stream().anyMatch(this.names::contains);
        }

        @Override
        public boolean containsAny(Predicate<String> namePredicate) {
            return this.names.stream().anyMatch(namePredicate);
        }

        public Local withOriginalIndices(OriginalIndices originalIndices) {
            return new Local(this.names, originalIndices, this.subActions);
        }

        public Local withSubActions(String key, Local local) {
            HashMap<String, Local> subActions = new HashMap<String, Local>(this.subActions);
            subActions.put(key, local);
            return new Local(this.names, this.originalIndices, Collections.unmodifiableMap(subActions));
        }

        public Local withSubActions(ActionType<?> actionType, Local local) {
            return this.withSubActions(actionType.name(), local);
        }

        public String toString() {
            if (this.subActions.isEmpty()) {
                return "{names=" + String.valueOf(this.names()) + "}";
            }
            return "{names=" + String.valueOf(this.names()) + ", subActions=" + String.valueOf(this.subActions) + "}";
        }

        public boolean equals(Object other) {
            if (!(other instanceof Local)) {
                return false;
            }
            Local otherLocal = (Local)other;
            return this.names.equals(otherLocal.names) && this.subActions.equals(otherLocal.subActions);
        }

        public int hashCode() {
            return this.names.hashCode() + this.subActions.hashCode() * 31;
        }

        @ExperimentalApi
        public static class Concrete
        extends Local {
            private static final Concrete EMPTY = new Concrete(Set.of(), Set.of(), null, Map.of(), List.of());
            private final Set<Index> concreteIndices;
            private final List<RuntimeException> resolutionErrors;

            public static Concrete empty() {
                return EMPTY;
            }

            public static Concrete of(Index ... concreteIndices) {
                return new Concrete(Set.of(concreteIndices), Stream.of(concreteIndices).map(Index::getName).collect(Collectors.toSet()), null, Map.of(), List.of());
            }

            static Concrete of(Set<Index> concreteIndices, Set<String> names) {
                return new Concrete(Set.copyOf(concreteIndices), Set.copyOf(names), null, Map.of(), List.of());
            }

            private Concrete(Set<Index> concreteIndices, Set<String> names, OriginalIndices originalIndices, Map<String, Local> subActions, List<RuntimeException> resolutionErrors) {
                super(names, originalIndices, subActions);
                this.concreteIndices = concreteIndices;
                this.resolutionErrors = resolutionErrors;
            }

            public Set<Index> concreteIndices() {
                this.checkResolutionErrors();
                return this.concreteIndices;
            }

            public Index[] concreteIndicesAsArray() {
                return this.concreteIndices().toArray(Index.EMPTY_ARRAY);
            }

            public Set<String> namesOfConcreteIndices() {
                return this.concreteIndices().stream().map(Index::getName).collect(Collectors.toSet());
            }

            public String[] namesOfConcreteIndicesAsArray() {
                return (String[])this.concreteIndices().stream().map(Index::getName).toArray(String[]::new);
            }

            @Override
            public Concrete withOriginalIndices(OriginalIndices originalIndices) {
                return new Concrete(this.concreteIndices, this.names, originalIndices, this.subActions, this.resolutionErrors);
            }

            @Override
            public Local withSubActions(String actionType, Local local) {
                HashMap<String, Local> subActions = new HashMap<String, Local>(this.subActions);
                subActions.put(actionType, local);
                return new Concrete(this.concreteIndices, this.names, this.originalIndices, subActions, this.resolutionErrors);
            }

            public Concrete withResolutionErrors(List<RuntimeException> resolutionErrors) {
                if (resolutionErrors.isEmpty()) {
                    return this;
                }
                return new Concrete(this.concreteIndices, this.names(), this.originalIndices, this.subActions, Stream.concat(this.resolutionErrors.stream(), resolutionErrors.stream()).toList());
            }

            public Concrete withResolutionErrors(RuntimeException ... resolutionErrors) {
                return this.withResolutionErrors(Arrays.asList(resolutionErrors));
            }

            public Concrete withoutResolutionErrors() {
                return new Concrete(this.concreteIndices, this.names(), this.originalIndices, this.subActions, List.of());
            }

            @Override
            public boolean equals(Object other) {
                if (!super.equals(other)) {
                    return false;
                }
                if (!(other instanceof Concrete)) {
                    return false;
                }
                Concrete otherLocal = (Concrete)other;
                return this.concreteIndices.equals(otherLocal.concreteIndices);
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.concreteIndices.hashCode();
            }

            List<RuntimeException> resolutionErrors() {
                return this.resolutionErrors;
            }

            private void checkResolutionErrors() {
                if (!this.resolutionErrors.isEmpty()) {
                    throw this.resolutionErrors.getFirst();
                }
            }

            @Override
            public String toString() {
                return "{concreteIndices=" + String.valueOf(this.concreteIndices) + ", names=" + String.valueOf(this.names()) + ", resolutionErrors=" + String.valueOf(this.resolutionErrors) + "}";
            }
        }
    }

    @ExperimentalApi
    public static class Remote {
        static final Remote EMPTY = new Remote(Collections.emptyMap(), Collections.emptyList());
        private final Map<String, OriginalIndices> clusterToOriginalIndicesMap;
        private List<String> rawExpressions;

        private Remote(Map<String, OriginalIndices> clusterToOriginalIndicesMap) {
            this.clusterToOriginalIndicesMap = clusterToOriginalIndicesMap;
        }

        private Remote(Map<String, OriginalIndices> clusterToOriginalIndicesMap, List<String> rawExpressions) {
            this.clusterToOriginalIndicesMap = clusterToOriginalIndicesMap;
            this.rawExpressions = rawExpressions;
        }

        public Map<String, OriginalIndices> asClusterToOriginalIndicesMap() {
            return this.clusterToOriginalIndicesMap;
        }

        public List<String> asRawExpressions() {
            List<String> result = this.rawExpressions;
            if (result == null) {
                result = this.rawExpressions = this.buildRawExpressions();
            }
            return result;
        }

        public String[] asRawExpressionsArray() {
            return this.asRawExpressions().toArray(new String[0]);
        }

        public boolean isEmpty() {
            return this.clusterToOriginalIndicesMap.isEmpty();
        }

        public String toString() {
            return this.asRawExpressions().toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Remote)) {
                return false;
            }
            Remote otherRemote = (Remote)other;
            return this.asRawExpressions().equals(otherRemote.asRawExpressions());
        }

        public int hashCode() {
            return this.asRawExpressions().hashCode();
        }

        private List<String> buildRawExpressions() {
            ArrayList<String> result = new ArrayList<String>(this.clusterToOriginalIndicesMap.size());
            for (Map.Entry<String, OriginalIndices> entry : this.clusterToOriginalIndicesMap.entrySet()) {
                for (String remoteIndex : entry.getValue().indices()) {
                    result.add(RemoteClusterService.buildRemoteIndexName(entry.getKey(), remoteIndex));
                }
            }
            return Collections.unmodifiableList(result);
        }
    }
}

