/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.stats;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.engine.CommitStats;
import org.opensearch.index.seqno.RetentionLeaseStats;
import org.opensearch.index.seqno.SeqNoStats;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.indices.pollingingest.PollingIngestStats;

@PublicApi(since="1.0.0")
public class ShardStats
implements Writeable,
ToXContentFragment {
    private ShardRouting shardRouting;
    private CommonStats commonStats;
    @Nullable
    private CommitStats commitStats;
    @Nullable
    private SeqNoStats seqNoStats;
    @Nullable
    private RetentionLeaseStats retentionLeaseStats;
    @Nullable
    private PollingIngestStats pollingIngestStats;
    private String dataPath;
    private String statePath;
    private boolean isCustomDataPath;

    public RetentionLeaseStats getRetentionLeaseStats() {
        return this.retentionLeaseStats;
    }

    private ShardStats(Builder builder) {
        this.shardRouting = builder.shardRouting;
        this.dataPath = builder.shardPath.getRootDataPath().toString();
        this.statePath = builder.shardPath.getRootStatePath().toString();
        this.isCustomDataPath = builder.shardPath.isCustomDataPath();
        this.commitStats = builder.commitStats;
        this.commonStats = builder.commonStats;
        this.seqNoStats = builder.seqNoStats;
        this.retentionLeaseStats = builder.retentionLeaseStats;
        this.pollingIngestStats = builder.pollingIngestStats;
    }

    public ShardStats(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.commonStats = new CommonStats(in);
        this.commitStats = CommitStats.readOptionalCommitStatsFrom(in);
        this.statePath = in.readString();
        this.dataPath = in.readString();
        this.isCustomDataPath = in.readBoolean();
        this.seqNoStats = (SeqNoStats)in.readOptionalWriteable(SeqNoStats::new);
        this.retentionLeaseStats = (RetentionLeaseStats)in.readOptionalWriteable(RetentionLeaseStats::new);
        if (in.getVersion().onOrAfter(Version.V_3_0_0)) {
            this.pollingIngestStats = (PollingIngestStats)in.readOptionalWriteable(PollingIngestStats::new);
        }
    }

    @Deprecated
    public ShardStats(ShardRouting routing, ShardPath shardPath, CommonStats commonStats, CommitStats commitStats, SeqNoStats seqNoStats, RetentionLeaseStats retentionLeaseStats, PollingIngestStats pollingIngestStats) {
        this.shardRouting = routing;
        this.dataPath = shardPath.getRootDataPath().toString();
        this.statePath = shardPath.getRootStatePath().toString();
        this.isCustomDataPath = shardPath.isCustomDataPath();
        this.commitStats = commitStats;
        this.commonStats = commonStats;
        this.seqNoStats = seqNoStats;
        this.retentionLeaseStats = retentionLeaseStats;
        this.pollingIngestStats = pollingIngestStats;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public CommonStats getStats() {
        return this.commonStats;
    }

    @Nullable
    public CommitStats getCommitStats() {
        return this.commitStats;
    }

    @Nullable
    public SeqNoStats getSeqNoStats() {
        return this.seqNoStats;
    }

    @Nullable
    public PollingIngestStats getPollingIngestStats() {
        return this.pollingIngestStats;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getStatePath() {
        return this.statePath;
    }

    public boolean isCustomDataPath() {
        return this.isCustomDataPath;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        this.commonStats.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.commitStats);
        out.writeString(this.statePath);
        out.writeString(this.dataPath);
        out.writeBoolean(this.isCustomDataPath);
        out.writeOptionalWriteable((Writeable)this.seqNoStats);
        out.writeOptionalWriteable((Writeable)this.retentionLeaseStats);
        if (out.getVersion().onOrAfter(Version.V_3_0_0)) {
            out.writeOptionalWriteable((Writeable)this.pollingIngestStats);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("routing").field("state", (Object)this.shardRouting.state()).field("primary", this.shardRouting.primary()).field("node", this.shardRouting.currentNodeId()).field("relocating_node", this.shardRouting.relocatingNodeId()).endObject();
        this.commonStats.toXContent(builder, params);
        if (this.commitStats != null) {
            this.commitStats.toXContent(builder, params);
        }
        if (this.seqNoStats != null) {
            this.seqNoStats.toXContent(builder, params);
        }
        if (this.retentionLeaseStats != null) {
            this.retentionLeaseStats.toXContent(builder, params);
        }
        if (this.pollingIngestStats != null) {
            this.pollingIngestStats.toXContent(builder, params);
        }
        builder.startObject("shard_path");
        builder.field("state_path", this.statePath);
        builder.field("data_path", this.dataPath);
        builder.field("is_custom_data_path", this.isCustomDataPath);
        builder.endObject();
        return builder;
    }

    public static class Builder {
        private ShardRouting shardRouting = null;
        private ShardPath shardPath = null;
        private CommonStats commonStats = null;
        private CommitStats commitStats = null;
        private SeqNoStats seqNoStats = null;
        private RetentionLeaseStats retentionLeaseStats = null;
        private PollingIngestStats pollingIngestStats = null;

        public Builder shardRouting(ShardRouting shardRouting) {
            this.shardRouting = shardRouting;
            return this;
        }

        public Builder shardPath(ShardPath shardPath) {
            this.shardPath = shardPath;
            return this;
        }

        public Builder commonStats(CommonStats commonStats) {
            this.commonStats = commonStats;
            return this;
        }

        public Builder commitStats(CommitStats commitStats) {
            this.commitStats = commitStats;
            return this;
        }

        public Builder seqNoStats(SeqNoStats seqNoStats) {
            this.seqNoStats = seqNoStats;
            return this;
        }

        public Builder retentionLeaseStats(RetentionLeaseStats retentionLeaseStats) {
            this.retentionLeaseStats = retentionLeaseStats;
            return this;
        }

        public Builder pollingIngestStats(PollingIngestStats pollingIngestStats) {
            this.pollingIngestStats = pollingIngestStats;
            return this;
        }

        public ShardStats build() {
            return new ShardStats(this);
        }
    }

    static final class Fields {
        static final String ROUTING = "routing";
        static final String STATE = "state";
        static final String STATE_PATH = "state_path";
        static final String DATA_PATH = "data_path";
        static final String IS_CUSTOM_DATA_PATH = "is_custom_data_path";
        static final String SHARD_PATH = "shard_path";
        static final String PRIMARY = "primary";
        static final String NODE = "node";
        static final String RELOCATING_NODE = "relocating_node";

        Fields() {
        }
    }
}

