/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.jni;

import java.security.AccessController;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.jni.PlatformUtils;

public class SimdVectorComputeService {
    public static native void scoreSimilarityInBulk(int[] var0, float[] var1, int var2);

    public static native void saveSearchContext(float[] var0, long[] var1, int var2);

    public static native float scoreSimilarity(int var0);

    static {
        AccessController.doPrivileged(() -> {
            if (!KNNSettings.isFaissAVX512SPRDisabled() && PlatformUtils.isAVX512SPRSupportedBySystem()) {
                System.loadLibrary("opensearchknn_simd_avx512_spr");
            } else if (!KNNSettings.isFaissAVX512Disabled() && PlatformUtils.isAVX512SupportedBySystem()) {
                System.loadLibrary("opensearchknn_simd_avx512");
            } else if (!KNNSettings.isFaissAVX2Disabled() && PlatformUtils.isAVX2SupportedBySystem()) {
                System.loadLibrary("opensearchknn_simd_avx2");
            } else {
                System.loadLibrary("opensearchknn_simd");
            }
            return null;
        });
    }

    public static enum SimilarityFunctionType {
        FP16_MAXIMUM_INNER_PRODUCT,
        FP16_L2;

    }
}

