/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.memory;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.memory.SharedIndexState;
import org.opensearch.knn.jni.JNIService;

class SharedIndexStateManager {
    @Generated
    private static final Logger log = LogManager.getLogger(SharedIndexStateManager.class);
    private final ConcurrentHashMap<String, SharedIndexStateEntry> sharedIndexStateCache = new ConcurrentHashMap();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static SharedIndexStateManager INSTANCE;

    public static synchronized SharedIndexStateManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SharedIndexStateManager();
        }
        return INSTANCE;
    }

    @VisibleForTesting
    SharedIndexStateManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedIndexState get(long indexAddress, String modelId, KNNEngine knnEngine) {
        this.readWriteLock.readLock().lock();
        try {
            SharedIndexStateEntry entry = this.sharedIndexStateCache.computeIfAbsent(modelId, m -> {
                log.info("Loading entry to shared index state cache for model {}", (Object)modelId);
                long sharedIndexStateAddress = JNIService.initSharedIndexState(indexAddress, knnEngine);
                return new SharedIndexStateEntry(new SharedIndexState(sharedIndexStateAddress, modelId, knnEngine));
            });
            entry.incRef();
            SharedIndexState sharedIndexState = entry.getSharedIndexState();
            return sharedIndexState;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void release(SharedIndexState sharedIndexState) {
        this.readWriteLock.writeLock().lock();
        try {
            SharedIndexStateEntry sharedIndexStateEntry = this.sharedIndexStateCache.get(sharedIndexState.getModelId());
            if (sharedIndexStateEntry == null) {
                log.error("Attempting to evict model from cache but it is not present: {}", (Object)sharedIndexState.getModelId());
                return;
            }
            if (sharedIndexStateEntry.decRef() <= 0L) {
                log.info("Evicting entry from shared index state cache for key {}", (Object)sharedIndexState.getModelId());
                this.sharedIndexStateCache.remove(sharedIndexState.getModelId());
                JNIService.freeSharedIndexState(sharedIndexState.getSharedIndexStateAddress(), sharedIndexState.getKnnEngine());
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private static final class SharedIndexStateEntry {
        private final SharedIndexState sharedIndexState;
        private final AtomicLong referenceCount;

        private SharedIndexStateEntry(SharedIndexState sharedIndexState) {
            this.sharedIndexState = sharedIndexState;
            this.referenceCount = new AtomicLong(0L);
        }

        private long incRef() {
            return this.referenceCount.incrementAndGet();
        }

        private long decRef() {
            return this.referenceCount.decrementAndGet();
        }

        @Generated
        public SharedIndexState getSharedIndexState() {
            return this.sharedIndexState;
        }
    }
}

