/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.IntProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.MutableFeatureMap;
import org.tribuo.Output;
import org.tribuo.VariableInfo;
import org.tribuo.impl.ArrayExample;
import org.tribuo.impl.BinaryFeaturesExample;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.sequence.ImmutableSequenceDataset;
import org.tribuo.sequence.SequenceDataset;
import org.tribuo.sequence.SequenceExample;

public class MinimumCardinalitySequenceDataset<T extends Output<T>>
extends ImmutableSequenceDataset<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MinimumCardinalitySequenceDataset.class.getName());
    private final int minCardinality;
    private int numExamplesRemoved = 0;
    private final Set<String> removedFeatureNames = new HashSet<String>();

    public MinimumCardinalitySequenceDataset(SequenceDataset<T> sequenceDataset, int minCardinality) {
        super((DataProvenance)sequenceDataset.getProvenance(), sequenceDataset.getOutputFactory());
        this.minCardinality = minCardinality;
        MutableFeatureMap featureInfos = new MutableFeatureMap();
        ArrayList<Feature> features = new ArrayList<Feature>();
        FeatureMap featureMap = sequenceDataset.getFeatureMap();
        for (SequenceExample<T> sequenceExample : sequenceDataset) {
            boolean add = true;
            ArrayList newExamples = new ArrayList(sequenceExample.size());
            for (Example<T> example : sequenceExample) {
                features.clear();
                Example newExample = example instanceof BinaryFeaturesExample ? new BinaryFeaturesExample<T>(example.getOutput()) : new ArrayExample<T>(example.getOutput());
                newExample.setWeight(example.getWeight());
                for (Feature feature : example) {
                    VariableInfo featureInfo = featureMap.get(feature.getName());
                    if (featureInfo == null || featureInfo.getCount() < minCardinality) {
                        this.removedFeatureNames.add(feature.getName());
                        continue;
                    }
                    features.add(feature);
                }
                newExample.addAll(features);
                if (newExample.size() > 0) {
                    if (!newExample.validateExample()) {
                        throw new IllegalStateException("Duplicate features found in example " + newExample.toString());
                    }
                    newExamples.add(newExample);
                    continue;
                }
                ++this.numExamplesRemoved;
                add = false;
                break;
            }
            if (!add) continue;
            SequenceExample newSequenceExample = new SequenceExample(newExamples);
            this.data.add(newSequenceExample);
        }
        for (VariableInfo info : featureMap) {
            if (info.getCount() < minCardinality) continue;
            featureInfos.put(info.copy());
        }
        this.outputIDInfo = sequenceDataset.getOutputIDInfo();
        this.featureIDMap = new ImmutableFeatureMap(featureInfos);
        if (this.numExamplesRemoved > 0) {
            logger.info(String.format("filtered out %d sequence examples because (at least) one of its examples had zero features after the minimum frequency count was applied.", this.numExamplesRemoved));
        }
    }

    public Set<String> getRemoved() {
        return this.removedFeatureNames;
    }

    public int getNumExamplesRemoved() {
        return this.numExamplesRemoved;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    @Override
    public DatasetProvenance getProvenance() {
        return new MinimumCardinalitySequenceDatasetProvenance(this);
    }

    public static class MinimumCardinalitySequenceDatasetProvenance
    extends DatasetProvenance {
        private static final long serialVersionUID = 1L;
        private static final String MIN_CARDINALITY = "min-cardinality";
        private final IntProvenance minCardinality;

        <T extends Output<T>> MinimumCardinalitySequenceDatasetProvenance(MinimumCardinalitySequenceDataset<T> dataset) {
            super(dataset.sourceProvenance, (ListProvenance<ObjectProvenance>)new ListProvenance(), dataset);
            this.minCardinality = new IntProvenance(MIN_CARDINALITY, ((MinimumCardinalitySequenceDataset)dataset).minCardinality);
        }

        public MinimumCardinalitySequenceDatasetProvenance(Map<String, Provenance> map) {
            super(map);
            this.minCardinality = (IntProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)MIN_CARDINALITY, IntProvenance.class, (String)MinimumCardinalitySequenceDatasetProvenance.class.getSimpleName());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MinimumCardinalitySequenceDatasetProvenance)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MinimumCardinalitySequenceDatasetProvenance pairs = (MinimumCardinalitySequenceDatasetProvenance)o;
            return this.minCardinality.equals((Object)pairs.minCardinality);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.minCardinality);
        }

        @Override
        protected List<Pair<String, Provenance>> allProvenances() {
            List<Pair<String, Provenance>> provenances = super.allProvenances();
            provenances.add((Pair<String, Provenance>)new Pair((Object)MIN_CARDINALITY, (Object)this.minCardinality));
            return provenances;
        }
    }
}

