/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.opensearch.tools.cli.fips.truststore.CommonOptions;
import org.opensearch.tools.cli.fips.truststore.ConfigurationService;
import org.opensearch.tools.cli.fips.truststore.TrustStoreService;
import org.opensearch.tools.cli.fips.truststore.UserInteractionService;
import picocli.CommandLine;

@CommandLine.Command(name="generated", description={"Generate a new BCFKS trust store from JVM default trust store"}, mixinStandardHelpOptions=true)
public class GeneratedTrustStoreCommand
implements Callable<Integer> {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    protected CommonOptions common;

    @Override
    public final Integer call() throws Exception {
        Path confPath = Path.of(System.getProperty("opensearch.path.conf"), new String[0]);
        ConfigurationService.verifyJvmOptionsFile(this.spec, this.common, confPath);
        return new TrustStoreService(UserInteractionService.getInstance()).generateTrustStore(this.spec, this.common, confPath);
    }
}

