/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.opensearch.tools.cli.fips.truststore.CommonOptions;
import org.opensearch.tools.cli.fips.truststore.ConfigurationProperties;
import picocli.CommandLine;

public class ConfigurationService {
    public static void verifyJvmOptionsFile(CommandLine.Model.CommandSpec spec, CommonOptions options, Path confPath) {
        Path jvmOptionsFile = confPath.resolve("jvm.options");
        if (options.force) {
            CommandLine.Help.Ansi ansi = spec.commandLine().getColorScheme().ansi();
            spec.commandLine().getOut().println(ansi.string("@|yellow WARNING: Force mode enabled, skipping configuration checks.|@"));
            return;
        }
        if (!Files.exists(jvmOptionsFile, new LinkOption[0])) {
            throw new IllegalStateException("jvm.options file does not exist: " + String.valueOf(jvmOptionsFile));
        }
        if (!Files.isReadable(jvmOptionsFile)) {
            throw new IllegalStateException("jvm.options file is not readable: " + String.valueOf(jvmOptionsFile));
        }
        ConfigurationService.validateJvmOptionsContent(jvmOptionsFile);
    }

    protected static void validateJvmOptionsContent(Path jvmOptionsFile) {
        try {
            String[] fipsProperties;
            long size = Files.size(jvmOptionsFile);
            if (size == 0L) {
                throw new IllegalStateException("jvm.options file is empty: " + String.valueOf(jvmOptionsFile));
            }
            String content = Files.readString(jvmOptionsFile, StandardCharsets.UTF_8);
            for (String property : fipsProperties = new String[]{"-Djavax.net.ssl.trustStore", "-Djavax.net.ssl.trustStorePassword", "-Djavax.net.ssl.trustStoreType", "-Djavax.net.ssl.trustStoreProvider"}) {
                if (!content.contains(property)) continue;
                throw new IllegalStateException("FIPS demo configuration already exists in jvm.options. Found: '" + property + "'. Please remove existing configuration before running this installer, or use the '--force option'");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read jvm.options file: " + e.getMessage(), e);
        }
    }

    public void writeSecurityConfigToJvmOptionsFile(ConfigurationProperties properties, Path confPath) {
        Path jvmOptionsFile = confPath.resolve("jvm.options");
        String configHeader = "\n################################################################\n## Start OpenSearch FIPS Demo Configuration\n## WARNING: revise all the lines below before you go into production\n################################################################\n\n";
        String configFooter = "################################################################\n";
        try {
            StringBuilder configBuilder = new StringBuilder(configHeader);
            Map<String, String> configMap = Map.of("javax.net.ssl.trustStore", properties.trustStorePath(), "javax.net.ssl.trustStorePassword", properties.trustStorePassword(), "javax.net.ssl.trustStoreType", properties.trustStoreType(), "javax.net.ssl.trustStoreProvider", properties.trustStoreProvider());
            for (Map.Entry<String, String> entry : configMap.entrySet()) {
                configBuilder.append("-D").append(entry.getKey()).append("=").append(entry.getValue());
                configBuilder.append(System.lineSeparator());
            }
            configBuilder.append(configFooter);
            Files.writeString(jvmOptionsFile, (CharSequence)configBuilder.toString(), StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception writing security configuration to jvm.options: " + e.getMessage(), e);
        }
    }
}

