/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.privileges.PrivilegesConfigurationValidationException;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.dlsfls.AbstractRuleBasedPrivileges;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.support.WildcardMatcher;

public class FieldPrivileges
extends AbstractRuleBasedPrivileges<FlsRule, FlsRule> {
    public FieldPrivileges(SecurityDynamicConfiguration<RoleV7> roles, Map<String, IndexAbstraction> indexMetadata, Settings settings) {
        super(roles, indexMetadata, FieldPrivileges::roleToRule, settings);
    }

    static FlsRule roleToRule(RoleV7.Index rolePermissions) throws PrivilegesConfigurationValidationException {
        List<String> flsPatterns = rolePermissions.getFls();
        if (flsPatterns != null && !flsPatterns.isEmpty()) {
            return FlsRule.from(rolePermissions);
        }
        return null;
    }

    @Override
    protected FlsRule unrestricted() {
        return FlsRule.ALLOW_ALL;
    }

    @Override
    protected FlsRule fullyRestricted() {
        return FlsRule.DENY_ALL;
    }

    @Override
    protected FlsRule compile(PrivilegesEvaluationContext context, Collection<FlsRule> rules) throws PrivilegesEvaluationException {
        return FlsRule.merge(rules);
    }

    static String normalizeFieldName(String field) {
        if (field == null) {
            return "__null__";
        }
        if (field.endsWith(".keyword")) {
            return field.substring(0, field.length() - ".keyword".length());
        }
        return field;
    }

    public static class FlsRule
    extends AbstractRuleBasedPrivileges.Rule {
        public static final FlsRule ALLOW_ALL = new FlsRule((Collection<FlsPattern>)ImmutableList.of(), (Collection<FlsPattern>)ImmutableList.of(), (ImmutableList<RoleV7.Index>)ImmutableList.of());
        public static final FlsRule DENY_ALL = new FlsRule((Collection<FlsPattern>)ImmutableList.of((Object)FlsPattern.EXCLUDE_ALL), (Collection<FlsPattern>)ImmutableList.of(), (ImmutableList<RoleV7.Index>)ImmutableList.of());
        final ImmutableList<RoleV7.Index> sourceRole;
        final ImmutableList<FlsPattern> patterns;
        final ImmutableList<FlsPattern> effectivePatterns;
        final ImmutableList<FlsPattern> objectOnlyPatterns;
        final boolean allowAll;
        final boolean excluding;

        static FlsRule of(String ... rules) throws PrivilegesConfigurationValidationException {
            return FlsRule.from(FlsPattern.parse(Arrays.asList(rules)), (ImmutableList<RoleV7.Index>)ImmutableList.of());
        }

        static FlsRule from(RoleV7.Index role) throws PrivilegesConfigurationValidationException {
            return FlsRule.from(FlsPattern.parse(role.getFls()), (ImmutableList<RoleV7.Index>)ImmutableList.of((Object)role));
        }

        static FlsRule from(List<FlsPattern> flsPatterns, ImmutableList<RoleV7.Index> sourceRoles) throws PrivilegesConfigurationValidationException {
            HashSet<FlsPattern> flsPatternsIncludingObjectsOnly = new HashSet<FlsPattern>();
            for (FlsPattern flsPattern : flsPatterns) {
                flsPatternsIncludingObjectsOnly.addAll(flsPattern.getParentObjectPatterns());
            }
            flsPatternsIncludingObjectsOnly.removeAll(flsPatterns);
            return new FlsRule(flsPatterns, flsPatternsIncludingObjectsOnly, sourceRoles);
        }

        static FlsRule merge(Collection<FlsRule> rules) {
            if (rules.size() == 1) {
                return rules.iterator().next();
            }
            HashSet<FlsPattern> patterns = new HashSet<FlsPattern>();
            HashSet<FlsPattern> objectOnlyPatterns = new HashSet<FlsPattern>();
            ImmutableList.Builder roles = ImmutableList.builderWithExpectedSize((int)rules.size());
            for (FlsRule flsRule : rules) {
                patterns.addAll((Collection<FlsPattern>)flsRule.patterns);
                objectOnlyPatterns.addAll((Collection<FlsPattern>)flsRule.objectOnlyPatterns);
                roles.addAll(flsRule.sourceRole);
            }
            objectOnlyPatterns.removeAll(patterns);
            return new FlsRule(patterns, objectOnlyPatterns, (ImmutableList<RoleV7.Index>)roles.build());
        }

        FlsRule(Collection<FlsPattern> patterns, Collection<FlsPattern> flsPatternsIncludingObjectsOnly, ImmutableList<RoleV7.Index> sourceRole) {
            this.sourceRole = sourceRole;
            HashSet<FlsPattern> flsPatternsExcluding = new HashSet<FlsPattern>(patterns.size());
            HashSet<FlsPattern> flsPatternsIncluding = new HashSet<FlsPattern>(patterns.size());
            for (FlsPattern flsPattern : patterns) {
                if (flsPattern.isExcluded()) {
                    flsPatternsExcluding.add(flsPattern);
                    continue;
                }
                flsPatternsIncluding.add(flsPattern);
            }
            int exclusions = flsPatternsExcluding.size();
            int inclusions = flsPatternsIncluding.size();
            if (exclusions == 0 && inclusions == 0) {
                this.effectivePatterns = this.patterns = ImmutableList.of((Object)FlsPattern.INCLUDE_ALL);
                this.excluding = false;
                this.allowAll = true;
            } else if (exclusions != 0 && inclusions == 0) {
                this.effectivePatterns = this.patterns = ImmutableList.copyOf(flsPatternsExcluding);
                this.excluding = true;
                this.allowAll = false;
            } else if (exclusions == 0 && inclusions != 0) {
                this.effectivePatterns = this.patterns = ImmutableList.copyOf(flsPatternsIncluding);
                this.excluding = false;
                this.allowAll = flsPatternsIncluding.contains(FlsPattern.INCLUDE_ALL);
            } else {
                this.patterns = ImmutableList.copyOf(patterns);
                this.effectivePatterns = ImmutableList.copyOf(flsPatternsExcluding);
                this.excluding = true;
                this.allowAll = false;
            }
            this.objectOnlyPatterns = ImmutableList.copyOf(flsPatternsIncludingObjectsOnly);
        }

        public boolean isAllowedAssumingParentsAreAllowed(String field) {
            if (this.isAllowAll()) {
                return true;
            }
            return this.isAllowedNonRecursive(FieldPrivileges.normalizeFieldName(field));
        }

        public boolean isObjectAllowedAssumingParentsAreAllowed(String field) {
            if (this.excluding) {
                return this.isAllowedAssumingParentsAreAllowed(field);
            }
            for (FlsPattern pattern : this.objectOnlyPatterns) {
                if (!pattern.getPattern().test(field)) continue;
                return true;
            }
            return false;
        }

        public boolean isAllowedRecursive(String field) {
            if (this.isAllowAll()) {
                return true;
            }
            field = FieldPrivileges.normalizeFieldName(field);
            if (this.excluding) {
                if (!this.isAllowedNonRecursive(field)) {
                    return false;
                }
                int dot = field.lastIndexOf(46);
                while (dot != -1) {
                    if (!this.isAllowedNonRecursive(field.substring(0, dot))) {
                        return false;
                    }
                    dot = field.lastIndexOf(46, dot - 1);
                }
                return true;
            }
            if (this.isAllowedNonRecursive(field)) {
                return true;
            }
            int dot = field.lastIndexOf(46);
            while (dot != -1) {
                if (this.isAllowedNonRecursive(field.substring(0, dot))) {
                    return true;
                }
                dot = field.lastIndexOf(46, dot - 1);
            }
            return false;
        }

        private boolean isAllowedNonRecursive(String field) {
            if (this.excluding) {
                for (FlsPattern pattern : this.effectivePatterns) {
                    assert (pattern.isExcluded());
                    if (!pattern.getPattern().test(field)) continue;
                    return false;
                }
                return true;
            }
            for (FlsPattern pattern : this.effectivePatterns) {
                assert (!pattern.isExcluded());
                if (!pattern.getPattern().test(field)) continue;
                return true;
            }
            return false;
        }

        public boolean isAllowAll() {
            return this.allowAll;
        }

        public String toString() {
            if (this.isAllowAll()) {
                return "FLS:*";
            }
            return "FLS:" + String.valueOf(this.patterns);
        }

        public List<String> getSource() {
            return (List)this.patterns.stream().map(FlsPattern::getSource).collect(ImmutableList.toImmutableList());
        }

        @Override
        public boolean isUnrestricted() {
            return this.isAllowAll();
        }
    }

    public static class FlsPattern {
        public static final FlsPattern INCLUDE_ALL = new FlsPattern(WildcardMatcher.ANY, false, "*");
        public static final FlsPattern EXCLUDE_ALL = new FlsPattern(WildcardMatcher.ANY, true, "~*");
        private final boolean excluded;
        private final WildcardMatcher pattern;
        private final String source;

        public FlsPattern(String string) throws PrivilegesConfigurationValidationException {
            try {
                if (string.startsWith("~") || string.startsWith("!")) {
                    this.excluded = true;
                    this.pattern = WildcardMatcher.from(string.substring(1));
                } else {
                    this.pattern = WildcardMatcher.from(string);
                    this.excluded = false;
                }
                this.source = string;
            }
            catch (PatternSyntaxException e) {
                throw new PrivilegesConfigurationValidationException("Invalid FLS pattern " + string, e);
            }
        }

        FlsPattern(WildcardMatcher pattern, boolean excluded, String source) {
            this.pattern = pattern;
            this.excluded = excluded;
            this.source = source;
        }

        public String getSource() {
            return this.source;
        }

        public WildcardMatcher getPattern() {
            return this.pattern;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public String toString() {
            return this.source;
        }

        List<FlsPattern> getParentObjectPatterns() {
            if (this.excluded || this.source.indexOf(46) == -1 || this.source.startsWith("/") && this.source.endsWith("/")) {
                return Collections.emptyList();
            }
            ArrayList<FlsPattern> subPatterns = new ArrayList<FlsPattern>();
            int pos = this.source.indexOf(46);
            while (pos != -1) {
                String subString = this.source.substring(0, pos);
                subPatterns.add(new FlsPattern(WildcardMatcher.from(subString), false, subString));
                pos = this.source.indexOf(46, pos + 1);
            }
            return subPatterns;
        }

        public boolean equals(Object o) {
            if (o instanceof FlsPattern) {
                FlsPattern that = (FlsPattern)o;
                return this.source.equals(that.source);
            }
            return false;
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public static List<FlsPattern> parse(List<String> flsPatternStrings) throws PrivilegesConfigurationValidationException {
            ArrayList<FlsPattern> flsPatterns = new ArrayList<FlsPattern>(flsPatternStrings.size());
            for (String flsPatternSource : flsPatternStrings) {
                flsPatterns.add(new FlsPattern(flsPatternSource));
            }
            return flsPatterns;
        }
    }
}

