/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core.schedule;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/alerting/core/schedule/JobSchedulerMetrics;", "Lorg/opensearch/core/xcontent/ToXContentFragment;", "Lorg/opensearch/core/common/io/stream/Writeable;", "scheduledJobId", "", "lastExecutionTime", "", "runningOnTime", "", "<init>", "(Ljava/lang/String;Ljava/lang/Long;Z)V", "si", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getScheduledJobId", "()Ljava/lang/String;", "getLastExecutionTime", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getRunningOnTime", "()Z", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "alerting-core"})
public final class JobSchedulerMetrics
implements ToXContentFragment,
Writeable {
    @NotNull
    private final String scheduledJobId;
    @Nullable
    private final Long lastExecutionTime;
    private final boolean runningOnTime;

    @NotNull
    public final String getScheduledJobId() {
        return this.scheduledJobId;
    }

    @Nullable
    public final Long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    public final boolean getRunningOnTime() {
        return this.runningOnTime;
    }

    public JobSchedulerMetrics(@NotNull String scheduledJobId, @Nullable Long lastExecutionTime, boolean runningOnTime) {
        Intrinsics.checkNotNullParameter((Object)scheduledJobId, (String)"scheduledJobId");
        this.scheduledJobId = scheduledJobId;
        this.lastExecutionTime = lastExecutionTime;
        this.runningOnTime = runningOnTime;
    }

    public JobSchedulerMetrics(@NotNull StreamInput si) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        String string = si.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this.scheduledJobId = string;
        this.lastExecutionTime = si.readOptionalLong();
        this.runningOnTime = si.readBoolean();
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.scheduledJobId);
        out.writeOptionalLong(this.lastExecutionTime);
        out.writeBoolean(this.runningOnTime);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.lastExecutionTime != null) {
            builder.timeField("last_execution_time", "last_execution_time_in_millis", Instant.ofEpochMilli(this.lastExecutionTime).toEpochMilli());
        }
        builder.field("running_on_time", this.runningOnTime);
        return builder;
    }
}

