/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.xcontent;

import java.io.IOException;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.spark.execution.statement.StatementId;
import org.opensearch.sql.spark.execution.statement.StatementModel;
import org.opensearch.sql.spark.execution.statement.StatementState;
import org.opensearch.sql.spark.execution.xcontent.XContentSerializer;
import org.opensearch.sql.spark.execution.xcontent.XContentSerializerUtil;
import org.opensearch.sql.spark.rest.model.LangType;

public class StatementModelXContentSerializer
implements XContentSerializer<StatementModel> {
    public static final String STATEMENT_DOC_TYPE = "statement";
    public static final String STATEMENT_ID = "statementId";
    public static final String LANG = "lang";
    public static final String QUERY = "query";
    public static final String QUERY_ID = "queryId";
    public static final String SUBMIT_TIME = "submitTime";
    public static final String UNKNOWN = "";

    @Override
    public XContentBuilder toXContent(StatementModel statementModel, ToXContent.Params params) throws IOException {
        return XContentFactory.jsonBuilder().startObject().field("version", statementModel.getVersion()).field("type", STATEMENT_DOC_TYPE).field("state", statementModel.getStatementState().getState()).field(STATEMENT_ID, statementModel.getStatementId().getId()).field("sessionId", statementModel.getSessionId()).field("accountId", statementModel.getAccountId()).field("applicationId", statementModel.getApplicationId()).field("jobId", statementModel.getJobId()).field(LANG, statementModel.getLangType().getText()).field("dataSourceName", statementModel.getDatasourceName()).field(QUERY, statementModel.getQuery()).field(QUERY_ID, statementModel.getQueryId()).field(SUBMIT_TIME, statementModel.getSubmitTime()).field("error", statementModel.getError()).endObject();
    }

    @Override
    public StatementModel fromXContent(XContentParser parser, long seqNo, long primaryTerm) {
        StatementModel.StatementModelBuilder<?, ?> builder = StatementModel.builder();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block34: while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "version": {
                    builder.version(parser.text());
                    continue block34;
                }
                case "type": {
                    continue block34;
                }
                case "state": {
                    builder.statementState(StatementState.fromString(parser.text()));
                    continue block34;
                }
                case "statementId": {
                    builder.statementId(new StatementId(parser.text()));
                    continue block34;
                }
                case "sessionId": {
                    builder.sessionId(parser.text());
                    continue block34;
                }
                case "accountId": {
                    builder.accountId(parser.textOrNull());
                    continue block34;
                }
                case "applicationId": {
                    builder.applicationId(parser.text());
                    continue block34;
                }
                case "jobId": {
                    builder.jobId(parser.text());
                    continue block34;
                }
                case "lang": {
                    builder.langType(LangType.fromString(parser.text()));
                    continue block34;
                }
                case "dataSourceName": {
                    builder.datasourceName(parser.text());
                    continue block34;
                }
                case "query": {
                    builder.query(parser.text());
                    continue block34;
                }
                case "queryId": {
                    builder.queryId(parser.text());
                    continue block34;
                }
                case "submitTime": {
                    builder.submitTime(parser.longValue());
                    continue block34;
                }
                case "error": {
                    builder.error(parser.text());
                    continue block34;
                }
            }
            throw new IllegalArgumentException("Unexpected field: " + fieldName);
        }
        builder.metadata(XContentSerializerUtil.buildMetadata(seqNo, primaryTerm));
        return builder.build();
    }
}

